/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class SelectSharedChildObjectsAction
extends JosmAction {
    public SelectSharedChildObjectsAction() {
        super(I18n.tr("Select shared child objects", new Object[0]), "select_shared_children", I18n.tr("Select child objects (way nodes and relation members) that are shared by all objects in the current selection", new Object[0]), Shortcut.registerShortcut("selection:sharedchildobjects", I18n.tr("Selection: {0}", I18n.tr("Shared Child Objects", new Object[0])), 65535, 5000), true);
        this.setHelpId(HelpUtil.ht("/Action/SelectSharedChildObjectsAction"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Collection<?> selection = this.getLayerManager().getActiveData().getSelected();
        Set<? extends IPrimitive> shared = SelectSharedChildObjectsAction.getSharedChildren(selection);
        this.getLayerManager().getActiveData().setSelected(shared);
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection(true);
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(!Utils.isEmpty(selection));
    }

    private static Set<? extends IPrimitive> getSharedChildren(Collection<? extends IPrimitive> selection) {
        HashSet sharedChildObjects = new HashSet(selection.stream().findAny().map(IPrimitive::getChildren).orElse(Collections.emptyList()));
        for (IPrimitive iPrimitive : selection) {
            if (sharedChildObjects.isEmpty()) break;
            sharedChildObjects.retainAll(iPrimitive.getChildren());
        }
        return sharedChildObjects;
    }
}

