'\"
'\" Generated from file 'critcl_tcl9\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) Jean-Claude Wippler
'\" Copyright (c) Steve Landers
'\" Copyright (c) 2011-2024 Andreas Kupries
'\"
.TH "critcl_tcl9" n 3\&.3\&.1 doc "C Runtime In Tcl (CriTcl)"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
critcl_tcl9 \- How To Adapt Critcl Packages for Tcl 9
.SH DESCRIPTION
.PP
Be welcome to the \fIC Runtime In Tcl\fR (short: \fICriTcl\fR), a system for embedding and using C
code from within \fITcl\fR [http://core\&.tcl-lang\&.org/tcl] scripts\&.
.PP
This guide contains notes and actions to take by writers of \fICriTcl\fR-based
packages to make their code workable for both Tcl 8\&.6 and 9\&.
.IP [1]
Generally, if there is no interest in moving to Tcl 9, i\&.e\&. Tcl 8\&.[456]
are the only supported runtimes, then just keep using \fICriTcl\fR \fB3\&.2\fR\&.
.sp
The remainder of this document can be ignored\&.
.IP [2]
Use \fICriTcl\fR version 3\&.3\&.1 \fIif, and only if\fR
Tcl 9 support is wanted\&.
.sp
With some work this will then also provide backward compatibility with Tcl 8\&.6\&.
.IP [3]
Header "\fItcl\&.h\fR"
.sp
Replace any inclusion of Tcl's public "\fItcl\&.h\fR" header file in the package's
C code with the inclusion of \fICriTcl\fR's new header file "\fItclpre9compat\&.h\fR"\&.
.sp
This includes "\fItcl\&.h\fR" and further provides a set of compatibility definitions
which make supporting both Tcl 8\&.6 and Tcl 9 in a single code base easier\&.
.sp
The following notes assume that this compatibility layer is in place\&.
.IP [4]
\fBcritcl::tcl\fR
.sp
Before \fICriTcl\fR 3\&.3\&.1 a single default (\fB8\&.4\fR) was used for
the minimum Tcl version, to be overriden by an explicit \fBcritcl::tcl\fR in the
package code\&.
.sp
Now the default is dynamic, based on the \fIruntime\fR version, i\&.e\&.
\fBpackage provide Tcl\fR, \fICriTcl\fR is run with/on\&.
.sp
When running on Tcl 9 the new default is version \fB9\fR, and \fB8\&.6\fR else\&.
\fINote\fR how this other default was bumped up from \fB8\&.4\fR\&.
.sp
As a consequence it is possible to
.RS
.IP [1]
Support just Tcl 8\&.4+, 8\&.5+, by having an explicit \fBcritcl::tcl 8\&.x\fR in
the package code\&.
.sp
\fIRemember however\fR, it is better to simply stick with
\fICriTcl\fR \fB3\&.2\fR for this\&.
.IP [2]
Support just Tcl 9 by having an explicit \fBcritcl::tcl 9\fR in the package code\&.
.IP [3]
Support both Tcl 8\&.6 and Tcl 9 (but not 8\&.4/8\&.5) by leaving \fBcritcl::tcl\fR out of the code
and using the proper \fBtclsh\fR version to run \fICriTcl\fR with\&.
.RE
.IP [5]
Code checking
.sp
\fICriTcl\fR 3\&.3\&.1 comes with a very basic set of code checks pointing
out places where compatibility might or will be an issue\&.
.sp
The implementation checks all inlined C code declared by \fBcritcl::ccode\fR,
\fBcritcl::ccommand\fR, \fBcritcl::cproc\fR (and related/derived commands), as well
as the C companion files declared with \fBcritcl::csources\fR\&.
.sp
It is very basic because it simply greps the code line by line for a number
of patterns and reports on their presence\&. The C code is not fully parsed\&.
The check can and will report pattern found in C code comments, for example\&.
.sp
The main patterns deal with functions affected by the change to \fBTcl_Size\fR,
the removal of old-style interpreter state handling, and command creation\&.
.sp
A warning message is printed for all detections\&.
.sp
This is disabled for the \fBTcl_Size\fR-related pattern if the line also matches
the pattern \fB*OK tcl9*\fR\&.
.sp
In this way all places in the code already handled can be marked and excluded
from the warnings\&.
.RS
.IP [1]
Interpreter State handling
.sp
Tcl 9 removed the type \fBTcl_SavedResult\fR and its associated functions
\fBTcl_SaveResult\fR, \fBTcl_RestoreResult\fR, and \fBTcl_DiscardResult\fR\&.
.sp
When a package uses this type and the related functions a rewrite is necessary\&.
.sp
With Tcl 9 use of type \fBTcl_InterpState\fR and its functions
\fBTcl_SaveInterpState\fR, \fBTcl_RestoreInterpState\fR, and
\fBTcl_DiscardInterpState\fR is now required\&.
.sp
As these were introduced with Tcl 8\&.5 the rewrite gives us compatibility with
Tcl 8\&.6 for free\&.
.IP [2]
\fBTcl_Size\fR
.sp
One of the main changes introduced with Tcl 9 is the breaking of the 2G barrier
for the number of bytes in a string, elements in a list, etc\&.
In a lot of interfaces \fBint\fR was replaced with \fBTcl_Size\fR, which is
effectively \fBptrdiff_t\fR behind the scenes\&.
.sp
The "\fItclpre9compat\&.h\fR" header mentioned above provides a suitable definition
of \fBTcl_Size\fR for \fB8\&.6\fR, i\&.e\&. maps it to \fBint\fR\&.
This enables the package code to use \fBTcl_Size\fR everywhere and still have it
work for both Tcl 8\&.6 and 9\&.
.sp
It is of course necessary to rewrite the package code to use \fBTcl_Size\fR\&.
.sp
The checker reports all lines in the C code using a function whose signature
was changed to use \fBTcl_Size\fR over \fBint\fR\&.
.sp
Note that it is necessary to manually check the package code for places where
a \fB%d\fR text formatting specification should be replaced with
\fBTCL_SIZE_FMT\fR\&.
.sp
I\&.e\&. all places where \fBTcl_Size\fR values are formatted with \fBprintf\fR-style
functions a formatting string
.CS

"\&.\&.\&. %d \&.\&.\&."
.CE
.IP has to be replaced with
.CS

"\&.\&.\&. " TCL_SIZE_FMT " \&.\&.\&."
.CE
.sp
The macro \fBTCL_SIZE_FMT\fR is defined by Critcl's compatibility layer, as an
extension of the \fBTCL_SIZE_MODIFIER\fR macro which only contains the
formatting modifier to insert into a plain \fB%d\fR to handle \fBTcl_Size\fR
values\&.
.sp
\fINote\fR how the original formatting string is split into multiple strings\&.
The C compiler will fuse these back together into a single string\&.
.IP [3]
Command creation\&.
.sp
This is technically a part of the \fBTcl_Size\fR changes\&.
.sp
All places using \fBTcl_CreateObjCommand\fR have to be rewritten to use
\fBTcl_CreateObjCommand2\fR instead, and the registered command functions
to use \fBTcl_Size\fR for their \fIobjc\fR argument\&.
.sp
The "\fItclpre9compat\&.h\fR" header maps this back to the old function
when compilation is done against Tcl 8\&.6\&.
.sp
\fICriTcl\fR does this itself for the commands created via \fBcritcl::ccommand\fR,
\fBcritcl::cproc\fR, and derived places (\fBcritcl::class\fR)\&.
.IP [4]
TIP 494\&. This TIP adds three semantic constants wrapping \fB-1\fR to Tcl 9 to
make the meaning of code clearer\&. As part of this it also casts the constant to the
proper type\&. They are:
.RS
.IP \(bu
\fBTCL_IO_FAILURE\fR
.IP \(bu
\fBTCL_AUTO_LENGTH\fR
.IP \(bu
\fBTCL_INDEX_NONE\fR
.RE
.sp
Critcl's compatibility layer provides the same constants to Tcl 8\&.6\&.
.sp
Critcl's new checker highlights places where \fBTCL_AUTO_LENGTH\fR is suitable\&.
.sp
Doing this for the other two constants looks to require deeper and proper parsing
of C code, which the checker does not do\&.
.RE
.PP
.SH "ADDITIONAL REFERENCES"
.IP [1]
\fIhttps://wiki\&.tcl-lang\&.org/page/Porting+extensions+to+Tcl+9\fR
.IP [2]
\fIhttps://wiki\&.tcl-lang\&.org/page/Tcl+9+functions+using+Tcl%5FSize\fR
.IP [3]
\fIhttps://core\&.tcl-lang\&.org/tcl/wiki?name=Migrating%20scripts%20to%20Tcl%209\fR
.IP [4]
\fIhttps://core\&.tcl-lang\&.org/tcl/wiki?name=Migrating%20C%20extensions%20to%20Tcl%209\fR
.PP
.SH AUTHORS
Jean Claude Wippler, Steve Landers, Andreas Kupries
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report them at \fIhttps://github\&.com/andreas-kupries/critcl/issues\fR\&.
Ideas for enhancements you may have for either package, application,
and/or the documentation are also very welcome and should be reported
at \fIhttps://github\&.com/andreas-kupries/critcl/issues\fR as well\&.
.SH KEYWORDS
C code, Embedded C Code, calling C code from Tcl, code generator, compile & run, compiler, dynamic code generation, dynamic compilation, generate package, linker, on demand compilation, on-the-fly compilation
.SH CATEGORY
Glueing/Embedded C code
.SH COPYRIGHT
.nf
Copyright (c) Jean-Claude Wippler
Copyright (c) Steve Landers
Copyright (c) 2011-2024 Andreas Kupries

.fi
