/*#######################################*/
/* Interface for static probing data     */
/*#######################################*/

#ifdef SWIGPYTHON

%inline %{
  /* tokenize string and create vector of doubles */
  PyObject *
  vrna_string_to_double_tuple(std::string s)
  {
    vrna_array(double)  c_vs;
    PyObject            *py_data;

    py_data = Py_None;
    c_vs    = vrna_str_to_dbl_array(s.c_str(), "\n", 0);

    if (c_vs) {
      py_data = PyTuple_New(vrna_array_size(c_vs));

      for (size_t i = 0; i < vrna_array_size(c_vs); i++) {
        PyObject *d = PyFloat_FromDouble( c_vs[i]);
        PyTuple_SET_ITEM(py_data, i, d);
      }
    }

    vrna_array_free(c_vs);

    return py_data;
  }
%}



%typemap(varout) const double   my_probing_data_prior_probing_1M7_paired[ANY] {
  /* create string from data */
  std::string str( probing_data_prior_probing_1M7_paired, probing_data_prior_probing_1M7_paired + sizeof (probing_data_prior_probing_1M7_paired) / sizeof (probing_data_prior_probing_1M7_paired[0]) );
  $result = vrna_string_to_double_tuple(str);
}

%rename (probing_data_prior_probing_1M7_paired) my_probing_data_prior_probing_1M7_paired;

%inline %{
 extern const double  my_probing_data_prior_probing_1M7_paired[];
%}

%ignore probing_data_prior_probing_1M7_paired;

%typemap(varout) const double   my_probing_data_prior_probing_1M7_unpaired[ANY] {
  /* create string from data */
  std::string str( probing_data_prior_probing_1M7_unpaired, probing_data_prior_probing_1M7_unpaired + sizeof (probing_data_prior_probing_1M7_unpaired) / sizeof (probing_data_prior_probing_1M7_unpaired[0]) );
  $result = vrna_string_to_double_tuple(str);
}

%rename (probing_data_prior_probing_1M7_unpaired) my_probing_data_prior_probing_1M7_unpaired;

%inline %{
 extern const double  my_probing_data_prior_probing_1M7_unpaired[];
%}

%ignore probing_data_prior_probing_1M7_unpaired;

%typemap(varout) const double   my_probing_data_prior_probing_DMS_paired[ANY] {
  /* create string from data */
  std::string str( probing_data_prior_probing_DMS_paired, probing_data_prior_probing_DMS_paired + sizeof (probing_data_prior_probing_DMS_paired) / sizeof (probing_data_prior_probing_DMS_paired[0]) );
  $result = vrna_string_to_double_tuple(str);
}

%rename (probing_data_prior_probing_DMS_paired) my_probing_data_prior_probing_DMS_paired;

%inline %{
 extern const double  my_probing_data_prior_probing_DMS_paired[];
%}

%ignore probing_data_prior_probing_DMS_paired;

%typemap(varout) const double   my_probing_data_prior_probing_DMS_unpaired[ANY] {
  /* create string from data */
  std::string str( probing_data_prior_probing_DMS_unpaired, probing_data_prior_probing_DMS_unpaired + sizeof (probing_data_prior_probing_DMS_unpaired) / sizeof (probing_data_prior_probing_DMS_unpaired[0]) );
  $result = vrna_string_to_double_tuple(str);
}

%rename (probing_data_prior_probing_DMS_unpaired) my_probing_data_prior_probing_DMS_unpaired;

%inline %{
 extern const double  my_probing_data_prior_probing_DMS_unpaired[];
%}

%ignore probing_data_prior_probing_DMS_unpaired;

#endif

#ifdef SWIGPERL5

%inline %{
  /* tokenize string and create vector of doubles */
  AV *
  vrna_string_to_double_array(std::string s)
  {
    vrna_array(double)  c_vs;
    AV*                 av;

    av    = (AV*)sv_2mortal((SV*)newAV());
    c_vs  = vrna_str_to_dbl_array(s.c_str(), "\n", 0);

    if (c_vs) {
      for (size_t i = 0; i < vrna_array_size(c_vs); i++) {
        SV *v = newSVnv(c_vs[i]);
        if (!av_store(av, i, v))
            SvREFCNT_dec(v);
      }
    }

    vrna_array_free(c_vs);

    return av;
  }
%}



%typemap(varout) const double   my_probing_data_prior_probing_1M7_paired[ANY] {
  std::string str( probing_data_prior_probing_1M7_paired, probing_data_prior_probing_1M7_paired + sizeof (probing_data_prior_probing_1M7_paired) / sizeof (probing_data_prior_probing_1M7_paired[0]) );
  sv_setsv($result, sv_2mortal(newRV_noinc((SV*) vrna_string_to_double_array(str) )));
}

%rename (probing_data_prior_probing_1M7_paired) my_probing_data_prior_probing_1M7_paired;

%inline %{
 extern const double  my_probing_data_prior_probing_1M7_paired[];
%}

%ignore probing_data_prior_probing_1M7_paired;

%typemap(varout) const double   my_probing_data_prior_probing_1M7_unpaired[ANY] {
  std::string str( probing_data_prior_probing_1M7_unpaired, probing_data_prior_probing_1M7_unpaired + sizeof (probing_data_prior_probing_1M7_unpaired) / sizeof (probing_data_prior_probing_1M7_unpaired[0]) );
  sv_setsv($result, sv_2mortal(newRV_noinc((SV*) vrna_string_to_double_array(str) )));
}

%rename (probing_data_prior_probing_1M7_unpaired) my_probing_data_prior_probing_1M7_unpaired;

%inline %{
 extern const double  my_probing_data_prior_probing_1M7_unpaired[];
%}

%ignore probing_data_prior_probing_1M7_unpaired;

%typemap(varout) const double   my_probing_data_prior_probing_DMS_paired[ANY] {
  std::string str( probing_data_prior_probing_DMS_paired, probing_data_prior_probing_DMS_paired + sizeof (probing_data_prior_probing_DMS_paired) / sizeof (probing_data_prior_probing_DMS_paired[0]) );
  sv_setsv($result, sv_2mortal(newRV_noinc((SV*) vrna_string_to_double_array(str) )));
}

%rename (probing_data_prior_probing_DMS_paired) my_probing_data_prior_probing_DMS_paired;

%inline %{
 extern const double  my_probing_data_prior_probing_DMS_paired[];
%}

%ignore probing_data_prior_probing_DMS_paired;

%typemap(varout) const double   my_probing_data_prior_probing_DMS_unpaired[ANY] {
  std::string str( probing_data_prior_probing_DMS_unpaired, probing_data_prior_probing_DMS_unpaired + sizeof (probing_data_prior_probing_DMS_unpaired) / sizeof (probing_data_prior_probing_DMS_unpaired[0]) );
  sv_setsv($result, sv_2mortal(newRV_noinc((SV*) vrna_string_to_double_array(str) )));
}

%rename (probing_data_prior_probing_DMS_unpaired) my_probing_data_prior_probing_DMS_unpaired;

%inline %{
 extern const double  my_probing_data_prior_probing_DMS_unpaired[];
%}

%ignore probing_data_prior_probing_DMS_unpaired;

#endif

%include  <ViennaRNA/static/probing_data_priors.h>
