/*
  File autogenerated by gengetopt version 2.23
  generated with the following command:
  /usr/bin/gengetopt -i RNAplot.ggo --file-name=RNAplot_cmdl --include-getopt --default-optional --unamed-opts --func-name=RNAplot_cmdline_parser --arg-struct-name=RNAplot_args_info

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif


#include "RNAplot_cmdl.h"

const char *RNAplot_args_info_purpose = "Draw RNA Secondary Structures";

const char *RNAplot_args_info_usage = "Usage: RNAplot [OPTIONS] [<input0>] [<input1>]...";

const char *RNAplot_args_info_versiontext = "";

const char *RNAplot_args_info_description = "The program reads (aligned) RNA sequences and structures in the format as\nproduced by RNAfold or Stockholm 1.0 and produces drawings of the secondary\nstructure graph.\nCoordinates for the structure graphs are produced using either E. Bruccoleri's\nnaview routines, or a simple radial layout method.\nFor aligned sequences and consensus structures (--msa option) the graph may be\nannotated by covariance information. Additionally, a color-annotated EPS\nalignment figure can be produced, similar to that obtained by RNAalifold and\nRNALalifold.\nIf the sequence was preceded by a FASTA header, or if the multiple sequence\nalignment contains an ID field, these IDs will be taken as names for the output\nfile(s): \"name_ss.ps\" and \"name_aln.ps\". Otherwise \"rna.ps\" and\n\"aln.ps\" will be used. This behavior may be over-ruled by explicitly setting\na filename prefix using the --auto-id option.\nExisting files of the same name will be overwritten.\n";

const char *RNAplot_args_info_detailed_help[] = {
  "  -h, --help                    Print help and exit",
  "      --detailed-help           Print help, including all details and hidden\n                                  options, and exit",
  "      --full-help               Print help, including hidden options, and exit",
  "  -V, --version                 Print version and exit",
  "  -v, --verbose                 Be verbose.\n                                    (default=off)",
  "  Lower the log level setting such that even INFO messages are passed through.\n\n",
  "\nI/O Options:",
  "  Command line options for input and output (pre-)processing\n\n",
  "  -i, --infile=<filename>       Read a file instead of reading from stdin.",
  "  The default behavior of RNAplot is to read input from stdin or the file(s)\n  that follow(s) the RNAplot command. Using this parameter the user can specify\n  input file names where data is read from. Note, that any additional files\n  supplied to RNAplot are still processed as well.\n",
  "  -a, --msa                     Input is multiple sequence alignment in\n                                  Stockholm 1.0 format.  (default=off)",
  "  Using this flag indicates that the input is a multiple sequence alignment\n  (MSA) instead of (a) single sequence(s). Note, that only STOCKHOLM format\n  allows one to specify a consensus structure. Therefore, this is the only\n  supported MSA format for now!\n",
  "      --mis                     Output \"most informative sequence\" instead of\n                                  simple consensus  (default=off)",
  "  For each column of the alignment output this is the set of nucleotides with\n  frequency greater than average in IUPAC notation.\n",
  "  -j, --jobs[=number]           Split batch input into jobs and start\n                                  processing in parallel using multiple\n                                  threads.  (default=`0')",
  "  Default processing of input data is performed in a serial fashion, i.e. one\n  sequence at a time. Using this switch, a user can instead start the\n  computation for many sequences in the input in parallel. RNAplot will create\n  as many parallel computation slots as specified and assigns input sequences\n  of the input file(s) to the available slots. Note, that this increases memory\n  consumption since input alignments have to be kept in memory until an empty\n  compute slot is available and each running job requires its own dynamic\n  programming matrices. A value of 0 indicates to use as many parallel threads\n  as computation cores are available.\n",
  "  -f, --output-format=format    Specify output file format.  (possible\n                                  values=\"eps\", \"svg\", \"gml\", \"xrna\",\n                                  \"ssv\" default=`eps')",
  "  Available formats are: Encapsulated PostScript ('eps'), Scalable Vector\n  Graphics ('svg'), Graph Meta Language ('gml'), and XRNA save file ('xrna').\n  Output filenames will end in \".eps\" \".gml\" \".svg\" \".ss\",\n  respectively.\n",
  "      --pre=string              Add annotation macros to postscript file, and\n                                  add the postscript code in \"string\" just\n                                  before the code to draw the structure. This\n                                  is an easy way to add annotation.",
  "      --post=string             Same as --pre but in contrast to adding the\n                                  annotation macros. E.g to mark position 15\n                                  with circle use --post=\"15 cmark\".",
  "      --auto-id                 Automatically generate an ID for each sequence.\n                                    (default=off)",
  "  The default mode of RNAfold is to automatically determine an ID from the\n  input sequence data if the input file format allows to do that. Sequence IDs\n  are usually given in the FASTA header of input sequences. If this flag is\n  active, RNAfold ignores any IDs retrieved from the input and automatically\n  generates an ID for each sequence. This ID consists of a prefix and an\n  increasing number. This flag can also be used to add a FASTA header to the\n  output even if the input has none.\n\n",
  "      --id-prefix=STRING        Prefix for automatically generated IDs (as used\n                                  in output file names).\n                                    (default=`sequence')",
  "  If this parameter is set, each sequence will be prefixed with the provided\n  string. Hence, the output files will obey the following naming scheme:\n  \"prefix_xxxx_ss.ps\" (secondary structure plot), \"prefix_xxxx_dp.ps\"\n  (dot-plot), \"prefix_xxxx_dp2.ps\" (stack probabilities), etc. where xxxx is\n  the sequence number. Note: Setting this parameter implies --auto-id.\n\n",
  "      --id-delim=CHAR           Change the delimiter between prefix and\n                                  increasing number for automatically generated\n                                  IDs (as used in output file names).\n                                    (default=`_')",
  "  This parameter can be used to change the default delimiter \"_\" between the\n  prefix string and the increasing number for automatically generated ID.\n\n",
  "      --id-digits=INT           Specify the number of digits of the counter in\n                                  automatically generated alignment IDs.\n                                    (default=`4')",
  "  When alignments IDs are automatically generated, they receive an increasing\n  number, starting with 1. This number will always be left-padded by leading\n  zeros, such that the number takes up a certain width. Using this parameter,\n  the width can be specified to the users need. We allow numbers in the range\n  [1:18]. This option implies --auto-id.\n\n",
  "      --id-start=LONG           Specify the first number in automatically\n                                  generated IDs.\n                                    (default=`1')",
  "  When sequence IDs are automatically generated, they receive an increasing\n  number, usually starting with 1. Using this parameter, the first number can\n  be specified to the users requirements. Note: negative numbers are not\n  allowed.\n  Note: Setting this parameter implies to ignore any IDs retrieved from the\n  input data, i.e. it activates the --auto-id flag.\n\n",
  "      --filename-delim=CHAR     Change the delimiting character used in\n                                  sanitized filenames.\n                                    (default=`ID-delimiter')",
  "  This parameter can be used to change the delimiting character used while\n  sanitizing filenames, i.e. replacing invalid characters. Note, that the\n  default delimiter ALWAYS is the first character of the \"ID delimiter\" as\n  supplied through the --id-delim option. If the delimiter is a whitespace\n  character or empty, invalid characters will be simply removed rather than\n  substituted. Currently, we regard the following characters as illegal for use\n  in filenames: backslash '\', slash '/', question mark '?', percent sign '%',\n  asterisk '*', colon ':', pipe symbol '|', double quote '\"', triangular\n  brackets '<' and '>'.\n\n",
  "      --filename-full           Use full FASTA header to create filenames.\n                                    (default=off)",
  "  This parameter can be used to deactivate the default behavior of limiting\n  output filenames to the first word of the sequence ID. Consider the following\n  example: An input with FASTA header '>NM_0001 Homo Sapiens some gene' usually\n  produces output files with the prefix \"NM_0001\" without the additional data\n  available in the FASTA header, e.g. \"NM_0001_ss.ps\" for secondary structure\n  plots. With this flag set, no truncation of the output filenames is done,\n  i.e. output filenames receive the full FASTA header data as prefixes. Note,\n  however, that invalid characters (such as whitespace) will be substituted by\n  a delimiting character or simply removed, (see also the parameter option\n  --filename-delim).\n\n",
  "      --log-level=level         Set log level threshold.\n                                    (default=`2')",
  "  By default, any log messages are filtered such that only warnings (level 2)\n  or errors (level 3) are printed. This setting allows for specifying the log\n  level threshold, where higher values result in fewer information. Log-level 5\n  turns off all messages, even errors and other critical information.\n\n",
  "      --log-file[=filename]     Print log messages to a file instead of stderr.\n                                    (default=`RNAplot.log')",
  "      --log-time                Include time stamp in log messages.\n\n                                    (default=off)",
  "      --log-call                Include file and line of log calling function.\n\n                                    (default=off)",
  "\nPlotting:",
  "  Command line options for changing the default behavior of structure layout\n  and pairing probability plots\n\n",
  "      --covar                   Annotate covariance of base pairs in consensus\n                                  structure.\n\n                                    (default=off)",
  "      --covar-threshold=FLOAT   Set the threshold of maximum counter examples\n                                  for coloring consensus structure plot.\n                                    (default=`2')",
  "  Floating point numbers between 0 and 1 are treated as frequencies among all\n  sequencesin the alignment. All other will be truncated to integer and used as\n  absolute number of counter\n  examples.\n\n",
  "      --covar-min-sat=FLOAT     Set the minimum saturation for coloring\n                                  consensus structure plot.\n                                    (default=`0.2')",
  "  Floating point number >= 0 and smaller than 1.\n\n",
  "      --aln                     Produce a colored and structure annotated\n                                  alignment in PostScript format in the file\n                                  \"aln.ps\" in the current directory.\n\n                                    (default=off)",
  "      --aln-EPS-cols=INT        Number of columns in colored EPS alignment\n                                  output.\n                                    (default=`60')",
  "  A value less than 1 indicates that the output should not be wrapped at all.\n\n",
  "  -t, --layout-type=INT         Choose the plotting layout algorithm.\n                                  (possible values=\"0\", \"1\", \"2\", \"3\",\n                                  \"4\" default=`1')",
  "  Select the layout algorithm that computes the nucleotide coordinates.\n  Currently, the following algorithms are available:\n   '0': simple radial layout\n\n   '1': Naview layout (Bruccoleri et al. 1988)\n\n   '2': circular layout\n\n   '3': RNAturtle (Wiegreffe et al. 2018)\n\n   '4': RNApuzzler (Wiegreffe et al. 2018)\n",
  "      --noOptimization          Disable the drawing space optimization of\n                                  RNApuzzler.\n\n                                    (default=off)",
  "      --ignoreExteriorIntersections\n                                Ignore intersections with the exterior loop\n                                  within the RNA-tree.\n\n                                    (default=off)",
  "      --ignoreAncestorIntersections\n                                Ignore ancestor intersections within the\n                                  RNA-tree.\n\n                                    (default=off)",
  "      --ignoreSiblingIntersections\n                                Ignore sibling intersections within the\n                                  RNA-tree.\n\n                                    (default=off)",
  "      --allowFlipping           Allow flipping of exterior loop branches to\n                                  resolve exterior branch intersections.\n\n                                    (default=off)",
  "\nIf in doubt our program is right, nature is at fault.\nComments should be sent to rna@tbi.univie.ac.at.\n\n",
    0
};
static void
init_full_help_array(void)
{
  RNAplot_args_info_full_help[0] = RNAplot_args_info_detailed_help[0];
  RNAplot_args_info_full_help[1] = RNAplot_args_info_detailed_help[1];
  RNAplot_args_info_full_help[2] = RNAplot_args_info_detailed_help[2];
  RNAplot_args_info_full_help[3] = RNAplot_args_info_detailed_help[3];
  RNAplot_args_info_full_help[4] = RNAplot_args_info_detailed_help[4];
  RNAplot_args_info_full_help[5] = RNAplot_args_info_detailed_help[6];
  RNAplot_args_info_full_help[6] = RNAplot_args_info_detailed_help[7];
  RNAplot_args_info_full_help[7] = RNAplot_args_info_detailed_help[8];
  RNAplot_args_info_full_help[8] = RNAplot_args_info_detailed_help[10];
  RNAplot_args_info_full_help[9] = RNAplot_args_info_detailed_help[12];
  RNAplot_args_info_full_help[10] = RNAplot_args_info_detailed_help[14];
  RNAplot_args_info_full_help[11] = RNAplot_args_info_detailed_help[16];
  RNAplot_args_info_full_help[12] = RNAplot_args_info_detailed_help[18];
  RNAplot_args_info_full_help[13] = RNAplot_args_info_detailed_help[19];
  RNAplot_args_info_full_help[14] = RNAplot_args_info_detailed_help[20];
  RNAplot_args_info_full_help[15] = RNAplot_args_info_detailed_help[22];
  RNAplot_args_info_full_help[16] = RNAplot_args_info_detailed_help[24];
  RNAplot_args_info_full_help[17] = RNAplot_args_info_detailed_help[26];
  RNAplot_args_info_full_help[18] = RNAplot_args_info_detailed_help[28];
  RNAplot_args_info_full_help[19] = RNAplot_args_info_detailed_help[30];
  RNAplot_args_info_full_help[20] = RNAplot_args_info_detailed_help[32];
  RNAplot_args_info_full_help[21] = RNAplot_args_info_detailed_help[34];
  RNAplot_args_info_full_help[22] = RNAplot_args_info_detailed_help[36];
  RNAplot_args_info_full_help[23] = RNAplot_args_info_detailed_help[37];
  RNAplot_args_info_full_help[24] = RNAplot_args_info_detailed_help[38];
  RNAplot_args_info_full_help[25] = RNAplot_args_info_detailed_help[39];
  RNAplot_args_info_full_help[26] = RNAplot_args_info_detailed_help[40];
  RNAplot_args_info_full_help[27] = RNAplot_args_info_detailed_help[41];
  RNAplot_args_info_full_help[28] = RNAplot_args_info_detailed_help[42];
  RNAplot_args_info_full_help[29] = RNAplot_args_info_detailed_help[44];
  RNAplot_args_info_full_help[30] = RNAplot_args_info_detailed_help[46];
  RNAplot_args_info_full_help[31] = RNAplot_args_info_detailed_help[47];
  RNAplot_args_info_full_help[32] = RNAplot_args_info_detailed_help[49];
  RNAplot_args_info_full_help[33] = RNAplot_args_info_detailed_help[51];
  RNAplot_args_info_full_help[34] = RNAplot_args_info_detailed_help[52];
  RNAplot_args_info_full_help[35] = RNAplot_args_info_detailed_help[53];
  RNAplot_args_info_full_help[36] = RNAplot_args_info_detailed_help[54];
  RNAplot_args_info_full_help[37] = RNAplot_args_info_detailed_help[55];
  RNAplot_args_info_full_help[38] = RNAplot_args_info_detailed_help[56];
  RNAplot_args_info_full_help[39] = 0; 
  
}

const char *RNAplot_args_info_full_help[40];

static void
init_help_array(void)
{
  RNAplot_args_info_help[0] = RNAplot_args_info_detailed_help[0];
  RNAplot_args_info_help[1] = RNAplot_args_info_detailed_help[1];
  RNAplot_args_info_help[2] = RNAplot_args_info_detailed_help[2];
  RNAplot_args_info_help[3] = RNAplot_args_info_detailed_help[3];
  RNAplot_args_info_help[4] = RNAplot_args_info_detailed_help[4];
  RNAplot_args_info_help[5] = RNAplot_args_info_detailed_help[6];
  RNAplot_args_info_help[6] = RNAplot_args_info_detailed_help[7];
  RNAplot_args_info_help[7] = RNAplot_args_info_detailed_help[8];
  RNAplot_args_info_help[8] = RNAplot_args_info_detailed_help[10];
  RNAplot_args_info_help[9] = RNAplot_args_info_detailed_help[12];
  RNAplot_args_info_help[10] = RNAplot_args_info_detailed_help[14];
  RNAplot_args_info_help[11] = RNAplot_args_info_detailed_help[16];
  RNAplot_args_info_help[12] = RNAplot_args_info_detailed_help[18];
  RNAplot_args_info_help[13] = RNAplot_args_info_detailed_help[19];
  RNAplot_args_info_help[14] = RNAplot_args_info_detailed_help[20];
  RNAplot_args_info_help[15] = RNAplot_args_info_detailed_help[22];
  RNAplot_args_info_help[16] = RNAplot_args_info_detailed_help[39];
  RNAplot_args_info_help[17] = RNAplot_args_info_detailed_help[40];
  RNAplot_args_info_help[18] = RNAplot_args_info_detailed_help[41];
  RNAplot_args_info_help[19] = RNAplot_args_info_detailed_help[46];
  RNAplot_args_info_help[20] = RNAplot_args_info_detailed_help[49];
  RNAplot_args_info_help[21] = RNAplot_args_info_detailed_help[56];
  RNAplot_args_info_help[22] = 0; 
  
}

const char *RNAplot_args_info_help[23];

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
  , ARG_INT
  , ARG_LONG
  , ARG_FLOAT
} RNAplot_cmdline_parser_arg_type;

static
void clear_given (struct RNAplot_args_info *args_info);
static
void clear_args (struct RNAplot_args_info *args_info);

static int
RNAplot_cmdline_parser_internal (int argc, char **argv, struct RNAplot_args_info *args_info,
                        struct RNAplot_cmdline_parser_params *params, const char *additional_error);

static int
RNAplot_cmdline_parser_required2 (struct RNAplot_args_info *args_info, const char *prog_name, const char *additional_error);

const char *RNAplot_cmdline_parser_output_format_values[] = {"eps", "svg", "gml", "xrna", "ssv", 0}; /*< Possible values for output-format. */
const char *RNAplot_cmdline_parser_layout_type_values[] = {"0", "1", "2", "3", "4", 0}; /*< Possible values for layout-type. */

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct RNAplot_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->detailed_help_given = 0 ;
  args_info->full_help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->infile_given = 0 ;
  args_info->msa_given = 0 ;
  args_info->mis_given = 0 ;
  args_info->jobs_given = 0 ;
  args_info->output_format_given = 0 ;
  args_info->pre_given = 0 ;
  args_info->post_given = 0 ;
  args_info->auto_id_given = 0 ;
  args_info->id_prefix_given = 0 ;
  args_info->id_delim_given = 0 ;
  args_info->id_digits_given = 0 ;
  args_info->id_start_given = 0 ;
  args_info->filename_delim_given = 0 ;
  args_info->filename_full_given = 0 ;
  args_info->log_level_given = 0 ;
  args_info->log_file_given = 0 ;
  args_info->log_time_given = 0 ;
  args_info->log_call_given = 0 ;
  args_info->covar_given = 0 ;
  args_info->covar_threshold_given = 0 ;
  args_info->covar_min_sat_given = 0 ;
  args_info->aln_given = 0 ;
  args_info->aln_EPS_cols_given = 0 ;
  args_info->layout_type_given = 0 ;
  args_info->noOptimization_given = 0 ;
  args_info->ignoreExteriorIntersections_given = 0 ;
  args_info->ignoreAncestorIntersections_given = 0 ;
  args_info->ignoreSiblingIntersections_given = 0 ;
  args_info->allowFlipping_given = 0 ;
}

static
void clear_args (struct RNAplot_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->verbose_flag = 0;
  args_info->infile_arg = NULL;
  args_info->infile_orig = NULL;
  args_info->msa_flag = 0;
  args_info->mis_flag = 0;
  args_info->jobs_arg = 0;
  args_info->jobs_orig = NULL;
  args_info->output_format_arg = gengetopt_strdup ("eps");
  args_info->output_format_orig = NULL;
  args_info->pre_arg = NULL;
  args_info->pre_orig = NULL;
  args_info->post_arg = NULL;
  args_info->post_orig = NULL;
  args_info->auto_id_flag = 0;
  args_info->id_prefix_arg = gengetopt_strdup ("sequence");
  args_info->id_prefix_orig = NULL;
  args_info->id_delim_arg = gengetopt_strdup ("_");
  args_info->id_delim_orig = NULL;
  args_info->id_digits_arg = 4;
  args_info->id_digits_orig = NULL;
  args_info->id_start_arg = 1;
  args_info->id_start_orig = NULL;
  args_info->filename_delim_arg = gengetopt_strdup ("ID-delimiter");
  args_info->filename_delim_orig = NULL;
  args_info->filename_full_flag = 0;
  args_info->log_level_arg = 2;
  args_info->log_level_orig = NULL;
  args_info->log_file_arg = gengetopt_strdup ("RNAplot.log");
  args_info->log_file_orig = NULL;
  args_info->log_time_flag = 0;
  args_info->log_call_flag = 0;
  args_info->covar_flag = 0;
  args_info->covar_threshold_arg = 2;
  args_info->covar_threshold_orig = NULL;
  args_info->covar_min_sat_arg = 0.2;
  args_info->covar_min_sat_orig = NULL;
  args_info->aln_flag = 0;
  args_info->aln_EPS_cols_arg = 60;
  args_info->aln_EPS_cols_orig = NULL;
  args_info->layout_type_arg = 1;
  args_info->layout_type_orig = NULL;
  args_info->noOptimization_flag = 0;
  args_info->ignoreExteriorIntersections_flag = 0;
  args_info->ignoreAncestorIntersections_flag = 0;
  args_info->ignoreSiblingIntersections_flag = 0;
  args_info->allowFlipping_flag = 0;
  
}

static
void init_args_info(struct RNAplot_args_info *args_info)
{
  init_full_help_array(); 
  init_help_array(); 
  args_info->help_help = RNAplot_args_info_detailed_help[0] ;
  args_info->detailed_help_help = RNAplot_args_info_detailed_help[1] ;
  args_info->full_help_help = RNAplot_args_info_detailed_help[2] ;
  args_info->version_help = RNAplot_args_info_detailed_help[3] ;
  args_info->verbose_help = RNAplot_args_info_detailed_help[4] ;
  args_info->infile_help = RNAplot_args_info_detailed_help[8] ;
  args_info->infile_min = 0;
  args_info->infile_max = 0;
  args_info->msa_help = RNAplot_args_info_detailed_help[10] ;
  args_info->mis_help = RNAplot_args_info_detailed_help[12] ;
  args_info->jobs_help = RNAplot_args_info_detailed_help[14] ;
  args_info->output_format_help = RNAplot_args_info_detailed_help[16] ;
  args_info->pre_help = RNAplot_args_info_detailed_help[18] ;
  args_info->post_help = RNAplot_args_info_detailed_help[19] ;
  args_info->auto_id_help = RNAplot_args_info_detailed_help[20] ;
  args_info->id_prefix_help = RNAplot_args_info_detailed_help[22] ;
  args_info->id_delim_help = RNAplot_args_info_detailed_help[24] ;
  args_info->id_digits_help = RNAplot_args_info_detailed_help[26] ;
  args_info->id_start_help = RNAplot_args_info_detailed_help[28] ;
  args_info->filename_delim_help = RNAplot_args_info_detailed_help[30] ;
  args_info->filename_full_help = RNAplot_args_info_detailed_help[32] ;
  args_info->log_level_help = RNAplot_args_info_detailed_help[34] ;
  args_info->log_file_help = RNAplot_args_info_detailed_help[36] ;
  args_info->log_time_help = RNAplot_args_info_detailed_help[37] ;
  args_info->log_call_help = RNAplot_args_info_detailed_help[38] ;
  args_info->covar_help = RNAplot_args_info_detailed_help[41] ;
  args_info->covar_threshold_help = RNAplot_args_info_detailed_help[42] ;
  args_info->covar_min_sat_help = RNAplot_args_info_detailed_help[44] ;
  args_info->aln_help = RNAplot_args_info_detailed_help[46] ;
  args_info->aln_EPS_cols_help = RNAplot_args_info_detailed_help[47] ;
  args_info->layout_type_help = RNAplot_args_info_detailed_help[49] ;
  args_info->noOptimization_help = RNAplot_args_info_detailed_help[51] ;
  args_info->ignoreExteriorIntersections_help = RNAplot_args_info_detailed_help[52] ;
  args_info->ignoreAncestorIntersections_help = RNAplot_args_info_detailed_help[53] ;
  args_info->ignoreSiblingIntersections_help = RNAplot_args_info_detailed_help[54] ;
  args_info->allowFlipping_help = RNAplot_args_info_detailed_help[55] ;
  
}

void
RNAplot_cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(RNAPLOT_CMDLINE_PARSER_PACKAGE_NAME) ? RNAPLOT_CMDLINE_PARSER_PACKAGE_NAME : RNAPLOT_CMDLINE_PARSER_PACKAGE),
     RNAPLOT_CMDLINE_PARSER_VERSION);

  if (strlen(RNAplot_args_info_versiontext) > 0)
    printf("\n%s\n", RNAplot_args_info_versiontext);
}

static void print_help_common(void)
{
	size_t len_purpose = strlen(RNAplot_args_info_purpose);
	size_t len_usage = strlen(RNAplot_args_info_usage);

	if (len_usage > 0) {
		printf("%s\n", RNAplot_args_info_usage);
	}
	if (len_purpose > 0) {
		printf("%s\n", RNAplot_args_info_purpose);
	}

	if (len_usage || len_purpose) {
		printf("\n");
	}

	if (strlen(RNAplot_args_info_description) > 0) {
		printf("%s\n\n", RNAplot_args_info_description);
	}
}

void
RNAplot_cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (RNAplot_args_info_help[i])
    printf("%s\n", RNAplot_args_info_help[i++]);
}

void
RNAplot_cmdline_parser_print_full_help (void)
{
  int i = 0;
  print_help_common();
  while (RNAplot_args_info_full_help[i])
    printf("%s\n", RNAplot_args_info_full_help[i++]);
}

void
RNAplot_cmdline_parser_print_detailed_help (void)
{
  int i = 0;
  print_help_common();
  while (RNAplot_args_info_detailed_help[i])
    printf("%s\n", RNAplot_args_info_detailed_help[i++]);
}

void
RNAplot_cmdline_parser_init (struct RNAplot_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);

  args_info->inputs = 0;
  args_info->inputs_num = 0;
}

void
RNAplot_cmdline_parser_params_init(struct RNAplot_cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct RNAplot_cmdline_parser_params *
RNAplot_cmdline_parser_params_create(void)
{
  struct RNAplot_cmdline_parser_params *params = 
    (struct RNAplot_cmdline_parser_params *)malloc(sizeof(struct RNAplot_cmdline_parser_params));
  RNAplot_cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}

/** @brief generic value variable */
union generic_value {
    int int_arg;
    long long_arg;
    float float_arg;
    char *string_arg;
    const char *default_string_arg;
};

/** @brief holds temporary values for multiple options */
struct generic_list
{
  union generic_value arg;
  char *orig;
  struct generic_list *next;
};

/**
 * @brief add a node at the head of the list 
 */
static void add_node(struct generic_list **list) {
  struct generic_list *new_node = (struct generic_list *) malloc (sizeof (struct generic_list));
  new_node->next = *list;
  *list = new_node;
  new_node->arg.string_arg = 0;
  new_node->orig = 0;
}


static void
free_multiple_string_field(unsigned int len, char ***arg, char ***orig)
{
  unsigned int i;
  if (*arg) {
    for (i = 0; i < len; ++i)
      {
        free_string_field(&((*arg)[i]));
        free_string_field(&((*orig)[i]));
      }
    free_string_field(&((*arg)[0])); /* free default string */

    free (*arg);
    *arg = 0;
    free (*orig);
    *orig = 0;
  }
}

static void
RNAplot_cmdline_parser_release (struct RNAplot_args_info *args_info)
{
  unsigned int i;
  free_multiple_string_field (args_info->infile_given, &(args_info->infile_arg), &(args_info->infile_orig));
  free_string_field (&(args_info->jobs_orig));
  free_string_field (&(args_info->output_format_arg));
  free_string_field (&(args_info->output_format_orig));
  free_string_field (&(args_info->pre_arg));
  free_string_field (&(args_info->pre_orig));
  free_string_field (&(args_info->post_arg));
  free_string_field (&(args_info->post_orig));
  free_string_field (&(args_info->id_prefix_arg));
  free_string_field (&(args_info->id_prefix_orig));
  free_string_field (&(args_info->id_delim_arg));
  free_string_field (&(args_info->id_delim_orig));
  free_string_field (&(args_info->id_digits_orig));
  free_string_field (&(args_info->id_start_orig));
  free_string_field (&(args_info->filename_delim_arg));
  free_string_field (&(args_info->filename_delim_orig));
  free_string_field (&(args_info->log_level_orig));
  free_string_field (&(args_info->log_file_arg));
  free_string_field (&(args_info->log_file_orig));
  free_string_field (&(args_info->covar_threshold_orig));
  free_string_field (&(args_info->covar_min_sat_orig));
  free_string_field (&(args_info->aln_EPS_cols_orig));
  free_string_field (&(args_info->layout_type_orig));
  
  
  for (i = 0; i < args_info->inputs_num; ++i)
    free (args_info->inputs [i]);

  if (args_info->inputs_num)
    free (args_info->inputs);

  clear_given (args_info);
}

/**
 * @param val the value to check
 * @param values the possible values
 * @return the index of the matched value:
 * -1 if no value matched,
 * -2 if more than one value has matched
 */
static int
check_possible_values(const char *val, const char *values[])
{
  int i, found, last;
  size_t len;

  if (!val)   /* otherwise strlen() crashes below */
    return -1; /* -1 means no argument for the option */

  found = last = 0;

  for (i = 0, len = strlen(val); values[i]; ++i)
    {
      if (strncmp(val, values[i], len) == 0)
        {
          ++found;
          last = i;
          if (strlen(values[i]) == len)
            return i; /* exact macth no need to check more */
        }
    }

  if (found == 1) /* one match: OK */
    return last;

  return (found ? -2 : -1); /* return many values or none matched */
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  int found = -1;
  if (arg) {
    if (values) {
      found = check_possible_values(arg, values);      
    }
    if (found >= 0)
      fprintf(outfile, "%s=\"%s\" # %s\n", opt, arg, values[found]);
    else
      fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}

static void
write_multiple_into_file(FILE *outfile, int len, const char *opt, char **arg, const char *values[])
{
  int i;
  
  for (i = 0; i < len; ++i)
    write_into_file(outfile, opt, (arg ? arg[i] : 0), values);
}

int
RNAplot_cmdline_parser_dump(FILE *outfile, struct RNAplot_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", RNAPLOT_CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->detailed_help_given)
    write_into_file(outfile, "detailed-help", 0, 0 );
  if (args_info->full_help_given)
    write_into_file(outfile, "full-help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->verbose_given)
    write_into_file(outfile, "verbose", 0, 0 );
  write_multiple_into_file(outfile, args_info->infile_given, "infile", args_info->infile_orig, 0);
  if (args_info->msa_given)
    write_into_file(outfile, "msa", 0, 0 );
  if (args_info->mis_given)
    write_into_file(outfile, "mis", 0, 0 );
  if (args_info->jobs_given)
    write_into_file(outfile, "jobs", args_info->jobs_orig, 0);
  if (args_info->output_format_given)
    write_into_file(outfile, "output-format", args_info->output_format_orig, RNAplot_cmdline_parser_output_format_values);
  if (args_info->pre_given)
    write_into_file(outfile, "pre", args_info->pre_orig, 0);
  if (args_info->post_given)
    write_into_file(outfile, "post", args_info->post_orig, 0);
  if (args_info->auto_id_given)
    write_into_file(outfile, "auto-id", 0, 0 );
  if (args_info->id_prefix_given)
    write_into_file(outfile, "id-prefix", args_info->id_prefix_orig, 0);
  if (args_info->id_delim_given)
    write_into_file(outfile, "id-delim", args_info->id_delim_orig, 0);
  if (args_info->id_digits_given)
    write_into_file(outfile, "id-digits", args_info->id_digits_orig, 0);
  if (args_info->id_start_given)
    write_into_file(outfile, "id-start", args_info->id_start_orig, 0);
  if (args_info->filename_delim_given)
    write_into_file(outfile, "filename-delim", args_info->filename_delim_orig, 0);
  if (args_info->filename_full_given)
    write_into_file(outfile, "filename-full", 0, 0 );
  if (args_info->log_level_given)
    write_into_file(outfile, "log-level", args_info->log_level_orig, 0);
  if (args_info->log_file_given)
    write_into_file(outfile, "log-file", args_info->log_file_orig, 0);
  if (args_info->log_time_given)
    write_into_file(outfile, "log-time", 0, 0 );
  if (args_info->log_call_given)
    write_into_file(outfile, "log-call", 0, 0 );
  if (args_info->covar_given)
    write_into_file(outfile, "covar", 0, 0 );
  if (args_info->covar_threshold_given)
    write_into_file(outfile, "covar-threshold", args_info->covar_threshold_orig, 0);
  if (args_info->covar_min_sat_given)
    write_into_file(outfile, "covar-min-sat", args_info->covar_min_sat_orig, 0);
  if (args_info->aln_given)
    write_into_file(outfile, "aln", 0, 0 );
  if (args_info->aln_EPS_cols_given)
    write_into_file(outfile, "aln-EPS-cols", args_info->aln_EPS_cols_orig, 0);
  if (args_info->layout_type_given)
    write_into_file(outfile, "layout-type", args_info->layout_type_orig, RNAplot_cmdline_parser_layout_type_values);
  if (args_info->noOptimization_given)
    write_into_file(outfile, "noOptimization", 0, 0 );
  if (args_info->ignoreExteriorIntersections_given)
    write_into_file(outfile, "ignoreExteriorIntersections", 0, 0 );
  if (args_info->ignoreAncestorIntersections_given)
    write_into_file(outfile, "ignoreAncestorIntersections", 0, 0 );
  if (args_info->ignoreSiblingIntersections_given)
    write_into_file(outfile, "ignoreSiblingIntersections", 0, 0 );
  if (args_info->allowFlipping_given)
    write_into_file(outfile, "allowFlipping", 0, 0 );
  

  i = EXIT_SUCCESS;
  return i;
}

int
RNAplot_cmdline_parser_file_save(const char *filename, struct RNAplot_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", RNAPLOT_CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = RNAplot_cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
RNAplot_cmdline_parser_free (struct RNAplot_args_info *args_info)
{
  RNAplot_cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

static char *
get_multiple_arg_token(const char *arg)
{
  const char *tok;
  char *ret;
  size_t len, num_of_escape, i, j;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');
  num_of_escape = 0;

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
          ++num_of_escape;
        }
      else
        break;
    }

  if (tok)
    len = (size_t)(tok - arg + 1);
  else
    len = strlen (arg) + 1;

  len -= num_of_escape;

  ret = (char *) malloc (len);

  i = 0;
  j = 0;
  while (arg[i] && (j < len-1))
    {
      if (arg[i] == '\\' && 
	  arg[ i + 1 ] && 
	  arg[ i + 1 ] == ',')
        ++i;

      ret[j++] = arg[i++];
    }

  ret[len-1] = '\0';

  return ret;
}

static const char *
get_multiple_arg_token_next(const char *arg)
{
  const char *tok;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
        }
      else
        break;
    }

  if (! tok || strlen(tok) == 1)
    return 0;

  return tok+1;
}

static int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc);

int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc)
{
  int error_occurred = 0;

  if (option_given && (min > 0 || max > 0))
    {
      if (min > 0 && max > 0)
        {
          if (min == max)
            {
              /* specific occurrences */
              if (option_given != (unsigned int) min)
                {
                  fprintf (stderr, "%s: %s option occurrences must be %d\n",
                    prog_name, option_desc, min);
                  error_occurred = 1;
                }
            }
          else if (option_given < (unsigned int) min
                || option_given > (unsigned int) max)
            {
              /* range occurrences */
              fprintf (stderr, "%s: %s option occurrences must be between %d and %d\n",
                prog_name, option_desc, min, max);
              error_occurred = 1;
            }
        }
      else if (min > 0)
        {
          /* at least check */
          if (option_given < min)
            {
              fprintf (stderr, "%s: %s option occurrences must be at least %d\n",
                prog_name, option_desc, min);
              error_occurred = 1;
            }
        }
      else if (max > 0)
        {
          /* at most check */
          if (option_given > max)
            {
              fprintf (stderr, "%s: %s option occurrences must be at most %d\n",
                prog_name, option_desc, max);
              error_occurred = 1;
            }
        }
    }
    
  return error_occurred;
}
int
RNAplot_cmdline_parser (int argc, char **argv, struct RNAplot_args_info *args_info)
{
  return RNAplot_cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
RNAplot_cmdline_parser_ext (int argc, char **argv, struct RNAplot_args_info *args_info,
                   struct RNAplot_cmdline_parser_params *params)
{
  int result;
  result = RNAplot_cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      RNAplot_cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
RNAplot_cmdline_parser2 (int argc, char **argv, struct RNAplot_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct RNAplot_cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = RNAplot_cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      RNAplot_cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
RNAplot_cmdline_parser_required (struct RNAplot_args_info *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (RNAplot_cmdline_parser_required2(args_info, prog_name, 0) > 0)
    result = EXIT_FAILURE;

  if (result == EXIT_FAILURE)
    {
      RNAplot_cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
RNAplot_cmdline_parser_required2 (struct RNAplot_args_info *args_info, const char *prog_name, const char *additional_error)
{
  int error_occurred = 0;
  FIX_UNUSED (additional_error);

  /* checks for required options */
  if (check_multiple_option_occurrences(prog_name, args_info->infile_given, args_info->infile_min, args_info->infile_max, "'--infile' ('-i')"))
     error_occurred = 1;
  
  
  /* checks for dependences among options */
  if (args_info->mis_given && ! args_info->msa_given)
    {
      fprintf (stderr, "%s: '--mis' option depends on option 'msa'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->covar_given && ! args_info->msa_given)
    {
      fprintf (stderr, "%s: '--covar' option depends on option 'msa'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->aln_given && ! args_info->msa_given)
    {
      fprintf (stderr, "%s: '--aln' option depends on option 'msa'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->aln_EPS_cols_given && ! args_info->msa_given)
    {
      fprintf (stderr, "%s: '--aln-EPS-cols' option depends on option 'msa'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }

  return error_occurred;
}

/*
 * Extracted from the glibc source tree, version 2.3.6
 *
 * Licensed under the GPL as per the whole glibc source tree.
 *
 * This file was modified so that getopt_long can be called
 * many times without risking previous memory to be spoiled.
 *
 * Modified by Andre Noll and Lorenzo Bettini for use in
 * GNU gengetopt generated files.
 *
 */

/* 
 * we must include anything we need since this file is not thought to be
 * inserted in a file already using getopt.h
 *
 * Lorenzo
 */

struct option
{
  const char *name;
  /* has_arg can't be an enum because some compilers complain about
     type mismatches in all the code that assumes it is an int.  */
  int has_arg;
  int *flag;
  int val;
};

/* This version of `getopt' appears to the caller like standard Unix `getopt'
   but it behaves differently for the user, since it allows the user
   to intersperse the options with the other arguments.

   As `getopt' works, it permutes the elements of ARGV so that,
   when it is done, all the options precede everything else.  Thus
   all application programs are extended to handle flexible argument order.
*/
/*
   If the field `flag' is not NULL, it points to a variable that is set
   to the value given in the field `val' when the option is found, but
   left unchanged if the option is not found.

   To have a long-named option do something other than set an `int' to
   a compiled-in constant, such as set a value from `custom_optarg', set the
   option's `flag' field to zero and its `val' field to a nonzero
   value (the equivalent single-letter option character, if there is
   one).  For long options that have a zero `flag' field, `getopt'
   returns the contents of the `val' field.  */

/* Names for the values of the `has_arg' field of `struct option'.  */
#ifndef no_argument
#define no_argument		0
#endif

#ifndef required_argument
#define required_argument	1
#endif

#ifndef optional_argument
#define optional_argument	2
#endif

struct custom_getopt_data {
	/*
	 * These have exactly the same meaning as the corresponding global variables,
	 * except that they are used for the reentrant versions of getopt.
	 */
	int custom_optind;
	int custom_opterr;
	int custom_optopt;
	char *custom_optarg;

	/* True if the internal members have been initialized.  */
	int initialized;

	/*
	 * The next char to be scanned in the option-element in which the last option
	 * character we returned was found.  This allows us to pick up the scan where
	 * we left off.  If this is zero, or a null string, it means resume the scan by
	 * advancing to the next ARGV-element.
	 */
	char *nextchar;

	/*
	 * Describe the part of ARGV that contains non-options that have been skipped.
	 * `first_nonopt' is the index in ARGV of the first of them; `last_nonopt' is
	 * the index after the last of them.
	 */
	int first_nonopt;
	int last_nonopt;
};

/*
 * the variables optarg, optind, opterr and optopt are renamed with
 * the custom_ prefix so that they don't interfere with getopt ones.
 *
 * Moreover they're static so they are visible only from within the
 * file where this very file will be included.
 */

/*
 * For communication from `custom_getopt' to the caller.  When `custom_getopt' finds an
 * option that takes an argument, the argument value is returned here.
 */
static char *custom_optarg;

/*
 * Index in ARGV of the next element to be scanned.  This is used for
 * communication to and from the caller and for communication between
 * successive calls to `custom_getopt'.
 *
 * On entry to `custom_getopt', 1 means this is the first call; initialize.
 *
 * When `custom_getopt' returns -1, this is the index of the first of the non-option
 * elements that the caller should itself scan.
 *
 * Otherwise, `custom_optind' communicates from one call to the next how much of ARGV
 * has been scanned so far.
 *
 * 1003.2 says this must be 1 before any call.
 */
static int custom_optind = 1;

/*
 * Callers store zero here to inhibit the error message for unrecognized
 * options.
 */
static int custom_opterr = 1;

/*
 * Set to an option character which was unrecognized.  This must be initialized
 * on some systems to avoid linking in the system's own getopt implementation.
 */
static int custom_optopt = '?';

/*
 * Exchange two adjacent subsequences of ARGV.  One subsequence is elements
 * [first_nonopt,last_nonopt) which contains all the non-options that have been
 * skipped so far.  The other is elements [last_nonopt,custom_optind), which contains
 * all the options processed since those non-options were skipped.
 * `first_nonopt' and `last_nonopt' are relocated so that they describe the new
 * indices of the non-options in ARGV after they are moved.
 */
static void exchange(char **argv, struct custom_getopt_data *d)
{
	int bottom = d->first_nonopt;
	int middle = d->last_nonopt;
	int top = d->custom_optind;
	char *tem;

	/*
	 * Exchange the shorter segment with the far end of the longer segment.
	 * That puts the shorter segment into the right place.  It leaves the
	 * longer segment in the right place overall, but it consists of two
	 * parts that need to be swapped next.
	 */
	while (top > middle && middle > bottom) {
		if (top - middle > middle - bottom) {
			/* Bottom segment is the short one.  */
			int len = middle - bottom;
			int i;

			/* Swap it with the top part of the top segment.  */
			for (i = 0; i < len; i++) {
				tem = argv[bottom + i];
				argv[bottom + i] =
					argv[top - (middle - bottom) + i];
				argv[top - (middle - bottom) + i] = tem;
			}
			/* Exclude the moved bottom segment from further swapping.  */
			top -= len;
		} else {
			/* Top segment is the short one.  */
			int len = top - middle;
			int i;

			/* Swap it with the bottom part of the bottom segment.  */
			for (i = 0; i < len; i++) {
				tem = argv[bottom + i];
				argv[bottom + i] = argv[middle + i];
				argv[middle + i] = tem;
			}
			/* Exclude the moved top segment from further swapping.  */
			bottom += len;
		}
	}
	/* Update records for the slots the non-options now occupy.  */
	d->first_nonopt += (d->custom_optind - d->last_nonopt);
	d->last_nonopt = d->custom_optind;
}

/* Initialize the internal data when the first call is made.  */
static void custom_getopt_initialize(struct custom_getopt_data *d)
{
	/*
	 * Start processing options with ARGV-element 1 (since ARGV-element 0
	 * is the program name); the sequence of previously skipped non-option
	 * ARGV-elements is empty.
	 */
	d->first_nonopt = d->last_nonopt = d->custom_optind;
	d->nextchar = NULL;
	d->initialized = 1;
}

#define NONOPTION_P (argv[d->custom_optind][0] != '-' || argv[d->custom_optind][1] == '\0')

/* return: zero: continue, nonzero: return given value to user */
static int shuffle_argv(int argc, char *const *argv,const struct option *longopts,
	struct custom_getopt_data *d)
{
	/*
	 * Give FIRST_NONOPT & LAST_NONOPT rational values if CUSTOM_OPTIND has been
	 * moved back by the user (who may also have changed the arguments).
	 */
	if (d->last_nonopt > d->custom_optind)
		d->last_nonopt = d->custom_optind;
	if (d->first_nonopt > d->custom_optind)
		d->first_nonopt = d->custom_optind;
	/*
	 * If we have just processed some options following some
	 * non-options, exchange them so that the options come first.
	 */
	if (d->first_nonopt != d->last_nonopt &&
			d->last_nonopt != d->custom_optind)
		exchange((char **) argv, d);
	else if (d->last_nonopt != d->custom_optind)
		d->first_nonopt = d->custom_optind;
	/*
	 * Skip any additional non-options and extend the range of
	 * non-options previously skipped.
	 */
	while (d->custom_optind < argc && NONOPTION_P)
		d->custom_optind++;
	d->last_nonopt = d->custom_optind;
	/*
	 * The special ARGV-element `--' means premature end of options.  Skip
	 * it like a null option, then exchange with previous non-options as if
	 * it were an option, then skip everything else like a non-option.
	 */
	if (d->custom_optind != argc && !strcmp(argv[d->custom_optind], "--")) {
		d->custom_optind++;
		if (d->first_nonopt != d->last_nonopt
				&& d->last_nonopt != d->custom_optind)
			exchange((char **) argv, d);
		else if (d->first_nonopt == d->last_nonopt)
			d->first_nonopt = d->custom_optind;
		d->last_nonopt = argc;
		d->custom_optind = argc;
	}
	/*
	 * If we have done all the ARGV-elements, stop the scan and back over
	 * any non-options that we skipped and permuted.
	 */
	if (d->custom_optind == argc) {
		/*
		 * Set the next-arg-index to point at the non-options that we
		 * previously skipped, so the caller will digest them.
		 */
		if (d->first_nonopt != d->last_nonopt)
			d->custom_optind = d->first_nonopt;
		return -1;
	}
	/*
	 * If we have come to a non-option and did not permute it, either stop
	 * the scan or describe it to the caller and pass it by.
	 */
	if (NONOPTION_P) {
		d->custom_optarg = argv[d->custom_optind++];
		return 1;
	}
	/*
	 * We have found another option-ARGV-element. Skip the initial
	 * punctuation.
	 */
	d->nextchar = (argv[d->custom_optind] + 1 + (longopts != NULL && argv[d->custom_optind][1] == '-'));
	return 0;
}

/*
 * Check whether the ARGV-element is a long option.
 *
 * If there's a long option "fubar" and the ARGV-element is "-fu", consider
 * that an abbreviation of the long option, just like "--fu", and not "-f" with
 * arg "u".
 *
 * This distinction seems to be the most useful approach.
 *
 */
static int check_long_opt(int argc, char *const *argv, const char *optstring,
		const struct option *longopts, int *longind,
		int print_errors, struct custom_getopt_data *d)
{
	char *nameend;
	const struct option *p;
	const struct option *pfound = NULL;
	int exact = 0;
	int ambig = 0;
	int indfound = -1;
	int option_index;

	for (nameend = d->nextchar; *nameend && *nameend != '='; nameend++)
		/* Do nothing.  */ ;

	/* Test all long options for either exact match or abbreviated matches */
	for (p = longopts, option_index = 0; p->name; p++, option_index++)
		if (!strncmp(p->name, d->nextchar, nameend - d->nextchar)) {
			if ((unsigned int) (nameend - d->nextchar)
					== (unsigned int) strlen(p->name)) {
				/* Exact match found.  */
				pfound = p;
				indfound = option_index;
				exact = 1;
				break;
			} else if (pfound == NULL) {
				/* First nonexact match found.  */
				pfound = p;
				indfound = option_index;
			} else if (pfound->has_arg != p->has_arg
					|| pfound->flag != p->flag
					|| pfound->val != p->val)
				/* Second or later nonexact match found.  */
				ambig = 1;
		}
	if (ambig && !exact) {
		if (print_errors) {
			fprintf(stderr,
				"%s: option `%s' is ambiguous\n",
				argv[0], argv[d->custom_optind]);
		}
		d->nextchar += strlen(d->nextchar);
		d->custom_optind++;
		d->custom_optopt = 0;
		return '?';
	}
	if (pfound) {
		option_index = indfound;
		d->custom_optind++;
		if (*nameend) {
			if (pfound->has_arg != no_argument)
				d->custom_optarg = nameend + 1;
			else {
				if (print_errors) {
					if (argv[d->custom_optind - 1][1] == '-') {
						/* --option */
						fprintf(stderr, "%s: option `--%s' doesn't allow an argument\n",
							argv[0], pfound->name);
					} else {
						/* +option or -option */
						fprintf(stderr, "%s: option `%c%s' doesn't allow an argument\n",
							argv[0], argv[d->custom_optind - 1][0], pfound->name);
					}

				}
				d->nextchar += strlen(d->nextchar);
				d->custom_optopt = pfound->val;
				return '?';
			}
		} else if (pfound->has_arg == required_argument) {
			if (d->custom_optind < argc)
				d->custom_optarg = argv[d->custom_optind++];
			else {
				if (print_errors) {
					fprintf(stderr,
						"%s: option `%s' requires an argument\n",
						argv[0],
						argv[d->custom_optind - 1]);
				}
				d->nextchar += strlen(d->nextchar);
				d->custom_optopt = pfound->val;
				return optstring[0] == ':' ? ':' : '?';
			}
		}
		d->nextchar += strlen(d->nextchar);
		if (longind != NULL)
			*longind = option_index;
		if (pfound->flag) {
			*(pfound->flag) = pfound->val;
			return 0;
		}
		return pfound->val;
	}
	/*
	 * Can't find it as a long option.  If this is not getopt_long_only, or
	 * the option starts with '--' or is not a valid short option, then
	 * it's an error.  Otherwise interpret it as a short option.
	 */
	if (print_errors) {
		if (argv[d->custom_optind][1] == '-') {
			/* --option */
			fprintf(stderr,
				"%s: unrecognized option `--%s'\n",
				argv[0], d->nextchar);
		} else {
			/* +option or -option */
			fprintf(stderr,
				"%s: unrecognized option `%c%s'\n",
				argv[0], argv[d->custom_optind][0],
				d->nextchar);
		}
	}
	d->nextchar = (char *) "";
	d->custom_optind++;
	d->custom_optopt = 0;
	return '?';
}

static int check_short_opt(int argc, char *const *argv, const char *optstring,
		int print_errors, struct custom_getopt_data *d)
{
	char c = *d->nextchar++;
	const char *temp = strchr(optstring, c);

	/* Increment `custom_optind' when we start to process its last character.  */
	if (*d->nextchar == '\0')
		++d->custom_optind;
	if (!temp || c == ':') {
		if (print_errors)
			fprintf(stderr, "%s: invalid option -- %c\n", argv[0], c);

		d->custom_optopt = c;
		return '?';
	}
	if (temp[1] == ':') {
		if (temp[2] == ':') {
			/* This is an option that accepts an argument optionally.  */
			if (*d->nextchar != '\0') {
				d->custom_optarg = d->nextchar;
				d->custom_optind++;
			} else
				d->custom_optarg = NULL;
			d->nextchar = NULL;
		} else {
			/* This is an option that requires an argument.  */
			if (*d->nextchar != '\0') {
				d->custom_optarg = d->nextchar;
				/*
				 * If we end this ARGV-element by taking the
				 * rest as an arg, we must advance to the next
				 * element now.
				 */
				d->custom_optind++;
			} else if (d->custom_optind == argc) {
				if (print_errors) {
					fprintf(stderr,
						"%s: option requires an argument -- %c\n",
						argv[0], c);
				}
				d->custom_optopt = c;
				if (optstring[0] == ':')
					c = ':';
				else
					c = '?';
			} else
				/*
				 * We already incremented `custom_optind' once;
				 * increment it again when taking next ARGV-elt
				 * as argument.
				 */
				d->custom_optarg = argv[d->custom_optind++];
			d->nextchar = NULL;
		}
	}
	return c;
}

/*
 * Scan elements of ARGV for option characters given in OPTSTRING.
 *
 * If an element of ARGV starts with '-', and is not exactly "-" or "--",
 * then it is an option element.  The characters of this element
 * (aside from the initial '-') are option characters.  If `getopt'
 * is called repeatedly, it returns successively each of the option characters
 * from each of the option elements.
 *
 * If `getopt' finds another option character, it returns that character,
 * updating `custom_optind' and `nextchar' so that the next call to `getopt' can
 * resume the scan with the following option character or ARGV-element.
 *
 * If there are no more option characters, `getopt' returns -1.
 * Then `custom_optind' is the index in ARGV of the first ARGV-element
 * that is not an option.  (The ARGV-elements have been permuted
 * so that those that are not options now come last.)
 *
 * OPTSTRING is a string containing the legitimate option characters.
 * If an option character is seen that is not listed in OPTSTRING,
 * return '?' after printing an error message.  If you set `custom_opterr' to
 * zero, the error message is suppressed but we still return '?'.
 *
 * If a char in OPTSTRING is followed by a colon, that means it wants an arg,
 * so the following text in the same ARGV-element, or the text of the following
 * ARGV-element, is returned in `custom_optarg'.  Two colons mean an option that
 * wants an optional arg; if there is text in the current ARGV-element,
 * it is returned in `custom_optarg', otherwise `custom_optarg' is set to zero.
 *
 * If OPTSTRING starts with `-' or `+', it requests different methods of
 * handling the non-option ARGV-elements.
 * See the comments about RETURN_IN_ORDER and REQUIRE_ORDER, above.
 *
 * Long-named options begin with `--' instead of `-'.
 * Their names may be abbreviated as long as the abbreviation is unique
 * or is an exact match for some defined option.  If they have an
 * argument, it follows the option name in the same ARGV-element, separated
 * from the option name by a `=', or else the in next ARGV-element.
 * When `getopt' finds a long-named option, it returns 0 if that option's
 * `flag' field is nonzero, the value of the option's `val' field
 * if the `flag' field is zero.
 *
 * The elements of ARGV aren't really const, because we permute them.
 * But we pretend they're const in the prototype to be compatible
 * with other systems.
 *
 * LONGOPTS is a vector of `struct option' terminated by an
 * element containing a name which is zero.
 *
 * LONGIND returns the index in LONGOPT of the long-named option found.
 * It is only valid when a long-named option has been found by the most
 * recent call.
 *
 * Return the option character from OPTS just read.  Return -1 when there are
 * no more options.  For unrecognized options, or options missing arguments,
 * `custom_optopt' is set to the option letter, and '?' is returned.
 *
 * The OPTS string is a list of characters which are recognized option letters,
 * optionally followed by colons, specifying that that letter takes an
 * argument, to be placed in `custom_optarg'.
 *
 * If a letter in OPTS is followed by two colons, its argument is optional.
 * This behavior is specific to the GNU `getopt'.
 *
 * The argument `--' causes premature termination of argument scanning,
 * explicitly telling `getopt' that there are no more options.  If OPTS begins
 * with `--', then non-option arguments are treated as arguments to the option
 * '\0'.  This behavior is specific to the GNU `getopt'.
 */

static int getopt_internal_r(int argc, char *const *argv, const char *optstring,
		const struct option *longopts, int *longind,
		struct custom_getopt_data *d)
{
	int ret, print_errors = d->custom_opterr;

	if (optstring[0] == ':')
		print_errors = 0;
	if (argc < 1)
		return -1;
	d->custom_optarg = NULL;

	/* 
	 * This is a big difference with GNU getopt, since optind == 0
	 * means initialization while here 1 means first call.
	 */
	if (d->custom_optind == 0 || !d->initialized) {
		if (d->custom_optind == 0)
			d->custom_optind = 1;	/* Don't scan ARGV[0], the program name.  */
		custom_getopt_initialize(d);
	}
	if (d->nextchar == NULL || *d->nextchar == '\0') {
		ret = shuffle_argv(argc, argv, longopts, d);
		if (ret)
			return ret;
	}
	if (longopts && (argv[d->custom_optind][1] == '-' ))
		return check_long_opt(argc, argv, optstring, longopts,
			longind, print_errors, d);
	return check_short_opt(argc, argv, optstring, print_errors, d);
}

static int custom_getopt_internal(int argc, char *const *argv, const char *optstring,
	const struct option *longopts, int *longind)
{
	int result;
	/* Keep a global copy of all internal members of d */
	static struct custom_getopt_data d;

	d.custom_optind = custom_optind;
	d.custom_opterr = custom_opterr;
	result = getopt_internal_r(argc, argv, optstring, longopts,
		longind, &d);
	custom_optind = d.custom_optind;
	custom_optarg = d.custom_optarg;
	custom_optopt = d.custom_optopt;
	return result;
}

static int custom_getopt_long (int argc, char *const *argv, const char *options,
	const struct option *long_options, int *opt_index)
{
	return custom_getopt_internal(argc, argv, options, long_options,
		opt_index);
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see RNAplot_cmdline_parser_params.check_ambiguity
 * @param override @see RNAplot_cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               RNAplot_cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  if (possible_values && (found = check_possible_values((value ? value : default_value), possible_values)) < 0)
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s' (`-%c')%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt, short_opt,
          (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s'%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt,
          (additional_error ? additional_error : ""));
      return 1; /* failure */
    }
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_LONG:
    if (val) *((long *)field) = (long)strtol (val, &stop_char, 0);
    break;
  case ARG_FLOAT:
    if (val) *((float *)field) = (float)strtod (val, &stop_char);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
  case ARG_LONG:
  case ARG_FLOAT:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}

/**
 * @brief store information about a multiple option in a temporary list
 * @param list where to (temporarily) store multiple options
 */
static
int update_multiple_arg_temp(struct generic_list **list,
               unsigned int *prev_given, const char *val,
               const char *possible_values[], const char *default_value,
               RNAplot_cmdline_parser_arg_type arg_type,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  /* store single arguments */
  char *multi_token;
  const char *multi_next;

  if (arg_type == ARG_NO) {
    (*prev_given)++;
    return 0; /* OK */
  }

  multi_token = get_multiple_arg_token(val);
  multi_next = get_multiple_arg_token_next (val);

  while (1)
    {
      add_node (list);
      if (update_arg((void *)&((*list)->arg), &((*list)->orig), 0,
          prev_given, multi_token, possible_values, default_value, 
          arg_type, 0, 1, 1, 1, long_opt, short_opt, additional_error)) {
        if (multi_token) free(multi_token);
        return 1; /* failure */
      }

      if (multi_next)
        {
          multi_token = get_multiple_arg_token(multi_next);
          multi_next = get_multiple_arg_token_next (multi_next);
        }
      else
        break;
    }

  return 0; /* OK */
}

/**
 * @brief free the passed list (including possible string argument)
 */
static
void free_list(struct generic_list *list, short string_arg)
{
  if (list) {
    struct generic_list *tmp;
    while (list)
      {
        tmp = list;
        if (string_arg && list->arg.string_arg)
          free (list->arg.string_arg);
        if (list->orig)
          free (list->orig);
        list = list->next;
        free (tmp);
      }
  }
}

/**
 * @brief updates a multiple option starting from the passed list
 */
static
void update_multiple_arg(void *field, char ***orig_field,
               unsigned int field_given, unsigned int prev_given, union generic_value *default_value,
               RNAplot_cmdline_parser_arg_type arg_type,
               struct generic_list *list)
{
  int i;
  struct generic_list *tmp;

  if (prev_given && list) {
    *orig_field = (char **) realloc (*orig_field, (field_given + prev_given) * sizeof (char *));

    switch(arg_type) {
    case ARG_INT:
      *((int **)field) = (int *)realloc (*((int **)field), (field_given + prev_given) * sizeof (int)); break;
    case ARG_LONG:
      *((long **)field) = (long *)realloc (*((long **)field), (field_given + prev_given) * sizeof (long)); break;
    case ARG_FLOAT:
      *((float **)field) = (float *)realloc (*((float **)field), (field_given + prev_given) * sizeof (float)); break;
    case ARG_STRING:
      *((char ***)field) = (char **)realloc (*((char ***)field), (field_given + prev_given) * sizeof (char *)); break;
    default:
      break;
    };
    
    for (i = (prev_given - 1); i >= 0; --i)
      {
        tmp = list;
        
        switch(arg_type) {
        case ARG_INT:
          (*((int **)field))[i + field_given] = tmp->arg.int_arg; break;
        case ARG_LONG:
          (*((long **)field))[i + field_given] = tmp->arg.long_arg; break;
        case ARG_FLOAT:
          (*((float **)field))[i + field_given] = tmp->arg.float_arg; break;
        case ARG_STRING:
          (*((char ***)field))[i + field_given] = tmp->arg.string_arg; break;
        default:
          break;
        }        
        (*orig_field) [i + field_given] = list->orig;
        list = list->next;
        free (tmp);
      }
  } else { /* set the default value */
    if (default_value && ! field_given) {
      switch(arg_type) {
      case ARG_INT:
        if (! *((int **)field)) {
          *((int **)field) = (int *)malloc (sizeof (int));
          (*((int **)field))[0] = default_value->int_arg; 
        }
        break;
      case ARG_LONG:
        if (! *((long **)field)) {
          *((long **)field) = (long *)malloc (sizeof (long));
          (*((long **)field))[0] = default_value->long_arg;
        }
        break;
      case ARG_FLOAT:
        if (! *((float **)field)) {
          *((float **)field) = (float *)malloc (sizeof (float));
          (*((float **)field))[0] = default_value->float_arg;
        }
        break;
      case ARG_STRING:
        if (! *((char ***)field)) {
          *((char ***)field) = (char **)malloc (sizeof (char *));
          (*((char ***)field))[0] = gengetopt_strdup(default_value->string_arg);
        }
        break;
      default: break;
      }
      if (!(*orig_field)) {
        *orig_field = (char **) malloc (sizeof (char *));
        (*orig_field)[0] = 0;
      }
    }
  }
}

int
RNAplot_cmdline_parser_internal (
  int argc, char **argv, struct RNAplot_args_info *args_info,
                        struct RNAplot_cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  struct generic_list * infile_list = NULL;
  int error_occurred = 0;
  struct RNAplot_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;

  char *optarg;
  int optind;
  int opterr;
  int optopt;
  
  package_name = argv[0];
  
  /* TODO: Why is this here? It is not used anywhere. */
  override = params->override;
  FIX_UNUSED(override);

  initialize = params->initialize;
  check_required = params->check_required;

  /* TODO: Why is this here? It is not used anywhere. */
  check_ambiguity = params->check_ambiguity;
  FIX_UNUSED(check_ambiguity);

  if (initialize)
    RNAplot_cmdline_parser_init (args_info);

  RNAplot_cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "detailed-help",	0, NULL, 0 },
        { "full-help",	0, NULL, 0 },
        { "version",	0, NULL, 'V' },
        { "verbose",	0, NULL, 'v' },
        { "infile",	1, NULL, 'i' },
        { "msa",	0, NULL, 'a' },
        { "mis",	0, NULL, 0 },
        { "jobs",	2, NULL, 'j' },
        { "output-format",	1, NULL, 'f' },
        { "pre",	1, NULL, 0 },
        { "post",	1, NULL, 0 },
        { "auto-id",	0, NULL, 0 },
        { "id-prefix",	1, NULL, 0 },
        { "id-delim",	1, NULL, 0 },
        { "id-digits",	1, NULL, 0 },
        { "id-start",	1, NULL, 0 },
        { "filename-delim",	1, NULL, 0 },
        { "filename-full",	0, NULL, 0 },
        { "log-level",	1, NULL, 0 },
        { "log-file",	2, NULL, 0 },
        { "log-time",	0, NULL, 0 },
        { "log-call",	0, NULL, 0 },
        { "covar",	0, NULL, 0 },
        { "covar-threshold",	1, NULL, 0 },
        { "covar-min-sat",	1, NULL, 0 },
        { "aln",	0, NULL, 0 },
        { "aln-EPS-cols",	1, NULL, 0 },
        { "layout-type",	1, NULL, 't' },
        { "noOptimization",	0, NULL, 0 },
        { "ignoreExteriorIntersections",	0, NULL, 0 },
        { "ignoreAncestorIntersections",	0, NULL, 0 },
        { "ignoreSiblingIntersections",	0, NULL, 0 },
        { "allowFlipping",	0, NULL, 0 },
        { 0,  0, 0, 0 }
      };

      custom_optarg = optarg;
      custom_optind = optind;
      custom_opterr = opterr;
      custom_optopt = optopt;

      c = custom_getopt_long (argc, argv, "hVvi:aj::f:t:", long_options, &option_index);

      optarg = custom_optarg;
      optind = custom_optind;
      opterr = custom_opterr;
      optopt = custom_optopt;

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          RNAplot_cmdline_parser_print_help ();
          RNAplot_cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          RNAplot_cmdline_parser_print_version ();
          RNAplot_cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'v':	/* Be verbose.
.  */
        
        
          if (update_arg((void *)&(args_info->verbose_flag), 0, &(args_info->verbose_given),
              &(local_args_info.verbose_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "verbose", 'v',
              additional_error))
            goto failure;
        
          break;
        case 'i':	/* Read a file instead of reading from stdin..  */
        
          if (update_multiple_arg_temp(&infile_list, 
              &(local_args_info.infile_given), optarg, 0, 0, ARG_STRING,
              "infile", 'i',
              additional_error))
            goto failure;
        
          break;
        case 'a':	/* Input is multiple sequence alignment in Stockholm 1.0 format..  */
        
        
          if (update_arg((void *)&(args_info->msa_flag), 0, &(args_info->msa_given),
              &(local_args_info.msa_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "msa", 'a',
              additional_error))
            goto failure;
        
          break;
        case 'j':	/* Split batch input into jobs and start processing in parallel using multiple threads..  */
        
        
          if (update_arg( (void *)&(args_info->jobs_arg), 
               &(args_info->jobs_orig), &(args_info->jobs_given),
              &(local_args_info.jobs_given), optarg, 0, "0", ARG_INT,
              check_ambiguity, override, 0, 0,
              "jobs", 'j',
              additional_error))
            goto failure;
        
          break;
        case 'f':	/* Specify output file format..  */
        
        
          if (update_arg( (void *)&(args_info->output_format_arg), 
               &(args_info->output_format_orig), &(args_info->output_format_given),
              &(local_args_info.output_format_given), optarg, RNAplot_cmdline_parser_output_format_values, "eps", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "output-format", 'f',
              additional_error))
            goto failure;
        
          break;
        case 't':	/* Choose the plotting layout algorithm..  */
        
        
          if (update_arg( (void *)&(args_info->layout_type_arg), 
               &(args_info->layout_type_orig), &(args_info->layout_type_given),
              &(local_args_info.layout_type_given), optarg, RNAplot_cmdline_parser_layout_type_values, "1", ARG_INT,
              check_ambiguity, override, 0, 0,
              "layout-type", 't',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          if (strcmp (long_options[option_index].name, "detailed-help") == 0) {
            RNAplot_cmdline_parser_print_detailed_help ();
            RNAplot_cmdline_parser_free (&local_args_info);
            exit (EXIT_SUCCESS);
          }

          if (strcmp (long_options[option_index].name, "full-help") == 0) {
            RNAplot_cmdline_parser_print_full_help ();
            RNAplot_cmdline_parser_free (&local_args_info);
            exit (EXIT_SUCCESS);
          }

          /* Output \"most informative sequence\" instead of simple consensus.  */
          if (strcmp (long_options[option_index].name, "mis") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->mis_flag), 0, &(args_info->mis_given),
                &(local_args_info.mis_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "mis", '-',
                additional_error))
              goto failure;
          
          }
          /* Add annotation macros to postscript file, and add the postscript code in \"string\" just before the code to draw the structure. This is an easy way to add annotation..  */
          else if (strcmp (long_options[option_index].name, "pre") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->pre_arg), 
                 &(args_info->pre_orig), &(args_info->pre_given),
                &(local_args_info.pre_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "pre", '-',
                additional_error))
              goto failure;
          
          }
          /* Same as --pre but in contrast to adding the annotation macros. E.g to mark position 15 with circle use --post=\"15 cmark\"..  */
          else if (strcmp (long_options[option_index].name, "post") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->post_arg), 
                 &(args_info->post_orig), &(args_info->post_given),
                &(local_args_info.post_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "post", '-',
                additional_error))
              goto failure;
          
          }
          /* Automatically generate an ID for each sequence.
.  */
          else if (strcmp (long_options[option_index].name, "auto-id") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->auto_id_flag), 0, &(args_info->auto_id_given),
                &(local_args_info.auto_id_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "auto-id", '-',
                additional_error))
              goto failure;
          
          }
          /* Prefix for automatically generated IDs (as used in output file names).
.  */
          else if (strcmp (long_options[option_index].name, "id-prefix") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->id_prefix_arg), 
                 &(args_info->id_prefix_orig), &(args_info->id_prefix_given),
                &(local_args_info.id_prefix_given), optarg, 0, "sequence", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "id-prefix", '-',
                additional_error))
              goto failure;
          
          }
          /* Change the delimiter between prefix and increasing number for automatically generated IDs (as used in output file names).
.  */
          else if (strcmp (long_options[option_index].name, "id-delim") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->id_delim_arg), 
                 &(args_info->id_delim_orig), &(args_info->id_delim_given),
                &(local_args_info.id_delim_given), optarg, 0, "_", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "id-delim", '-',
                additional_error))
              goto failure;
          
          }
          /* Specify the number of digits of the counter in automatically generated alignment IDs.
.  */
          else if (strcmp (long_options[option_index].name, "id-digits") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->id_digits_arg), 
                 &(args_info->id_digits_orig), &(args_info->id_digits_given),
                &(local_args_info.id_digits_given), optarg, 0, "4", ARG_INT,
                check_ambiguity, override, 0, 0,
                "id-digits", '-',
                additional_error))
              goto failure;
          
          }
          /* Specify the first number in automatically generated IDs.
.  */
          else if (strcmp (long_options[option_index].name, "id-start") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->id_start_arg), 
                 &(args_info->id_start_orig), &(args_info->id_start_given),
                &(local_args_info.id_start_given), optarg, 0, "1", ARG_LONG,
                check_ambiguity, override, 0, 0,
                "id-start", '-',
                additional_error))
              goto failure;
          
          }
          /* Change the delimiting character used in sanitized filenames.
.  */
          else if (strcmp (long_options[option_index].name, "filename-delim") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->filename_delim_arg), 
                 &(args_info->filename_delim_orig), &(args_info->filename_delim_given),
                &(local_args_info.filename_delim_given), optarg, 0, "ID-delimiter", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "filename-delim", '-',
                additional_error))
              goto failure;
          
          }
          /* Use full FASTA header to create filenames.
.  */
          else if (strcmp (long_options[option_index].name, "filename-full") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->filename_full_flag), 0, &(args_info->filename_full_given),
                &(local_args_info.filename_full_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "filename-full", '-',
                additional_error))
              goto failure;
          
          }
          /* Set log level threshold.
.  */
          else if (strcmp (long_options[option_index].name, "log-level") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->log_level_arg), 
                 &(args_info->log_level_orig), &(args_info->log_level_given),
                &(local_args_info.log_level_given), optarg, 0, "2", ARG_INT,
                check_ambiguity, override, 0, 0,
                "log-level", '-',
                additional_error))
              goto failure;
          
          }
          /* Print log messages to a file instead of stderr.
.  */
          else if (strcmp (long_options[option_index].name, "log-file") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->log_file_arg), 
                 &(args_info->log_file_orig), &(args_info->log_file_given),
                &(local_args_info.log_file_given), optarg, 0, "RNAplot.log", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "log-file", '-',
                additional_error))
              goto failure;
          
          }
          /* Include time stamp in log messages.
          
.  */
          else if (strcmp (long_options[option_index].name, "log-time") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->log_time_flag), 0, &(args_info->log_time_given),
                &(local_args_info.log_time_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "log-time", '-',
                additional_error))
              goto failure;
          
          }
          /* Include file and line of log calling function.
          
.  */
          else if (strcmp (long_options[option_index].name, "log-call") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->log_call_flag), 0, &(args_info->log_call_given),
                &(local_args_info.log_call_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "log-call", '-',
                additional_error))
              goto failure;
          
          }
          /* Annotate covariance of base pairs in consensus structure.
          
.  */
          else if (strcmp (long_options[option_index].name, "covar") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->covar_flag), 0, &(args_info->covar_given),
                &(local_args_info.covar_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "covar", '-',
                additional_error))
              goto failure;
          
          }
          /* Set the threshold of maximum counter examples for coloring consensus structure plot.
.  */
          else if (strcmp (long_options[option_index].name, "covar-threshold") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->covar_threshold_arg), 
                 &(args_info->covar_threshold_orig), &(args_info->covar_threshold_given),
                &(local_args_info.covar_threshold_given), optarg, 0, "2", ARG_FLOAT,
                check_ambiguity, override, 0, 0,
                "covar-threshold", '-',
                additional_error))
              goto failure;
          
          }
          /* Set the minimum saturation for coloring consensus structure plot.
.  */
          else if (strcmp (long_options[option_index].name, "covar-min-sat") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->covar_min_sat_arg), 
                 &(args_info->covar_min_sat_orig), &(args_info->covar_min_sat_given),
                &(local_args_info.covar_min_sat_given), optarg, 0, "0.2", ARG_FLOAT,
                check_ambiguity, override, 0, 0,
                "covar-min-sat", '-',
                additional_error))
              goto failure;
          
          }
          /* Produce a colored and structure annotated alignment in PostScript format in the file \"aln.ps\" in the current directory.
          
.  */
          else if (strcmp (long_options[option_index].name, "aln") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->aln_flag), 0, &(args_info->aln_given),
                &(local_args_info.aln_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "aln", '-',
                additional_error))
              goto failure;
          
          }
          /* Number of columns in colored EPS alignment output.
.  */
          else if (strcmp (long_options[option_index].name, "aln-EPS-cols") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->aln_EPS_cols_arg), 
                 &(args_info->aln_EPS_cols_orig), &(args_info->aln_EPS_cols_given),
                &(local_args_info.aln_EPS_cols_given), optarg, 0, "60", ARG_INT,
                check_ambiguity, override, 0, 0,
                "aln-EPS-cols", '-',
                additional_error))
              goto failure;
          
          }
          /* Disable the drawing space optimization of RNApuzzler.
          
.  */
          else if (strcmp (long_options[option_index].name, "noOptimization") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->noOptimization_flag), 0, &(args_info->noOptimization_given),
                &(local_args_info.noOptimization_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "noOptimization", '-',
                additional_error))
              goto failure;
          
          }
          /* Ignore intersections with the exterior loop within the RNA-tree.
          
.  */
          else if (strcmp (long_options[option_index].name, "ignoreExteriorIntersections") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->ignoreExteriorIntersections_flag), 0, &(args_info->ignoreExteriorIntersections_given),
                &(local_args_info.ignoreExteriorIntersections_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "ignoreExteriorIntersections", '-',
                additional_error))
              goto failure;
          
          }
          /* Ignore ancestor intersections within the RNA-tree.
          
.  */
          else if (strcmp (long_options[option_index].name, "ignoreAncestorIntersections") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->ignoreAncestorIntersections_flag), 0, &(args_info->ignoreAncestorIntersections_given),
                &(local_args_info.ignoreAncestorIntersections_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "ignoreAncestorIntersections", '-',
                additional_error))
              goto failure;
          
          }
          /* Ignore sibling intersections within the RNA-tree.
          
.  */
          else if (strcmp (long_options[option_index].name, "ignoreSiblingIntersections") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->ignoreSiblingIntersections_flag), 0, &(args_info->ignoreSiblingIntersections_given),
                &(local_args_info.ignoreSiblingIntersections_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "ignoreSiblingIntersections", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow flipping of exterior loop branches to resolve exterior branch intersections.
          
.  */
          else if (strcmp (long_options[option_index].name, "allowFlipping") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->allowFlipping_flag), 0, &(args_info->allowFlipping_given),
                &(local_args_info.allowFlipping_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "allowFlipping", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", RNAPLOT_CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */


  update_multiple_arg((void *)&(args_info->infile_arg),
    &(args_info->infile_orig), args_info->infile_given,
    local_args_info.infile_given, 0,
    ARG_STRING, infile_list);

  args_info->infile_given += local_args_info.infile_given;
  local_args_info.infile_given = 0;
  
  if (check_required)
    {
      error_occurred += RNAplot_cmdline_parser_required2 (args_info, argv[0], additional_error);
    }

  RNAplot_cmdline_parser_release (&local_args_info);

  if ( error_occurred )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;
      int found_prog_name = 0;
      /* whether program name, i.e., argv[0], is in the remaining args
         (this may happen with some implementations of getopt,
          but surely not with the one included by gengetopt) */


      args_info->inputs_num = argc - optind - found_prog_name;
      args_info->inputs =
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind++]) ;
    }

  return 0;

failure:
  free_list (infile_list, 1 );
  
  RNAplot_cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
/* vim: set ft=c noet ts=8 sts=8 sw=8 tw=80 nojs spell : */
