/** @file RNAsubopt_cmdl.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.23
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt */

#ifndef RNASUBOPT_CMDL_H
#define RNASUBOPT_CMDL_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef RNASUBOPT_CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define RNASUBOPT_CMDLINE_PARSER_PACKAGE "RNAsubopt"
#endif

#ifndef RNASUBOPT_CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define RNASUBOPT_CMDLINE_PARSER_PACKAGE_NAME "RNAsubopt"
#endif

#ifndef RNASUBOPT_CMDLINE_PARSER_VERSION
/** @brief the program version */
#define RNASUBOPT_CMDLINE_PARSER_VERSION VERSION
#endif

/** @brief Where the command line options are stored */
struct RNAsubopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *detailed_help_help; /**< @brief Print help, including all details and hidden options, and exit help description.  */
  const char *full_help_help; /**< @brief Print help, including hidden options, and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  int verbose_flag;	/**< @brief Be verbose.
 (default=off).  */
  const char *verbose_help; /**< @brief Be verbose.
 help description.  */
  char * infile_arg;	/**< @brief Read a file instead of reading from stdin.
.  */
  char * infile_orig;	/**< @brief Read a file instead of reading from stdin.
 original value given at command line.  */
  const char *infile_help; /**< @brief Read a file instead of reading from stdin.
 help description.  */
  char * outfile_arg;	/**< @brief Print output to file instead of stdout.
.  */
  char * outfile_orig;	/**< @brief Print output to file instead of stdout.
 original value given at command line.  */
  const char *outfile_help; /**< @brief Print output to file instead of stdout.
 help description.  */
  int noconv_flag;	/**< @brief Do not automatically substitute nucleotide \"T\" with \"U\".
  
 (default=off).  */
  const char *noconv_help; /**< @brief Do not automatically substitute nucleotide \"T\" with \"U\".
  
 help description.  */
  int auto_id_flag;	/**< @brief Automatically generate an ID for each sequence.
 (default=off).  */
  const char *auto_id_help; /**< @brief Automatically generate an ID for each sequence.
 help description.  */
  char * id_prefix_arg;	/**< @brief Prefix for automatically generated IDs (as used in output file names).
 (default='sequence').  */
  char * id_prefix_orig;	/**< @brief Prefix for automatically generated IDs (as used in output file names).
 original value given at command line.  */
  const char *id_prefix_help; /**< @brief Prefix for automatically generated IDs (as used in output file names).
 help description.  */
  char * id_delim_arg;	/**< @brief Change the delimiter between prefix and increasing number for automatically generated IDs (as used in output file names).
 (default='_').  */
  char * id_delim_orig;	/**< @brief Change the delimiter between prefix and increasing number for automatically generated IDs (as used in output file names).
 original value given at command line.  */
  const char *id_delim_help; /**< @brief Change the delimiter between prefix and increasing number for automatically generated IDs (as used in output file names).
 help description.  */
  int id_digits_arg;	/**< @brief Specify the number of digits of the counter in automatically generated alignment IDs.
 (default='4').  */
  char * id_digits_orig;	/**< @brief Specify the number of digits of the counter in automatically generated alignment IDs.
 original value given at command line.  */
  const char *id_digits_help; /**< @brief Specify the number of digits of the counter in automatically generated alignment IDs.
 help description.  */
  long id_start_arg;	/**< @brief Specify the first number in automatically generated IDs.
 (default='1').  */
  char * id_start_orig;	/**< @brief Specify the first number in automatically generated IDs.
 original value given at command line.  */
  const char *id_start_help; /**< @brief Specify the first number in automatically generated IDs.
 help description.  */
  char * filename_delim_arg;	/**< @brief Change the delimiting character used in sanitized filenames.
 (default='ID-delimiter').  */
  char * filename_delim_orig;	/**< @brief Change the delimiting character used in sanitized filenames.
 original value given at command line.  */
  const char *filename_delim_help; /**< @brief Change the delimiting character used in sanitized filenames.
 help description.  */
  int filename_full_flag;	/**< @brief Use full FASTA header to create filenames.
 (default=off).  */
  const char *filename_full_help; /**< @brief Use full FASTA header to create filenames.
 help description.  */
  int log_level_arg;	/**< @brief Set log level threshold.
 (default='2').  */
  char * log_level_orig;	/**< @brief Set log level threshold.
 original value given at command line.  */
  const char *log_level_help; /**< @brief Set log level threshold.
 help description.  */
  char * log_file_arg;	/**< @brief Print log messages to a file instead of stderr.
 (default='RNAsubopt.log').  */
  char * log_file_orig;	/**< @brief Print log messages to a file instead of stderr.
 original value given at command line.  */
  const char *log_file_help; /**< @brief Print log messages to a file instead of stderr.
 help description.  */
  int log_time_flag;	/**< @brief Include time stamp in log messages.
  
 (default=off).  */
  const char *log_time_help; /**< @brief Include time stamp in log messages.
  
 help description.  */
  int log_call_flag;	/**< @brief Include file and line of log calling function.
  
 (default=off).  */
  const char *log_call_help; /**< @brief Include file and line of log calling function.
  
 help description.  */
  float deltaEnergy_arg;	/**< @brief Compute suboptimal structures with energy in a certain range of the optimum (kcal/mol).
.  */
  char * deltaEnergy_orig;	/**< @brief Compute suboptimal structures with energy in a certain range of the optimum (kcal/mol).
 original value given at command line.  */
  const char *deltaEnergy_help; /**< @brief Compute suboptimal structures with energy in a certain range of the optimum (kcal/mol).
 help description.  */
  float deltaEnergyPost_arg;	/**< @brief Only print structures with energy within range of the mfe after post reevaluation of energies.
.  */
  char * deltaEnergyPost_orig;	/**< @brief Only print structures with energy within range of the mfe after post reevaluation of energies.
 original value given at command line.  */
  const char *deltaEnergyPost_help; /**< @brief Only print structures with energy within range of the mfe after post reevaluation of energies.
 help description.  */
  int sorted_flag;	/**< @brief Sort the suboptimal structures by energy and lexicographical order.
 (default=off).  */
  const char *sorted_help; /**< @brief Sort the suboptimal structures by energy and lexicographical order.
 help description.  */
  int en_only_flag;	/**< @brief Only sort structures by free energy.
 (default=off).  */
  const char *en_only_help; /**< @brief Only sort structures by free energy.
 help description.  */
  int stochBT_arg;	/**< @brief Randomly draw structures according to their probability in the Boltzmann ensemble.
.  */
  char * stochBT_orig;	/**< @brief Randomly draw structures according to their probability in the Boltzmann ensemble.
 original value given at command line.  */
  const char *stochBT_help; /**< @brief Randomly draw structures according to their probability in the Boltzmann ensemble.
 help description.  */
  int stochBT_en_arg;	/**< @brief Same as \"--stochBT\" but also print free energies and probabilities of the backtraced structures.
  
.  */
  char * stochBT_en_orig;	/**< @brief Same as \"--stochBT\" but also print free energies and probabilities of the backtraced structures.
  
 original value given at command line.  */
  const char *stochBT_en_help; /**< @brief Same as \"--stochBT\" but also print free energies and probabilities of the backtraced structures.
  
 help description.  */
  int random_seed_arg;	/**< @brief Set the seed for the random number generator
  
.  */
  char * random_seed_orig;	/**< @brief Set the seed for the random number generator
  
 original value given at command line.  */
  const char *random_seed_help; /**< @brief Set the seed for the random number generator
  
 help description.  */
  double betaScale_arg;	/**< @brief Set the scaling of the Boltzmann factors.
 (default='1.').  */
  char * betaScale_orig;	/**< @brief Set the scaling of the Boltzmann factors.
 original value given at command line.  */
  const char *betaScale_help; /**< @brief Set the scaling of the Boltzmann factors.
 help description.  */
  int nonRedundant_flag;	/**< @brief Enable non-redundant sampling strategy.
  
 (default=off).  */
  const char *nonRedundant_help; /**< @brief Enable non-redundant sampling strategy.
  
 help description.  */
  double pfScale_arg;	/**< @brief In the calculation of the pf use scale*mfe as an estimate for the ensemble free energy (used to avoid overflows).
 (default='1.07').  */
  char * pfScale_orig;	/**< @brief In the calculation of the pf use scale*mfe as an estimate for the ensemble free energy (used to avoid overflows).
 original value given at command line.  */
  const char *pfScale_help; /**< @brief In the calculation of the pf use scale*mfe as an estimate for the ensemble free energy (used to avoid overflows).
 help description.  */
  int circ_flag;	/**< @brief Assume a circular (instead of linear) RNA molecule.
  
 (default=off).  */
  const char *circ_help; /**< @brief Assume a circular (instead of linear) RNA molecule.
  
 help description.  */
  int dos_flag;	/**< @brief Compute density of states instead of secondary structures.
 (default=off).  */
  const char *dos_help; /**< @brief Compute density of states instead of secondary structures.
 help description.  */
  int zuker_flag;	/**< @brief Compute Zuker suboptimals instead of all suboptimal structures within an energy band around the MFE.
  
 (default=off).  */
  const char *zuker_help; /**< @brief Compute Zuker suboptimals instead of all suboptimal structures within an energy band around the MFE.
  
 help description.  */
  int gquad_flag;	/**< @brief Incoorporate G-Quadruplex formation.
 (default=off).  */
  const char *gquad_help; /**< @brief Incoorporate G-Quadruplex formation.
 help description.  */
  int maxBPspan_arg;	/**< @brief Set the maximum base pair span.
  
 (default='-1').  */
  char * maxBPspan_orig;	/**< @brief Set the maximum base pair span.
  
 original value given at command line.  */
  const char *maxBPspan_help; /**< @brief Set the maximum base pair span.
  
 help description.  */
  char * constraint_arg;	/**< @brief Calculate structures subject to constraints.
 (default='').  */
  char * constraint_orig;	/**< @brief Calculate structures subject to constraints.
 original value given at command line.  */
  const char *constraint_help; /**< @brief Calculate structures subject to constraints.
 help description.  */
  int batch_flag;	/**< @brief Use constraints for multiple sequences.
 (default=off).  */
  const char *batch_help; /**< @brief Use constraints for multiple sequences.
 help description.  */
  int canonicalBPonly_flag;	/**< @brief Remove non-canonical base pairs from the structure constraint.
  
 (default=off).  */
  const char *canonicalBPonly_help; /**< @brief Remove non-canonical base pairs from the structure constraint.
  
 help description.  */
  int enforceConstraint_flag;	/**< @brief Enforce base pairs given by round brackets '(' ')' in structure constraint.
  
 (default=off).  */
  const char *enforceConstraint_help; /**< @brief Enforce base pairs given by round brackets '(' ')' in structure constraint.
  
 help description.  */
  char * commands_arg;	/**< @brief Read additional commands from file
.  */
  char * commands_orig;	/**< @brief Read additional commands from file
 original value given at command line.  */
  const char *commands_help; /**< @brief Read additional commands from file
 help description.  */
  char ** sp_data_arg;	/**< @brief Read structure probing data from an input file and guide the predictions accordingly. Must precede the strategy, i.e. a data file must be specified before the corresponding --sp-strategy option!
  
.  */
  char ** sp_data_orig;	/**< @brief Read structure probing data from an input file and guide the predictions accordingly. Must precede the strategy, i.e. a data file must be specified before the corresponding --sp-strategy option!
  
 original value given at command line.  */
  unsigned int sp_data_min; /**< @brief Read structure probing data from an input file and guide the predictions accordingly. Must precede the strategy, i.e. a data file must be specified before the corresponding --sp-strategy option!
  
's minimum occurreces */
  unsigned int sp_data_max; /**< @brief Read structure probing data from an input file and guide the predictions accordingly. Must precede the strategy, i.e. a data file must be specified before the corresponding --sp-strategy option!
  
's maximum occurreces */
  const char *sp_data_help; /**< @brief Read structure probing data from an input file and guide the predictions accordingly. Must precede the strategy, i.e. a data file must be specified before the corresponding --sp-strategy option!
  
 help description.  */
  char ** sp_strategy_arg;	/**< @brief Select the strategy how the probing data is used to guide the structure predictions.
  
 (default='D').  */
  char ** sp_strategy_orig;	/**< @brief Select the strategy how the probing data is used to guide the structure predictions.
  
 original value given at command line.  */
  unsigned int sp_strategy_min; /**< @brief Select the strategy how the probing data is used to guide the structure predictions.
  
's minimum occurreces */
  unsigned int sp_strategy_max; /**< @brief Select the strategy how the probing data is used to guide the structure predictions.
  
's maximum occurreces */
  const char *sp_strategy_help; /**< @brief Select the strategy how the probing data is used to guide the structure predictions.
  
 help description.  */
  char ** sp_preprocess_arg;	/**< @brief Select a method to pre-process the structure probing data before it undergoes conversion by a strategy.
  
 (default='I').  */
  char ** sp_preprocess_orig;	/**< @brief Select a method to pre-process the structure probing data before it undergoes conversion by a strategy.
  
 original value given at command line.  */
  unsigned int sp_preprocess_min; /**< @brief Select a method to pre-process the structure probing data before it undergoes conversion by a strategy.
  
's minimum occurreces */
  unsigned int sp_preprocess_max; /**< @brief Select a method to pre-process the structure probing data before it undergoes conversion by a strategy.
  
's maximum occurreces */
  const char *sp_preprocess_help; /**< @brief Select a method to pre-process the structure probing data before it undergoes conversion by a strategy.
  
 help description.  */
  char * shape_arg;	/**< @brief Use SHAPE reactivity data to guide structure predictions.
  
.  */
  char * shape_orig;	/**< @brief Use SHAPE reactivity data to guide structure predictions.
  
 original value given at command line.  */
  const char *shape_help; /**< @brief Use SHAPE reactivity data to guide structure predictions.
  
 help description.  */
  char * shapeMethod_arg;	/**< @brief Select SHAPE reactivity data incorporation strategy.
  
 (default='D').  */
  char * shapeMethod_orig;	/**< @brief Select SHAPE reactivity data incorporation strategy.
  
 original value given at command line.  */
  const char *shapeMethod_help; /**< @brief Select SHAPE reactivity data incorporation strategy.
  
 help description.  */
  char * shapeConversion_arg;	/**< @brief Select method for SHAPE reactivity conversion.
  
 (default='O').  */
  char * shapeConversion_orig;	/**< @brief Select method for SHAPE reactivity conversion.
  
 original value given at command line.  */
  const char *shapeConversion_help; /**< @brief Select method for SHAPE reactivity conversion.
  
 help description.  */
  double temp_arg;	/**< @brief Rescale energy parameters to a temperature of temp C. Default is 37C.
  
 (default='37.0').  */
  char * temp_orig;	/**< @brief Rescale energy parameters to a temperature of temp C. Default is 37C.
  
 original value given at command line.  */
  const char *temp_help; /**< @brief Rescale energy parameters to a temperature of temp C. Default is 37C.
  
 help description.  */
  char * paramFile_arg;	/**< @brief Read energy parameters from paramfile, instead of using the default parameter set.
.  */
  char * paramFile_orig;	/**< @brief Read energy parameters from paramfile, instead of using the default parameter set.
 original value given at command line.  */
  const char *paramFile_help; /**< @brief Read energy parameters from paramfile, instead of using the default parameter set.
 help description.  */
  int noTetra_flag;	/**< @brief Do not include special tabulated stabilizing energies for tri-, tetra- and hexaloop hairpins.
 (default=off).  */
  const char *noTetra_help; /**< @brief Do not include special tabulated stabilizing energies for tri-, tetra- and hexaloop hairpins.
 help description.  */
  double salt_arg;	/**< @brief Set salt concentration in molar (M). Default is 1.021M.
  
.  */
  char * salt_orig;	/**< @brief Set salt concentration in molar (M). Default is 1.021M.
  
 original value given at command line.  */
  const char *salt_help; /**< @brief Set salt concentration in molar (M). Default is 1.021M.
  
 help description.  */
  char * modifications_arg;	/**< @brief Allow for modified bases within the RNA sequence string.
 (default='7I6P9D').  */
  char * modifications_orig;	/**< @brief Allow for modified bases within the RNA sequence string.
 original value given at command line.  */
  const char *modifications_help; /**< @brief Allow for modified bases within the RNA sequence string.
 help description.  */
  char ** mod_file_arg;	/**< @brief Use additional modified base data from JSON file.
  
.  */
  char ** mod_file_orig;	/**< @brief Use additional modified base data from JSON file.
  
 original value given at command line.  */
  unsigned int mod_file_min; /**< @brief Use additional modified base data from JSON file.
  
's minimum occurreces */
  unsigned int mod_file_max; /**< @brief Use additional modified base data from JSON file.
  
's maximum occurreces */
  const char *mod_file_help; /**< @brief Use additional modified base data from JSON file.
  
 help description.  */
  int dangles_arg;	/**< @brief How to treat \"dangling end\" energies for bases adjacent to helices in free ends and multi-loops.
 (default='2').  */
  char * dangles_orig;	/**< @brief How to treat \"dangling end\" energies for bases adjacent to helices in free ends and multi-loops.
 original value given at command line.  */
  const char *dangles_help; /**< @brief How to treat \"dangling end\" energies for bases adjacent to helices in free ends and multi-loops.
 help description.  */
  int noLP_flag;	/**< @brief Produce structures without lonely pairs (helices of length 1).
 (default=off).  */
  const char *noLP_help; /**< @brief Produce structures without lonely pairs (helices of length 1).
 help description.  */
  int noGU_flag;	/**< @brief Do not allow GU pairs.
  
 (default=off).  */
  const char *noGU_help; /**< @brief Do not allow GU pairs.
  
 help description.  */
  int noClosingGU_flag;	/**< @brief Do not allow GU pairs at the end of helices.
  
 (default=off).  */
  const char *noClosingGU_help; /**< @brief Do not allow GU pairs at the end of helices.
  
 help description.  */
  int logML_flag;	/**< @brief Recompute energies of structures using a logarithmic energy function for multi-loops before output. (default=off).  */
  const char *logML_help; /**< @brief Recompute energies of structures using a logarithmic energy function for multi-loops before output. help description.  */
  char * nsp_arg;	/**< @brief Allow other pairs in addition to the usual AU,GC,and GU pairs.
.  */
  char * nsp_orig;	/**< @brief Allow other pairs in addition to the usual AU,GC,and GU pairs.
 original value given at command line.  */
  const char *nsp_help; /**< @brief Allow other pairs in addition to the usual AU,GC,and GU pairs.
 help description.  */
  int energyModel_arg;	/**< @brief Set energy model.
.  */
  char * energyModel_orig;	/**< @brief Set energy model.
 original value given at command line.  */
  const char *energyModel_help; /**< @brief Set energy model.
 help description.  */
  float helical_rise_arg;	/**< @brief Set the helical rise of the helix in units of Angstrom.
 (default='2.8').  */
  char * helical_rise_orig;	/**< @brief Set the helical rise of the helix in units of Angstrom.
 original value given at command line.  */
  const char *helical_rise_help; /**< @brief Set the helical rise of the helix in units of Angstrom.
 help description.  */
  float backbone_length_arg;	/**< @brief Set the average backbone length for looped regions in units of Angstrom.
 (default='6.0').  */
  char * backbone_length_orig;	/**< @brief Set the average backbone length for looped regions in units of Angstrom.
 original value given at command line.  */
  const char *backbone_length_help; /**< @brief Set the average backbone length for looped regions in units of Angstrom.
 help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int detailed_help_given ;	/**< @brief Whether detailed-help was given.  */
  unsigned int full_help_given ;	/**< @brief Whether full-help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int verbose_given ;	/**< @brief Whether verbose was given.  */
  unsigned int infile_given ;	/**< @brief Whether infile was given.  */
  unsigned int outfile_given ;	/**< @brief Whether outfile was given.  */
  unsigned int noconv_given ;	/**< @brief Whether noconv was given.  */
  unsigned int auto_id_given ;	/**< @brief Whether auto-id was given.  */
  unsigned int id_prefix_given ;	/**< @brief Whether id-prefix was given.  */
  unsigned int id_delim_given ;	/**< @brief Whether id-delim was given.  */
  unsigned int id_digits_given ;	/**< @brief Whether id-digits was given.  */
  unsigned int id_start_given ;	/**< @brief Whether id-start was given.  */
  unsigned int filename_delim_given ;	/**< @brief Whether filename-delim was given.  */
  unsigned int filename_full_given ;	/**< @brief Whether filename-full was given.  */
  unsigned int log_level_given ;	/**< @brief Whether log-level was given.  */
  unsigned int log_file_given ;	/**< @brief Whether log-file was given.  */
  unsigned int log_time_given ;	/**< @brief Whether log-time was given.  */
  unsigned int log_call_given ;	/**< @brief Whether log-call was given.  */
  unsigned int deltaEnergy_given ;	/**< @brief Whether deltaEnergy was given.  */
  unsigned int deltaEnergyPost_given ;	/**< @brief Whether deltaEnergyPost was given.  */
  unsigned int sorted_given ;	/**< @brief Whether sorted was given.  */
  unsigned int en_only_given ;	/**< @brief Whether en-only was given.  */
  unsigned int stochBT_given ;	/**< @brief Whether stochBT was given.  */
  unsigned int stochBT_en_given ;	/**< @brief Whether stochBT_en was given.  */
  unsigned int random_seed_given ;	/**< @brief Whether random-seed was given.  */
  unsigned int betaScale_given ;	/**< @brief Whether betaScale was given.  */
  unsigned int nonRedundant_given ;	/**< @brief Whether nonRedundant was given.  */
  unsigned int pfScale_given ;	/**< @brief Whether pfScale was given.  */
  unsigned int circ_given ;	/**< @brief Whether circ was given.  */
  unsigned int dos_given ;	/**< @brief Whether dos was given.  */
  unsigned int zuker_given ;	/**< @brief Whether zuker was given.  */
  unsigned int gquad_given ;	/**< @brief Whether gquad was given.  */
  unsigned int maxBPspan_given ;	/**< @brief Whether maxBPspan was given.  */
  unsigned int constraint_given ;	/**< @brief Whether constraint was given.  */
  unsigned int batch_given ;	/**< @brief Whether batch was given.  */
  unsigned int canonicalBPonly_given ;	/**< @brief Whether canonicalBPonly was given.  */
  unsigned int enforceConstraint_given ;	/**< @brief Whether enforceConstraint was given.  */
  unsigned int commands_given ;	/**< @brief Whether commands was given.  */
  unsigned int sp_data_given ;	/**< @brief Whether sp-data was given.  */
  unsigned int sp_strategy_given ;	/**< @brief Whether sp-strategy was given.  */
  unsigned int sp_preprocess_given ;	/**< @brief Whether sp-preprocess was given.  */
  unsigned int shape_given ;	/**< @brief Whether shape was given.  */
  unsigned int shapeMethod_given ;	/**< @brief Whether shapeMethod was given.  */
  unsigned int shapeConversion_given ;	/**< @brief Whether shapeConversion was given.  */
  unsigned int temp_given ;	/**< @brief Whether temp was given.  */
  unsigned int paramFile_given ;	/**< @brief Whether paramFile was given.  */
  unsigned int noTetra_given ;	/**< @brief Whether noTetra was given.  */
  unsigned int salt_given ;	/**< @brief Whether salt was given.  */
  unsigned int modifications_given ;	/**< @brief Whether modifications was given.  */
  unsigned int mod_file_given ;	/**< @brief Whether mod-file was given.  */
  unsigned int dangles_given ;	/**< @brief Whether dangles was given.  */
  unsigned int noLP_given ;	/**< @brief Whether noLP was given.  */
  unsigned int noGU_given ;	/**< @brief Whether noGU was given.  */
  unsigned int noClosingGU_given ;	/**< @brief Whether noClosingGU was given.  */
  unsigned int logML_given ;	/**< @brief Whether logML was given.  */
  unsigned int nsp_given ;	/**< @brief Whether nsp was given.  */
  unsigned int energyModel_given ;	/**< @brief Whether energyModel was given.  */
  unsigned int helical_rise_given ;	/**< @brief Whether helical-rise was given.  */
  unsigned int backbone_length_given ;	/**< @brief Whether backbone-length was given.  */

} ;

/** @brief The additional parameters to pass to parser functions */
struct RNAsubopt_cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure RNAsubopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure RNAsubopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *RNAsubopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *RNAsubopt_args_info_usage;
/** @brief the description string of the program */
extern const char *RNAsubopt_args_info_description;
/** @brief all the lines making the help output */
extern const char *RNAsubopt_args_info_help[];
/** @brief all the lines making the full help output (including hidden options) */
extern const char *RNAsubopt_args_info_full_help[];
/** @brief all the lines making the detailed help output (including hidden options and details) */
extern const char *RNAsubopt_args_info_detailed_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int RNAsubopt_cmdline_parser (int argc, char **argv,
  struct RNAsubopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use RNAsubopt_cmdline_parser_ext() instead
 */
int RNAsubopt_cmdline_parser2 (int argc, char **argv,
  struct RNAsubopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int RNAsubopt_cmdline_parser_ext (int argc, char **argv,
  struct RNAsubopt_args_info *args_info,
  struct RNAsubopt_cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int RNAsubopt_cmdline_parser_dump(FILE *outfile,
  struct RNAsubopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int RNAsubopt_cmdline_parser_file_save(const char *filename,
  struct RNAsubopt_args_info *args_info);

/**
 * Print the help
 */
void RNAsubopt_cmdline_parser_print_help(void);
/**
 * Print the full help (including hidden options)
 */
void RNAsubopt_cmdline_parser_print_full_help(void);
/**
 * Print the detailed help (including hidden options and details)
 */
void RNAsubopt_cmdline_parser_print_detailed_help(void);
/**
 * Print the version
 */
void RNAsubopt_cmdline_parser_print_version(void);

/**
 * Initializes all the fields a RNAsubopt_cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void RNAsubopt_cmdline_parser_params_init(struct RNAsubopt_cmdline_parser_params *params);

/**
 * Allocates dynamically a RNAsubopt_cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized RNAsubopt_cmdline_parser_params structure
 */
struct RNAsubopt_cmdline_parser_params *RNAsubopt_cmdline_parser_params_create(void);

/**
 * Initializes the passed RNAsubopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void RNAsubopt_cmdline_parser_init (struct RNAsubopt_args_info *args_info);
/**
 * Deallocates the string fields of the RNAsubopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void RNAsubopt_cmdline_parser_free (struct RNAsubopt_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int RNAsubopt_cmdline_parser_required (struct RNAsubopt_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* RNASUBOPT_CMDL_H */
