#pragma once

#include <stddef.h>

// A lot of these logos come from the following projects:
//   - neofetch: https://github.com/dylanaraps/neofetch
//   - fastfetch: https://github.com/fastfetch-cli/fastfetch

static char *logos[][32] = {
    // please leave logos[0] to Linux and logos[1] to macOS
    {
        // Linux - default logo
        "linux",                 // this first line contains the distro ID, taken from /etc/os-release
        "\033[90m",              // default color for the printed text
        "        #####        ", // just the logo
        "       #######       ", "       ##\033[37mO\033[90m#\033[37mO\033[90m##       ", "       #\033[33m#####\033[90m#       ",
        "     ##\033[37m##\033[33m###\033[37m##\033[90m##     ", "    #\033[37m##########\033[90m##    ", "   #\033[37m############\033[90m##   ",
        "   #\033[37m############\033[90m###  ", "  ##\033[90m#\033[37m###########\033[90m##\033[33m#  ", "######\033[90m#\033[37m#######\033[90m#\033[33m######",
        "#######\033[90m#\033[37m#####\033[90m#\033[33m#######", "  #####\033[90m#######\033[33m#####  ",
        NULL // the logo is terminated by NULL
    },
    {// Alpine Linux
     "alpine",
     "\033[34m",
     "       .hddddddddddddddddddddddh.       ",
     "      :dddddddddddddddddddddddddd:      ",
     "     /dddddddddddddddddddddddddddd/     ",
     "    +dddddddddddddddddddddddddddddd+    ",
     "  `sdddddddddddddddddddddddddddddddds`  ",
     " `ydddddddddddd++hdddddddddddddddddddy` ",
     " `ydddddddddddd++hdddddddddddddddddddy` ",
     "hdddddddddd+`      `+y:    .sddddddddddh",
     "ddddddddh+`   `//`   `.`     -sddddddddd",
     "ddddddh+`   `/hddh/`   `:s-    -sddddddd",
     "ddddh+`   `/+/dddddh/`   `+s-    -sddddd",
     "ddd+`   `/o` :dddddddh/`   `oy-    .yddd",
     "hdddyo+ohddyosdddddddddho+oydddy++ohdddh",
     ".hddddddddddddddddddddddddddddddddddddh.",
     " `yddddddddddddddddddddddddddddddddddy` ",
     "  `sdddddddddddddddddddddddddddddddds`  ",
     "    +dddddddddddddddddddddddddddddd+    ",
     "     /dddddddddddddddddddddddddddd/     ",
     "      :dddddddddddddddddddddddddd:      ",
     "       .hddddddddddddddddddddddh.       ",
     NULL},
    {// Android
     "android",
     "\033[32m",
     "         -o          o-         ",
     "          +hydNNNNdyh+          ",
     "        +mMMMMMMMMMMMMm+        ",
     "      `dMM\033[37mm:\033[32mNMMMMMMN\033[37m:m\033[32mMMd`      ",
     "      hMMMMMMMMMMMMMMMMMMh      ",
     "  ..  yyyyyyyyyyyyyyyyyyyy  ..  ",
     ".mMMm`MMMMMMMMMMMMMMMMMMMM`mMMm.",
     ":MMMM-MMMMMMMMMMMMMMMMMMMM-MMMM:",
     ":MMMM-MMMMMMMMMMMMMMMMMMMM-MMMM:",
     ":MMMM-MMMMMMMMMMMMMMMMMMMM-MMMM:",
     ":MMMM-MMMMMMMMMMMMMMMMMMMM-MMMM:",
     "-MMMM-MMMMMMMMMMMMMMMMMMMM-MMMM-",
     " +yy+ MMMMMMMMMMMMMMMMMMMM +yy+ ",
     "      mMMMMMMMMMMMMMMMMMMm      ",
     "      `/++MMMMh++hMMMM++/`      ",
     "          MMMMo  oMMMM          ",
     "          MMMMo  oMMMM          ",
     "          oNMm-  -mMNs          ",
     NULL},
    {// macOS
     "apple",
     "\033[35m",
     "\033[32m                    'c.       ",
     "\033[32m                 ,xNMM.       ",
     "\033[32m               .OMMMMo        ",
     "\033[32m               OMMM0,         ",
     "\033[32m     .;loddo:' loolloddol;.   ",
     "\033[32m   cKMMMMMMMMMMNWMMMMMMMMMM0: ",
     "\033[33m .KMMMMMMMMMMMMMMMMMMMMMMMWd. ",
     "\033[33m XMMMMMMMMMMMMMMMMMMMMMMMX.   ",
     "\033[31m;MMMMMMMMMMMMMMMMMMMMMMMM:    ",
     "\033[31m:MMMMMMMMMMMMMMMMMMMMMMMM:    ",
     "\033[31m.MMMMMMMMMMMMMMMMMMMMMMMMX.   ",
     "\033[31m kMMMMMMMMMMMMMMMMMMMMMMMMWd. ",
     "\033[31m .XMMMMMMMMMMMMMMMMMMMMMMMMMMk",
     "\033[31m  .XMMMMMMMMMMMMMMMMMMMMMMMMK.",
     "\033[34m    kMMMMMMMMMMMMMMMMMMMMMMd  ",
     "\033[34m     ;KMMMMMMMWXXWMMMMMMMk.   ",
     "\033[34m       .cooc,.    .,coo:.     ",
     NULL},
    {// Arch Linux
     "arch",
     "\033[36m",
     "                  -`                 ",
     "                 .o+`                ",
     "                `ooo/                ",
     "               `+oooo:               ",
     "              `+oooooo:              ",
     "              -+oooooo+:             ",
     "            `/:-:++oooo+:            ",
     "           `/++++/+++++++:           ",
     "          `/++++++++++++++:          ",
     "         `/+++ooooooooooooo/`        ",
     "        ./ooosssso++osssssso+`       ",
     "       .oossssso-````/ossssss+`      ",
     "      -osssssso.      :ssssssso.     ",
     "     :osssssss/        osssso+++.    ",
     "    /ossssssss/        +ssssooo/-    ",
     "  `/ossssso+/:-        -:/+osssso+-  ",
     " `+sso+:-`                 `.-/+oso: ",
     "`++:.                           `-/+/",
     ".`                                 `/",
     NULL},
    {// Arch Linux (small version)
     "arch_small", "\033[36m", "      /\\      ", "     /  \\     ", "    /\\   \\    ", "   /      \\   ", "  /   ,,   \\  ", " /   |  |  -\\ ", "/_-''    ''-_\\", NULL},
    {// Artix Linux
     "artix",
     "\033[36m",
     "                  o                  ",
     "                 ooo                 ",
     "                ooxoo                ",
     "               ooxxxoo               ",
     "              oookkxxoo              ",
     "             oiioxkkxxoo             ",
     "            :;:iiiioxxxoo            ",
     "              `'.;::ioxxoo           ",
     "          -.      `':;jiooo          ",
     "         oooio-..     `'i:io         ",
     "        ooooxxxxoio:,.   `'-;        ",
     "       ooooxxxxxkkxoooIi:-.  `       ",
     "      ooooxxxxxkkkkxoiiiiiji'        ",
     "     ooooxxxxxkxxoiiii:'`     .i     ",
     "    ooooxxxxxoi:::'`       .;ioxo    ",
     "   ooooxooi::'`         .:iiixkxxo   ",
     "  ooooi:'`                `'';ioxxo  ",
     " i:'`                          '':io ",
     "`                                   `",
     NULL},
    {// Debian
     "debian",
     "\033[31m",
     "       _,met$$$$$gg.        ",
     "    ,g$$$$$$$$$$$$$$$P.     ",
     "  ,g$$P\"     \"\"\"Y$$.\".      ",
     " ,$$P'              `$$$.   ",
     "',$$P       ,ggs.     `$$b: ",
     "`d$$'     ,$P\"'   \033[37m.\033[31m    $$$  ",
     " $$P      d$'     \033[37m,\033[31m    $$P  ",
     " $$:      $$.   \033[37m-\033[31m    ,d$$'  ",
     " $$;      Y$b._   _,d$P'    ",
     " Y$$.    \033[37m`.\033[31m`\"Y$$$$P\"'       ",
     " `$$b      \033[37m\"-.__\033[31m            ",
     "  `Y$$                      ",
     "   `Y$$.                    ",
     "     `$$b.                  ",
     "       `Y$$b.               ",
     "          `\"Y$b._           ",
     "              `\"\"\"          ",
     NULL},
     {//Devuan Linux
     "devuan",
     "\033[34m",
     "   ..,,;;;::;,..                      ",
     "           `':ddd;:,.                 ",
     "                 `'dPPd:,.            ",
     "                     `:b$$$$b`.       ",
     "                        'P$$$$$d`     ",
     "                         .$$$$$$$$$`  ",
     "                         ;$$$$$$$$$P  ",
     "                      .:P$$$$$$$$$$$$`",
     "                  .,:b$$$$$$$$$$$$$;' ",
     "             .,:dP$$$$$$$$$$$$$$$$b:' ",
     "      .,:;db$$$$$$$$$$$$$$$$$$$$Pd'`  ",
     " ,db$$$$$$$$$$$$$$$$$$$$$$$$$$$$b:'`  ",
     ":$$$$$$$$$$$$$$$$$$$$$$$$b:'`         ",
     " `$$$$$$$$$bd:''`                     ",
     "   `'''`                              ",
     NULL},
    {// ElementaryOS
     "elementary",
     "\033[34m",
     "\033[90m         eeeeeeeeeeeeeeeee          ",
     "\033[97m      eeeeeeeeeeeeeeeeeeeeeee       ",
     "\033[97m    eeeee  eeeeeeeeeeee   eeeee     ",
     "\033[97m  eeee   eeeee       eee     eeee   ",
     "\033[97m eeee   eeee          eee     eeee  ",
     "\033[97meee    eee            eee       eee ",
     "\033[97meee   eee            eee        eee ",
     "\033[97mee    eee           eeee       eeee ",
     "\033[97mee    eee         eeeee      eeeeee ",
     "\033[97mee    eee       eeeee      eeeee ee ",
     "\033[97meee   eeee   eeeeee      eeeee  eee ",
     "\033[97meee    eeeeeeeeee     eeeeee    eee ",
     "\033[97m eeeeeeeeeeeeeeeeeeeeeeee    eeeee  ",
     "\033[97m  eeeeeeee eeeeeeeeeeee      eeee   ",
     "\033[97m    eeeee                 eeeee     ",
     "\033[97m      eeeeeee         eeeeeee       ",
     "\033[97m         eeeeeeeeeeeeeeeee          ",
     NULL},
    {// Endeavour OS
     "endeavouros", "\033[35m", "\033[31m                     ./\033[35mo\033[34m.               ", "\033[31m                   ./\033[35msssso\033[34m-             ",
     "\033[31m                 `:\033[35mosssssss+\033[34m-           ", "\033[31m               `:+\033[35msssssssssso\033[34m/.         ",
     "\033[31m             `-/o\033[35mssssssssssssso\033[34m/.       ", "\033[31m           `-/+\033[35msssssssssssssssso\033[34m+:`     ",
     "\033[31m         `-:/+\033[35msssssssssssssssssso«\033[34m+/.   ", "\033[31m       `.://\033[35mosssssssssssssssssssso\033[34m++-   ",
     "\033[31m      .://+\033[35mssssssssssssssssssssssso\033[34m++:  ", "\033[31m    .:///\033[35mossssssssssssssssssssssssso\033[34m++: ",
     "\033[31m  `:////\033[35mssssssssssssssssssssssssssso\033[34m+++.", "\033[31m`-////+\033[35mssssssssssssssssssssssssssso\033[34m++++-",
     "\033[31m `..-+\033[35moosssssssssssssssssssssssso\033[34m+++++/`", "\033[34m   ./++++++++++++++++++++++++++++++/:.  ", "\033[34m  `:::::::::::::::::::::::::------``    ",
     NULL},
    {// Fedora
     "fedora",
     "\033[34m",
     "          /:-------------:\\       ",
     "       :-------------------::     ",
     "     :-----------\033[39m/shhOHbmp\033[34m---:\\   ",
     "   /-----------\033[39momMMMNNNMMD\033[34m]  ---: ",
     "  :-----------\033[39msMMMMNMNMP\033[34m.    ---: ",
     " :-----------\033[39m:MMMdP\033[34m-------    ---\\",
     ",------------\033[39m:MMMd\033[34m--------    ---:",
     ":------------\033[39m:MMMd\033[34m-------    .---:",
     ":----    \033[39moNMMMMMMMMMNho\033[34m     .----:",
     ":--     .\033[39m+shhhMMMmhhy++\033[34m   .------/",
     ":-    -------\033[39m:MMMd\033[34m--------------: ",
     ":-   --------\033[39m/MMMd\033[34m-------------;  ",
     ":-    ------\033[39m/hMMMy\033[34m------------:   ",
     ":-- \033[39m:dMNdhhdNMMNo\033[34m------------;    ",
     ":---\033[39m:sdNMMMMNds:\033[34m------------:     ",
     ":------\033[39m:://:\033[34m-------------::       ",
     ":---------------------://         ",
     NULL},
    {// Garuda Linux
     "garuda",
     "\033[31m",
     "                   .%;888:8898898:            ",
     "                 x;XxXB%89b8:b8%b88:          ",
     "              .8Xxd                8X:.       ",
     "            .8Xx;                    8x:.     ",
     "          .tt8x          .d            x88;   ",
     "       .@8x8;          .db:              xx@; ",
     "     ,tSXX°          .bbbbbbbbbbbbbbbbbbbB8x@;",
     "   .SXxx            bBBBBBBBBBBBBBBBBBBBbSBX8;",
     " ,888S                                     pd!",
     "8X88/                                       q ",
     "8X88/                                         ",
     "GBB.                                          ",
     " x%88        d888@8@X@X@X88X@@XX@@X@8@X.      ",
     "   dxXd    dB8b8b8B8B08bB88b998888b88x.       ",
     "    dxx8o                      .@@;.          ",
     "      dx88                   .t@x.            ",
     "        d:SS@8ba89aa67a853Sxxad.              ",
     "          .d988999889889899dd.                ",
     NULL},
    {// Gentoo
     "gentoo",
     "\033[35m",
     "         -/oyddmdhs+:.             ",
     "    -o\033[97mdNMMMMMMMMNNmhy+\033[35m-`           ",
     "   -y\033[97mNMMMMMMMMMMMNNNmmdhy\033[35m+-        ",
     " `o\033[97mmMMMMMMMMMMMMNmdmmmmddhhy\033[35m/`     ",
     " om\033[97mMMMMMMMMMMMN\033[35mhhyyyo\033[97mhmdddhhhd\033[35mo`   ",
     ".y\033[97mdMMMMMMMMMMd\033[35mhs++so/s\033[97mmdddhhhhdm\033[35m+` ",
     " oy\033[97mhdmNMMMMMMMN\033[35mdyooy\033[97mdmddddhhhhyhN\033[35md.",
     "  :o\033[97myhhdNNMMMMMMMNNNmmdddhhhhhyym\033[35mMh",
     "    .:\033[97m+sydNMMMMMNNNmmmdddhhhhhhmM\033[35mmy",
     "       /m\033[97mMMMMMMNNNmmmdddhhhhhmMNh\033[35ms:",
     "    `o\033[97mNMMMMMMMNNNmmmddddhhdmMNhs\033[35m+` ",
     "  `s\033[97mNMMMMMMMMNNNmmmdddddmNMmhs\033[35m/.   ",
     " /N\033[97mMMMMMMMMNNNNmmmdddmNMNdso\033[35m:`     ",
     "+M\033[97mMMMMMMNNNNNmmmmdmNMNdso\033[35m/-        ",
     "yM\033[97mMNNNNNNNmmmmmNNMmhs+/\033[35m-`          ",
     "/h\033[97mMMNNNNNNNNMNdhs++/\033[35m-`             ",
     " `/\033[97mohdmmddhys+++/:\033[35m.`               ",
     "  `-//////:--.                     ",
     NULL},
    {// Linux Mint
     "linuxmint",
     "\033[32m",
     "\033[37m             ...-:::::-...              ",
     "\033[37m          .-MMMMMMMMMMMMMMM-.           ",
     "\033[37m      .-MMMM\033[32m`..-:::::::-..`\033[37mMMMM-.       ",
     "\033[37m    .:MMMM\033[32m.:MMMMMMMMMMMMMMM:.\033[37mMMMM:.     ",
     "\033[37m   -MMM\033[32m-M---MMMMMMMMMMMMMMMMMMM.\033[37mMMM-    ",
     "\033[37m `:MMM\033[32m:MM`  :MMMM:....::-...-MMMM:\033[37mMMM:` ",
     "\033[37m :MMM\033[32m:MMM`  :MM:`  ``    ``  `:MMM:\033[37mMMM: ",
     "\033[37m.MMM\033[32m.MMMM`  :MM.  -MM.  .MM-  `MMMM.\033[37mMMM.",
     "\033[37m:MMM\033[32m:MMMM`  :MM.  -MM-  .MM:  `MMMM-\033[37mMMM:",
     "\033[37m:MMM\033[32m:MMMM`  :MM.  -MM-  .MM:  `MMMM:\033[37mMMM:",
     "\033[37m:MMM\033[32m:MMMM`  :MM.  -MM-  .MM:  `MMMM-\033[37mMMM:",
     "\033[37m.MMM\033[32m.MMMM`  :MM:--:MM:--:MM:  `MMMM.\033[37mMMM.",
     "\033[37m :MMM\033[32m:MMM-  `-MMMMMMMMMMMM-`  -MMM-\033[37mMMM: ",
     "\033[37m  :MMM\033[32m:MMM:`                `:MMM:\033[37mMMM:  ",
     "\033[37m   .MMM\033[32m.MMMM:--------------:MMMM.\033[37mMMM.   ",
     "\033[37m     '-MMMM\033[32m.-MMMMMMMMMMMMMMM-.\033[37mMMMM-'    ",
     "\033[37m       '.-MMMM\033[32m``--:::::--``\033[37mMMMM-.'      ",
     "\033[37m            '-MMMMMMMMMMMMM-'           ",
     "\033[37m               ``-:::::-``              ",
     NULL},
    {// Mageia
     "mageia",
     "\033[36m",
     "        .°°.            ",
     "         °°   .°°.      ",
     "         .°°°. °°       ",
     "         .   .          ",
     "          °°° .°°°.     ",
     "      .°°°.   '___'     ",
     "     .'___'        .    ",
     "\033[37m   :dkxc;'.  ..,cxkd;   ",
     "\033[37m .dkk. kkkkkkkkkk .kkd. ",
     "\033[37m.dkk.  ';cloolc;.  .kkd ",
     "\033[37mckk.                .kk;",
     "\033[37mxO:                  cOd",
     "\033[37mxO:                  lOd",
     "\033[37mlOO.                .OO:",
     "\033[37m.k00.              .00x ",
     "\033[37m .k00;            ;00O. ",
     "\033[37m  .lO0Kc;,,,,,,;c0KOc.  ",
     "\033[37m     ;d00KKKKKK00d;     ",
     "\033[37m        .,KKKK,.        ",
     NULL},
    {// Manjaro Linux
     "manjaro", "\033[32m", "██████████████████  ████████", "██████████████████  ████████", "██████████████████  ████████", "██████████████████  ████████",
     "████████            ████████", "████████  ████████  ████████", "████████  ████████  ████████", "████████  ████████  ████████", "████████  ████████  ████████",
     "████████  ████████  ████████", "████████  ████████  ████████", "████████  ████████  ████████", "████████  ████████  ████████", "████████  ████████  ████████", NULL},
    {// KDE Neon
     "neon",
     "\033[32m",
     "             `..---+/---..`             ",
     "         `---.``   ``   `.---.`         ",
     "      .--.`        ``        `-:-.      ",
     "    `:/:     `.----//----.`     :/-     ",
     "   .:.    `---`          `--.`    .:`   ",
     "  .:`   `--`                .:-    `:.  ",
     " `/    `:.      `.-::-.`      -:`   `/` ",
     " /.    /.     `:++++++++:`     .:    .: ",
     "`/    .:     `+++++++++++/      /`   `+`",
     "/+`   --     .++++++++++++`     :.   .+:",
     "`/    .:     `+++++++++++/      /`   `+`",
     " /`    /.     `:++++++++:`     .:    .: ",
     " ./    `:.      `.:::-.`      -:`   `/` ",
     "  .:`   `--`                .:-    `:.  ",
     "   .:.    `---`          `--.`    .:`   ",
     "    `:/:     `.----//----.`     :/-     ",
     "      .-:.`        ``        `-:-.      ",
     "         `---.``   ``   `.---.`         ",
     "             `..---+/---..`             ",
     NULL},
    {// NixOS
     "nixos",
     "\033[36m",
     "\033[34m          ::::.   \033[36m ':::::     ::::'        ",
     "\033[34m          ':::::    \033[36m':::::.  ::::'         ",
     "\033[34m            :::::     \033[36m'::::.:::::          ",
     "\033[34m      .......:::::..... \033[36m::::::::           ",
     "\033[34m     ::::::::::::::::::. \033[36m::::::    \033[34m::::.   ",
     "\033[34m    ::::::::::::::::::::: \033[36m:::::.  \033[34m.::::'   ",
     "           .....           \033[36m::::' \033[34m:::::'    ",
     "          :::::            \033[36m'::' \033[34m:::::'     ",
     " ........:::::               \033[36m' \033[34m:::::::::::.",
     ":::::::::::::                 \033[34m:::::::::::::",
     " ::::::::::: \033[34m..              \033[34m:::::         ",
     "     .::::: \033[34m.:::            \033[34m:::::          ",
     "  .:::::  \033[34m:::::          \033[34m'''''    \033[36m.....    ",
     "    :::::   \033[34m':::::.  \033[36m......:::::::::::::'  ",
     "     :::     \033[34m::::::. \033[36m':::::::::::::::::'   ",
     "\033[34m            .:::::::: \033[36m'::::::::::          ",
     "\033[34m           .::::''::::.     \033[36m'::::.         ",
     "\033[34m          .::::'   ::::.     \033[36m'::::.        ",
     "\033[34m         .::::      ::::      \033[36m'::::.       ",
     NULL},
    {// Parrot OS
     "parrot",
     "\033[36m",
     "  `:oho/-`                             ",
     "`mMMMMMMMMMMMNmmdhy-                   ",
     " dMMMMMMMMMMMMMMMMMMs`                 ",
     " +MMsohNMMMMMMMMMMMMMm/                ",
     " .My   .+dMMMMMMMMMMMMMh.              ",
     "  +       :NMMMMMMMMMMMMNo             ",
     "           `yMMMMMMMMMMMMMm:           ",
     "             /NMMMMMMMMMMMMMy`         ",
     "              .hMMMMMMMMMMMMMN+        ",
     "                  ``-NMMMMMMMMMd-      ",
     "                     /MMMMMMMMMMMs`    ",
     "                      mMMMMMMMsyNMN/   ",
     "                      +MMMMMMMo  :sNh. ",
     "                      `NMMMMMMm     -o/",
     "                       oMMMMMMM.       ",
     "                       `NMMMMMM+       ",
     "                        +MMd/NMh       ",
     "                         mMm -mN`      ",
     "                         /MM  `h:      ",
     "                          dM`   .      ",
     "                          :M-          ",
     "                           d:          ",
     "                           -+          ",
     "                            -          ",
     NULL},
    {// Pop!_OS
     "pop",
     "\033[36m",
     "             /////////////             ",
     "         /////////////////////         ",
     "      ///////\033[39m*767\033[36m////////////////      ",
     "    //////\033[39m7676767676*\033[36m//////////////    ",
     "   /////\033[39m76767\033[36m//\033[39m7676767\033[36m//////////////   ",
     "  /////\033[39m767676\033[36m///\033[39m*76767\033[36m///////////////  ",
     " ///////\033[39m767676\033[36m///\033[39m76767\033[36m].///\033[39m7676*\033[36m///////",
     "/////////\033[39m767676\033[36m//\033[39m76767\033[36m///\033[39m767676\033[36m////////",
     "//////////\033[39m76767676767\033[36m////\033[39m76767\033[36m/////////",
     "///////////\033[39m76767676\033[36m//////\033[39m7676\033[36m//////////",
     "////////////,\033[39m7676\033[36m,///////\033[39m767\033[36m///////////",
     "/////////////*\033[39m7676\033[36m///////\033[39m76\033[36m////////////",
     "///////////////\033[39m7676\033[36m////////////////////",
     " ///////////////\033[39m7676\033[36m///\033[39m767\033[36m//////////// ",
     "  //////////////////////\033[39m'\033[36m////////////  ",
     "   //////\033[39m.7676767676767676767,\033[36m//////   ",
     "    /////\033[39m767676767676767676767\033[36m/////    ",
     "      ///////////////////////////      ",
     "         /////////////////////         ",
     "             /////////////             ",
     NULL},
    {// Rocky Linux
     "rocky",
     "\033[32m",
     "          __wgliliiligw_,          ",
     "       _williiiiiiliilililw,       ",
     "     _%iiiiiilililiiiiiiiiiii_     ",
     "   .Qliiiililiiiiiiililililiilm.   ",
     "  _iiiiiliiiiiililiiiiiiiiiiliil,  ",
     " .lililiiilililiiiilililililiiiii, ",
     "_liiiiiiliiiiiiiliiiiiF{iiiiiilili,",
     "jliililiiilililiiili@`  ~ililiiiiiL",
     "iiiliiiiliiiiiiili>`      ~liililii",
     "liliiiliiilililii`         -9liiiil",
     "iiiiiliiliiiiii~             \"4lili",
     "4ililiiiiilil~|      -w,       )4lf",
     "-liiiiililiF'       _liig,       )'",
     " )iiiliii@`       _QIililig,       ",
     "  )iiii>`       .Qliliiiililw      ",
     "   )<>~       .mliiiiiliiiiiil,    ",
     "            _gllilililiililii~     ",
     "           giliiiiiiiiiiiiT`       ",
     "          -^~$ililili@~~'          ",
     NULL},
    {// Ubuntu
     "ubuntu",
     "\033[31m",
     "            .-/+oossssoo+/-.            ",
     "        `:+ssssssssssssssssss+:`        ",
     "      -+ssssssssssssssssssyyssss+-      ",
     "    .ossssssssssssssssss\033[37mdMMMNy\033[31msssso.    ",
     "   /sssssssssss\033[37mhdmmNNmmyNMMMMh\033[31mssssss/   ",
     "  +sssssssss\033[37mhm\033[31myd\033[37mMMMMMMMNddddy\033[31mssssssss+  ",
     " /ssssssss\033[37mhNMMM\033[31myh\033[37mhyyyyhmNMMMNh\033[31mssssssss/ ",
     ".ssssssss\033[37mdMMMNh\033[31mssssssssss\033[37mhNMMMd\033[31mssssssss.",
     "+ssss\033[37mhhhyNMMNy\033[31mssssssssssss\033[37myNMMMy\033[31msssssss+",
     "oss\033[37myNMMMNyMMh\033[31mssssssssssssss\033[37mhmmmh\033[31mssssssso",
     "oss\033[37myNMMMNyMMh\033[31msssssssssssssshmmmhssssssso",
     "+ssss\033[37mhhhyNMMNy\033[31mssssssssssss\033[37myNMMMy\033[31msssssss+",
     ".ssssssss\033[37mdMMMNh\033[31mssssssssss\033[37mhNMMMd\033[31mssssssss.",
     " /ssssssss\033[37mhNMMM\033[31myh\033[37mhyyyyhdNMMMNh\033[31mssssssss/ ",
     "  +sssssssss\033[37mdm\033[31myd\033[37mMMMMMMMMddddy\033[31mssssssss+  ",
     "   /sssssssssss\033[37mhdmNNNNmyNMMMMh\033[31mssssss/   ",
     "    .ossssssssssssssssss\033[37mdMMMNy\033[31msssso.    ",
     "      -+sssssssssssssssss\033[37myyy\033[31mssss+-      ",
     "        `:+ssssssssssssssssss+:`        ",
     "            .-/+oossssoo+/-.            ",
     NULL},
     {//Void Linux
     "void",
     "\033[32m",
     "                **.;=====;.**                ",
     "            _.=+==++=++=+=+===;.             ",
     "             -=+++=+===+=+=+++++=_           ",
     "        .     -=:``     `--==+=++==.         ",
     "       _vi,    `            --+=++++:        ",
     "      .uvnvi.       *.*       -==+==+.       ",
     "     .vvnvnI`    .;==|==;.     :|=||=|.      ",
     "\033[37m+QmQQm\033[32mpvvnv;\033[37m _yYsyQQWUUQQQm #QmQ#\033[32m:\033[37mQQQWUV$QQm.",
     " \033[37m-QQWQW\033[32mpvvo\033[37mwZ?.wQQQE\033[32m==<\033[37mQWWQ/QWQW.QQWW\033[32m(:\033[37m jQWQE",
     "  \033[37m-$QQQQmmU'  jQQQ\033[32m@+=<\033[37mQWQQ)mQQQ.mQQQC\033[32m+;\033[37mjWQQ@'",
     "   \033[37m-$WQ8Y\033[32mnI:\033[37m   QWQQwgQQWV\033[32m`\033[37mmWQQ.jQWQQgyyWW@!  ",
     "     \033[32m-1vvnvv.     `~+++`        ++|+++       ",
     "      \033[32m+vnvnnv,                  `-|===       ",
     "       \033[32m+vnvnvns.           .       =-        ",
     "        \033[32m-Invnvvnsi..___..=sv=.     `         ",
     "          \033[32m+Invnvnvnnnnnnnnvvnn;.",
     "            \033[32m~|Invnvnvvnvvvnnv}+`  ",
     "                \033[32m-~|{*l}*|~        ",
     NULL},
    {// Windows
     "windows", "\033[34m", "\033[31m        ,.=:!!t3Z3z.,                ", "\033[31m       :tt:::tt333EE3                ",
     "\033[31m       Et:::ztt33EEEL \033[32m@Ee.,      .., ", "\033[31m      ;tt:::tt333EE7 \033[32m;EEEEEEttttt33# ", "\033[31m     :Et:::zt333EEQ. \033[32m$EEEEEttttt33QL ",
     "\033[31m     it::::tt333EEF \033[32m@EEEEEEttttt33F  ", "\033[31m    ;3=*^```\"*4EEV \033[32m:EEEEEEttttt33@.  ", "    ,.=::::!t=., \033[31m` \033[32m@EEEEEEtttz33QF   ",
     "   ;::::::::zt33)   \033[32m\"4EEEtttji3P*    ", "  :t::::::::tt33.\033[33m:Z3z..  \033[32m`` \033[33m,..g.    ", "  i::::::::zt33F \033[33mAEEEtttt::::ztF     ",
     " ;:::::::::t33V \033[33m;EEEttttt::::t3      ", " E::::::::zt33L \033[33m@EEEtttt::::z3F      ", "{3=*^```\"*4E3) \033[33m;EEEtttt:::::tZ`      ",
     "             `\033[33m \033[33m:EEEEtttt::::z7       ", "\033[33m                 \"VEzjt:;;z>*`       ", NULL},
    {// Empty Logo
     "none", "", "", NULL},
};
