# Functions reference

## Math

| Function | Meaning |
|---|---|
| sin | [sine](Expressions.md#math) of argument |
| cos | [cosine](Expressions.md#math) of argument |
| tan | [tangent](Expressions.md#math) of argument |
| asin | [inverse sine](Expressions.md#math) of argument |
| acos | [inverse cosine](Expressions.md#math) of argument |
| atan | [inverse tangent](Expressions.md#math) of argument |
| atan2 | [inverse tangent](Expressions.md#math) of two arguments |
| rand | [pseudo random number generator](Expressions.md#random_numbers) |

## Symbols

| Function | Meaning |
|---|---|
| bank | Determines the [symbol's bank](Expressions.md#symbol_functions) |
| def | Determines whether the [symbol is known](Expressions.md#symbol_functions) |

## Motorola 68K

These functions are specific to the M68K assembler.

| Function | Meaning |
|---|---|
| regmask | [Bit mask](Expressions.md#m68k) of register list |


# Further reading
* [Introduction](Introduction.md), goals and background
* [Invoking the assembler](Assembler.md) and basic syntax
* [Symbols](Symbols.md) and labels
* [Control structures](ControlStructures.md) like ```INCLUDE```, ```MACRO```s and conditional assembling.
* [Expressions](Expressions.md) and how they're built
* [Printing diagnostic messages](Diagnostics.md), warnings and errors
* [Organising code](OrganisingCode.md) into sections. How to define data.
* [The linker](Linker.md)

# Index and reference
* [CPU specific](CpuSpecifics.md) details
* [Index of all directives](IndexDirectives.md)
* [Index of all functions](IndexFunctions.md)
* [Operator reference](ReferenceOperators.md)
* [String member reference](ReferenceStringMembers.md)
