/*
 * Decompiled with CFR 0.152.
 */
package de.bottlecaps.markup.blitz.grammar;

import de.bottlecaps.markup.blitz.Errors;
import de.bottlecaps.markup.blitz.grammar.Node;
import de.bottlecaps.markup.blitz.grammar.Rule;
import de.bottlecaps.markup.blitz.grammar.Term;
import de.bottlecaps.markup.blitz.transform.Visitor;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public final class Grammar
extends Node {
    private final String versionString;
    private final Map<String, Rule> rules;
    private Map<Term, String[]> additionalNames;
    private final Version version;
    private boolean mismatch;

    public Grammar(String versionString) {
        this(versionString, null, false);
    }

    public Grammar(Grammar other) {
        this(other.versionString, other.version, other.mismatch);
    }

    private Grammar(String versionString, Version version, boolean mismatch) {
        this.versionString = versionString;
        this.rules = new LinkedHashMap<String, Rule>();
        if (version != null) {
            this.version = version;
            this.mismatch = mismatch;
        } else if (this.versionString == null) {
            this.version = Version.UNSPECIFIED;
            mismatch = false;
        } else {
            this.version = Arrays.stream(Version.values()).filter(v -> this.versionString.equals(v.toString())).findAny().orElse(Version.UNSPECIFIED);
            this.mismatch = this.version == Version.UNSPECIFIED;
        }
    }

    public Version getVersion() {
        return this.version;
    }

    public Map<String, Rule> getRules() {
        return this.rules;
    }

    public Rule getRule(String name) {
        Rule r = this.rules.get(name);
        if (r == null) {
            Errors.S02.thro(name);
        }
        return r;
    }

    public Map<Term, String[]> getAdditionalNames() {
        return this.additionalNames;
    }

    public boolean isMismatch() {
        return this.mismatch;
    }

    public void setAdditionalNames(Map<Term, String[]> additionalNames) {
        this.additionalNames = additionalNames;
    }

    public void addRule(Rule rule) {
        Rule oldRule = this.rules.put(rule.getName(), rule);
        if (oldRule != null) {
            Errors.S03.thro(rule.getName());
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    public Grammar copy() {
        Grammar grammar = new Grammar(this);
        for (Rule rule : this.rules.values()) {
            grammar.addRule(rule.copy());
        }
        return grammar;
    }

    public String toString() {
        return (String)(this.versionString == null ? "" : "ixml version '" + this.versionString.replace("'", "''") + "'\n") + this.rules.values().stream().map(Rule::toString).collect(Collectors.joining("\n"));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rules == null ? 0 : this.rules.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Grammar)) {
            return false;
        }
        Grammar other = (Grammar)obj;
        if (this.rules == null ? other.rules != null : !this.rules.equals(other.rules)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals((Object)other.version));
    }

    public static enum Version {
        V1_0("1.0"),
        V1_1("1.1"),
        UNSPECIFIED("unspecified");

        private String string;

        private Version(String string2) {
            this.string = string2;
        }

        public boolean isAtLeast(Version other) {
            return this.ordinal() >= other.ordinal();
        }

        public String toString() {
            return this.string;
        }
    }
}

