/*
 * Decompiled with CFR 0.152.
 */
package de.bottlecaps.markup.blitz.transform;

import de.bottlecaps.markup.blitz.grammar.Alt;
import de.bottlecaps.markup.blitz.grammar.Alts;
import de.bottlecaps.markup.blitz.grammar.Charset;
import de.bottlecaps.markup.blitz.grammar.Control;
import de.bottlecaps.markup.blitz.grammar.Grammar;
import de.bottlecaps.markup.blitz.grammar.Insertion;
import de.bottlecaps.markup.blitz.grammar.Literal;
import de.bottlecaps.markup.blitz.grammar.Node;
import de.bottlecaps.markup.blitz.grammar.Nonterminal;
import de.bottlecaps.markup.blitz.grammar.Rule;
import de.bottlecaps.markup.blitz.grammar.Term;
import de.bottlecaps.markup.blitz.transform.Visitor;
import java.util.ArrayList;

public class PostProcess
extends Visitor {
    private Grammar grammar;
    private Rule rule;
    private Node parent;

    private PostProcess() {
    }

    public static void process(Grammar grammar) {
        PostProcess pp = new PostProcess();
        pp.grammar = grammar;
        pp.parent = grammar;
        pp.visit(grammar);
    }

    @Override
    public void visit(Rule r) {
        this.rule = r;
        this.visitPreOrder(r);
        super.visit(r);
        this.visitPostOrder(r);
    }

    @Override
    public void visit(Alts a) {
        this.visitPreOrder(a);
        ArrayList<Alt> flattenedAlts = new ArrayList<Alt>();
        for (Alt alt : a.getAlts()) {
            if (alt.getTerms().size() != 1 || !(alt.getTerms().get(0) instanceof Alts)) {
                this.visit(alt);
                flattenedAlts.add(alt);
                continue;
            }
            Alts nestedAlts = (Alts)alt.getTerms().get(0);
            this.visit(nestedAlts);
            for (Alt nestedAlt : nestedAlts.getAlts()) {
                nestedAlt.setParent(a);
                flattenedAlts.add(nestedAlt);
            }
        }
        a.getAlts().clear();
        a.getAlts().addAll(flattenedAlts);
        this.visitPostOrder(a);
    }

    @Override
    public void visit(Alt a) {
        this.visitPreOrder(a);
        ArrayList<Term> flattenedTerms = new ArrayList<Term>();
        for (Term term : a.getTerms()) {
            if (!(term instanceof Alts) || ((Alts)term).getAlts().size() > 1) {
                term.accept(this);
                flattenedTerms.add(term);
                continue;
            }
            Alt alt = ((Alts)term).getAlts().get(0);
            this.visit(alt);
            for (Term t : alt.getTerms()) {
                t.setParent(a);
                flattenedTerms.add(t);
            }
        }
        a.getTerms().clear();
        Term last = null;
        for (Term term : flattenedTerms) {
            if (last != null) {
                last.setNext(term);
            }
            last = term;
            a.getTerms().add(term);
        }
        this.visitPostOrder(a);
    }

    @Override
    public void visit(Charset c) {
        this.visitPreOrder(c);
        this.visitPostOrder(c);
    }

    @Override
    public void visit(Control c) {
        this.visitPreOrder(c);
        c.getTerm().accept(this);
        if (c.getSeparator() != null) {
            c.getSeparator().accept(this);
        }
        this.visitPostOrder(c);
    }

    @Override
    public void visit(Grammar g) {
        this.visitPreOrder(g);
        for (Rule rule : g.getRules().values()) {
            rule.accept(this);
        }
        this.visitPostOrder(g);
    }

    @Override
    public void visit(Insertion i) {
        this.visitPreOrder(i);
        this.visitPostOrder(i);
    }

    @Override
    public void visit(Literal l) {
        this.visitPreOrder(l);
        this.visitPostOrder(l);
    }

    @Override
    public void visit(Nonterminal n) {
        this.visitPreOrder(n);
        this.visitPostOrder(n);
    }

    private void visitPreOrder(Node node) {
        node.setGrammar(this.grammar);
        node.setRule(this.rule);
        node.setParent(this.parent);
        this.parent = node;
    }

    private void visitPostOrder(Node node) {
        this.parent = node.getParent();
    }
}

