/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.basex.build.csv.CsvParserOptions;
import org.basex.build.html.HtmlOptions;
import org.basex.build.json.JsonParserOptions;
import org.basex.core.CommonOptions;
import org.basex.io.serial.SerializerOptions;
import org.basex.util.Enums;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.EnumOption;
import org.basex.util.options.NumberOption;
import org.basex.util.options.Option;
import org.basex.util.options.Options;
import org.basex.util.options.OptionsOption;
import org.basex.util.options.StringOption;

public final class MainOptions
extends Options {
    public static final BooleanOption MAINMEM = new BooleanOption("MAINMEM", false);
    public static final BooleanOption CREATEONLY = new BooleanOption("CREATEONLY", false);
    public static final StringOption CREATEFILTER = new StringOption("CREATEFILTER", "*.xml");
    public static final BooleanOption ADDARCHIVES = new BooleanOption("ADDARCHIVES", true);
    public static final BooleanOption ARCHIVENAME = new BooleanOption("ARCHIVENAME", false);
    public static final BooleanOption SKIPCORRUPT = new BooleanOption("SKIPCORRUPT", false);
    public static final BooleanOption ADDRAW = new BooleanOption("ADDRAW", false);
    public static final OptionsOption<CsvParserOptions> CSVPARSER = new OptionsOption<CsvParserOptions>("CSVPARSER", new CsvParserOptions());
    public static final OptionsOption<JsonParserOptions> JSONPARSER = new OptionsOption<JsonParserOptions>("JSONPARSER", new JsonParserOptions());
    public static final OptionsOption<HtmlOptions> HTMLPARSER = new OptionsOption<HtmlOptions>("HTMLPARSER", new HtmlOptions());
    public static final EnumOption<MainParser> PARSER = new EnumOption<MainParser>("PARSER", MainParser.XML);
    public static final BooleanOption INTPARSE = new BooleanOption("INTPARSE", false);
    public static final BooleanOption STRIPWS = new BooleanOption("STRIPWS", false);
    public static final BooleanOption STRIPNS = new BooleanOption("STRIPNS", false);
    public static final BooleanOption EXTERNALENT = new BooleanOption("EXTENTITIES", true);
    public static final NumberOption ENTEXPANSION = new NumberOption("ENTEXPANSION", -1);
    public static final BooleanOption DTD = new BooleanOption("DTD", false);
    public static final BooleanOption DTDVALIDATION = new BooleanOption("DTDVALIDATION", false);
    public static final StringOption XSDVALIDATION = new StringOption("XSDVALIDATION", "skip");
    public static final BooleanOption XSILOCATION = new BooleanOption("XSILOCATION", true);
    public static final BooleanOption XINCLUDE = new BooleanOption("XINCLUDE", false);
    public static final StringOption CATALOG = new StringOption("CATALOG", "");
    public static final BooleanOption ADDCACHE = new BooleanOption("ADDCACHE", false);
    public static final BooleanOption TEXTINDEX = new BooleanOption("TEXTINDEX", true);
    public static final BooleanOption ATTRINDEX = new BooleanOption("ATTRINDEX", true);
    public static final BooleanOption TOKENINDEX = new BooleanOption("TOKENINDEX", false);
    public static final BooleanOption FTINDEX = new BooleanOption("FTINDEX", false);
    public static final StringOption TEXTINCLUDE = new StringOption("TEXTINCLUDE", "");
    public static final StringOption ATTRINCLUDE = new StringOption("ATTRINCLUDE", "");
    public static final StringOption TOKENINCLUDE = new StringOption("TOKENINCLUDE", "");
    public static final StringOption FTINCLUDE = new StringOption("FTINCLUDE", "");
    public static final NumberOption MAXLEN = new NumberOption("MAXLEN", 96);
    public static final NumberOption MAXCATS = new NumberOption("MAXCATS", 100);
    public static final BooleanOption UPDINDEX = new BooleanOption("UPDINDEX", false);
    public static final BooleanOption AUTOOPTIMIZE = new BooleanOption("AUTOOPTIMIZE", false);
    public static final NumberOption SPLITSIZE = new NumberOption("SPLITSIZE", 0);
    public static final BooleanOption STEMMING = new BooleanOption("STEMMING", false);
    public static final BooleanOption CASESENS = new BooleanOption("CASESENS", false);
    public static final BooleanOption DIACRITICS = new BooleanOption("DIACRITICS", false);
    public static final StringOption LANGUAGE = new StringOption("LANGUAGE", "en");
    public static final StringOption STOPWORDS = new StringOption("STOPWORDS", "");
    public static final BooleanOption QUERYINFO = new BooleanOption("QUERYINFO", false);
    public static final BooleanOption MIXUPDATES = new BooleanOption("MIXUPDATES", false);
    public static final StringOption BINDINGS = new StringOption("BINDINGS", "");
    public static final NumberOption INLINELIMIT = new NumberOption("INLINELIMIT", 50);
    public static final NumberOption UNROLLLIMIT = new NumberOption("UNROLLLIMIT", 5);
    public static final NumberOption TAILCALLS = new NumberOption("TAILCALLS", 256);
    public static final BooleanOption WITHDB = new BooleanOption("WITHDB", true);
    public static final BooleanOption DEFAULTDB = new BooleanOption("DEFAULTDB", false);
    public static final BooleanOption FORCECREATE = new BooleanOption("FORCECREATE", false);
    public static final BooleanOption CHECKSTRINGS = new BooleanOption("CHECKSTRINGS", true);
    public static final NumberOption LSERROR = new NumberOption("LSERROR", 0);
    public static final BooleanOption RUNQUERY = new BooleanOption("RUNQUERY", true);
    public static final NumberOption RUNS = new NumberOption("RUNS", 1);
    public static final BooleanOption ENFORCEINDEX = new BooleanOption("ENFORCEINDEX", false);
    public static final BooleanOption COPYNODE = new BooleanOption("COPYNODE", true);
    public static final EnumOption<WrapOptions> WRAPJAVA = new EnumOption<WrapOptions>("WRAPJAVA", WrapOptions.SOME);
    public static final BooleanOption SERIALIZE = new BooleanOption("SERIALIZE", true);
    public static final OptionsOption<SerializerOptions> SERIALIZER = new OptionsOption<SerializerOptions>("SERIALIZER", new SerializerOptions());
    public static final OptionsOption<SerializerOptions> EXPORTER = new OptionsOption<SerializerOptions>("EXPORTER", new SerializerOptions());
    public static final BooleanOption XMLPLAN = new BooleanOption("XMLPLAN", false);
    public static final BooleanOption FULLPLAN = new BooleanOption("FULLPLAN", false);
    public static final BooleanOption OPTPLAN = new BooleanOption("OPTPLAN", true);
    public static final BooleanOption AUTOFLUSH = new BooleanOption("AUTOFLUSH", true);
    public static final BooleanOption WRITEBACK = new BooleanOption("WRITEBACK", false);
    public static final NumberOption MAXSTAT = new NumberOption("MAXSTAT", 30);
    public static final Option<?>[] INDEXING = new Option[]{MAXCATS, MAXLEN, SPLITSIZE, LANGUAGE, STOPWORDS, TEXTINDEX, ATTRINDEX, TOKENINDEX, FTINDEX, TEXTINCLUDE, ATTRINCLUDE, TOKENINCLUDE, FTINCLUDE, STEMMING, CASESENS, DIACRITICS, UPDINDEX, AUTOOPTIMIZE};
    private static final Map<Option<?>, Option<?>> XMLPARSINGMAP = new HashMap();
    private static final Option<?>[] XMLPARSING;
    public static final Option<?>[] EXTPARSING;
    public static final Option<?>[] PARSING;
    public static final Option<?>[] CREATING;

    public MainOptions() {
        this(true);
    }

    public MainOptions(boolean system) {
        if (system) {
            this.setSystem();
        }
    }

    public MainOptions(MainOptions options) {
        super(options);
    }

    public MainOptions(MainOptions options, boolean xml) {
        this(false);
        for (Option<?> option : xml ? XMLPARSING : PARSING) {
            this.put(option, options.get(option));
        }
    }

    public MainOptions(Options options) {
        this(false);
        XMLPARSINGMAP.forEach((? super K source, ? super V target) -> {
            Object value = options.get((Option<?>)source);
            if (value != null) {
                this.put((Option<?>)target, value);
            }
        });
    }

    static {
        XMLPARSINGMAP.put(CommonOptions.INTPARSE, INTPARSE);
        XMLPARSINGMAP.put(CommonOptions.STRIP_SPACE, STRIPWS);
        XMLPARSINGMAP.put(CommonOptions.STRIPNS, STRIPNS);
        XMLPARSINGMAP.put(CommonOptions.ALLOW_EXTERNAL_ENTITIES, EXTERNALENT);
        XMLPARSINGMAP.put(CommonOptions.ENTITY_EXPANSION_LIMIT, ENTEXPANSION);
        XMLPARSINGMAP.put(CommonOptions.DTD, DTD);
        XMLPARSINGMAP.put(CommonOptions.DTD_VALIDATION, DTDVALIDATION);
        XMLPARSINGMAP.put(CommonOptions.XSD_VALIDATION, XSDVALIDATION);
        XMLPARSINGMAP.put(CommonOptions.XSI_SCHEMA_LOCATION, XSILOCATION);
        XMLPARSINGMAP.put(CommonOptions.XINCLUDE, XINCLUDE);
        XMLPARSINGMAP.put(CommonOptions.CATALOG, CATALOG);
        XMLPARSING = (Option[])XMLPARSINGMAP.values().toArray(Option[]::new);
        EXTPARSING = new Option[]{CREATEFILTER, ADDARCHIVES, ARCHIVENAME, SKIPCORRUPT, ADDRAW, ADDCACHE, CSVPARSER, JSONPARSER, HTMLPARSER, PARSER};
        PARSING = (Option[])Stream.concat(Stream.of(XMLPARSING), Stream.of(EXTPARSING)).toArray(Option[]::new);
        CREATING = (Option[])Stream.concat(Stream.of(INDEXING), Stream.of(PARSING)).toArray(Option[]::new);
    }

    public static enum MainParser {
        XML,
        HTML,
        JSON,
        CSV,
        RAW;


        public String toString() {
            return Enums.string(this);
        }
    }

    public static enum WrapOptions {
        INSTANCE,
        ALL,
        VOID,
        SOME,
        NONE;


        public String toString() {
            return Enums.string(this);
        }
    }
}

