/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.text;

import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.swing.JComponent;
import org.basex.gui.GUIConstants;
import org.basex.util.hash.IntObjectMap;
import org.basex.util.list.StringList;

final class TextFont {
    private static final StringList VARS = new StringList();
    private static final StringList MONO = new StringList();
    private static final IntObjectMap<String> FALLBACK = new IntObjectMap();
    private static List<Font> cachedFonts;
    private final Map<String, FontFamily> fallbacks = new LinkedHashMap<String, FontFamily>();
    private final JComponent comp;
    private final FontFamily family;
    private final int indent;
    private final int size;
    private int style;

    TextFont(Font font, int indent, JComponent comp) {
        this.comp = comp;
        this.indent = indent;
        this.family = new FontFamily(font, comp);
        this.size = font.getSize();
    }

    void style(int s) {
        this.style = s;
    }

    int size() {
        return this.size;
    }

    int stringWidth(String string) {
        return string.length() == 1 ? this.charWidth(string.codePointAt(0)) : this.family(string).metrics(this.style).stringWidth(string);
    }

    Font font(String string) {
        return this.family(string).font(this.style);
    }

    private FontFamily family(String string) {
        int i = this.family.font(this.style).canDisplayUpTo(string);
        return i == -1 ? this.family : this.fallback(string.codePointAt(i));
    }

    int charWidth(int cp) {
        if (cp >= 57344 && cp <= 63743) {
            return 0;
        }
        FontFamily ff = this.family.font(this.style).canDisplay(cp) ? this.family : this.fallback(cp);
        FontMetrics fm = ff.metrics(this.style);
        return cp == 9 ? fm.charWidth(' ') * this.indent : fm.charWidth(cp);
    }

    private FontFamily fallback(int cp) {
        String fb;
        if (this.fallbacks.isEmpty()) {
            StringList fonts = GUIConstants.isMono(this.family.metrics(0)) ? MONO : VARS;
            for (String string : fonts) {
                this.fallback(string);
            }
        }
        if ((fb = FALLBACK.get(cp)) != null) {
            FontFamily ff = this.fallbacks.get(fb);
            return ff != null ? ff : this.fallback(fb);
        }
        for (Map.Entry entry : this.fallbacks.entrySet()) {
            String[] ff = (String[])entry.getValue();
            if (!ff.font(0).canDisplay(cp)) continue;
            FALLBACK.put(cp, (String)entry.getKey());
            return ff;
        }
        if (cachedFonts == null) {
            String[] names = GUIConstants.fonts();
            HashMap<Font, Integer> hashMap = new HashMap<Font, Integer>(names.length);
            for (String name : names) {
                Font f = this.newFont(name);
                hashMap.put(f, f.getNumGlyphs());
            }
            cachedFonts = hashMap.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).map(Map.Entry::getKey).toList();
        }
        for (Font font : cachedFonts) {
            if (!font.canDisplay(cp)) continue;
            String nm = font.getName();
            FALLBACK.put(cp, nm);
            return this.fallback(nm);
        }
        FALLBACK.put(cp, this.family.font(0).getName());
        return this.family;
    }

    private FontFamily fallback(String name) {
        FontFamily ff = new FontFamily(this.newFont(name), this.comp);
        this.fallbacks.put(ff.font(0).getName(), ff);
        return ff;
    }

    private Font newFont(String nm) {
        return new Font(nm, 0, this.size);
    }

    static {
        HashSet<String> set = new HashSet<String>(Arrays.asList(GUIConstants.fonts()));
        BiConsumer<StringList, String[]> add = (list, fonts) -> {
            for (String font : fonts) {
                if (!set.contains(font)) continue;
                list.add(font);
            }
        };
        add.accept(VARS, new String[]{"Noto Sans", "DejaVu Sans", "Arial Unicode MS", "SansSerif"});
        add.accept(MONO, new String[]{"Noto Mono", "DejaVu Sans Mono", "Monospaced"});
        MONO.add(VARS);
    }

    private static final class FontFamily {
        private final Font[] fonts;
        private final FontMetrics[] metrics;

        private FontFamily(Font font, JComponent comp) {
            Font bold = font.deriveFont(1);
            this.fonts = new Font[]{font, bold};
            this.metrics = new FontMetrics[]{comp.getFontMetrics(font), comp.getFontMetrics(bold)};
        }

        private Font font(int style) {
            return this.fonts[style];
        }

        private FontMetrics metrics(int style) {
            return this.metrics[style];
        }
    }
}

