/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.folder;

import org.basex.data.Data;
import org.basex.gui.view.folder.FolderView;
import org.basex.query.value.seq.DBNodes;
import org.basex.util.list.IntList;

final class FolderIterator {
    private final FolderView view;
    int y;
    int level;
    int pre;
    private final IntList parents = new IntList();
    private final int height;
    private boolean found;
    private int cp = -1;
    private int par;
    private int mode;
    private int ll;

    FolderIterator(FolderView v) {
        this(v, 0, Integer.MAX_VALUE);
    }

    FolderIterator(FolderView v, int yy, int h) {
        this.height = h;
        this.view = v;
        this.view.focusedPos = -1;
        this.y = yy;
    }

    int height() {
        while (this.more()) {
        }
        return this.y;
    }

    boolean more() {
        if (this.view.opened == null) {
            return false;
        }
        if (!this.found) {
            ++this.view.focusedPos;
            boolean bl = this.found = this.pre == this.view.gui.context.focused;
        }
        if (this.mode == 0) {
            return this.moreCS();
        }
        this.y += this.view.lineH;
        if (this.y > this.height) {
            return false;
        }
        Data data = this.view.gui.context.data();
        if (data == null || this.pre >= data.meta.size) {
            return false;
        }
        int kind = data.kind(this.pre);
        return this.mode == 2 || (kind == 1 || kind == 0) && this.view.opened[this.pre] ? this.moreData(data) : this.moreCS();
    }

    private boolean moreCS() {
        DBNodes current = this.view.gui.context.current();
        if (current == null || (long)(++this.cp) >= current.size()) {
            return false;
        }
        this.pre = this.par = current.pre(this.cp);
        this.level = 0;
        this.ll = 0;
        this.mode = 1;
        return true;
    }

    private boolean moreData(Data data) {
        this.level = this.ll;
        int kind = data.kind(this.pre);
        boolean[] open = this.view.opened;
        if (open == null) {
            return false;
        }
        this.pre += open[this.pre] ? 1 : data.size(this.pre, kind);
        while (this.pre < data.meta.size) {
            kind = data.kind(this.pre);
            int p = data.parent(this.pre, kind);
            while (p < this.par && this.level > 0) {
                this.par = this.parents.get(--this.level);
            }
            if (p < this.par) break;
            if (p == this.par) {
                kind = data.kind(this.par);
                if ((kind == 1 || kind == 0) && open[this.pre]) {
                    this.parents.set(this.level++, this.par);
                    this.par = this.pre;
                    this.ll = this.level;
                } else {
                    this.ll = this.level++;
                }
                this.mode = 2;
                return true;
            }
            ++this.pre;
        }
        return this.moreCS();
    }
}

