/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.ArrayList;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Catch;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.expr.path.Test;
import org.basex.query.func.Function;
import org.basex.query.func.fn.FnError;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.Checks;
import org.basex.util.InputInfo;
import org.basex.util.Util;
import org.basex.util.hash.IntObjectMap;

public final class Try
extends Single {
    private Catch[] catches;
    private Expr fnlly;

    public Try(InputInfo info, Expr expr, Expr fnlly, Catch ... catches) {
        super(info, expr, SeqType.ITEM_ZM);
        this.catches = catches;
        this.fnlly = fnlly;
    }

    @Override
    public void checkUp() throws QueryException {
        ExprList exprs = (ExprList)((Object)new ExprList(this.catches.length + 2).add(this.expr));
        for (Catch ctch : this.catches) {
            exprs.add(ctch.expr);
        }
        this.checkAllUp((Expr[])((ExprList)((Object)exprs.add(this.fnlly))).finish());
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        for (Catch ctch : this.catches) {
            ctch.compile(cc);
        }
        try {
            super.compile(cc);
        }
        catch (QueryException ex) {
            this.expr = FnError.get(ex, this.expr);
        }
        this.fnlly = this.fnlly.compile(cc);
        return this.optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        Expr e;
        block12: {
            ArrayList<Catch> newCatches = new ArrayList<Catch>();
            ArrayList<Test> tests = new ArrayList<Test>();
            if (!((Checks<Catch>)Catch::global).all((Catch[])this.catches)) {
                for (Catch ctch : this.catches) {
                    if (!ctch.simplify(tests, cc)) continue;
                    newCatches.add(ctch);
                }
                this.catches = (Catch[])newCatches.toArray(Catch[]::new);
            }
            e = null;
            if (this.expr instanceof Value) {
                e = this.expr;
            } else if (Function.ERROR.is(this.expr) && ((FnError)this.expr).values(true, cc)) {
                try {
                    this.expr.value(cc.qc);
                }
                catch (QueryException ex) {
                    Util.debug(ex);
                    if (!ex.isCatchable()) {
                        throw ex;
                    }
                    Catch ctch = this.matches(ex);
                    if (ctch != null) {
                        e = ctch.inline(ex, cc);
                    }
                    if (this.fnlly != Empty.VALUE) break block12;
                    throw ex;
                }
            }
        }
        if (e != null) {
            if (this.fnlly == Empty.VALUE) {
                return cc.replaceWith(this, e);
            }
            this.expr = e;
            this.catches = new Catch[0];
        }
        SeqType st = this.expr.seqType();
        for (Catch ctch : this.catches) {
            st = st.union(ctch.seqType());
        }
        this.exprType.assign(st).data(ExprList.concat(this.catches, this.expr));
        return this;
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        Value value;
        try {
            value = this.expr.value(qc);
        }
        catch (QueryException ex) {
            block8: {
                Value value2;
                try {
                    Util.debug(ex);
                    Catch ctch = this.matches(ex);
                    if (ctch == null) break block8;
                    value2 = ctch.value(qc, ex);
                }
                catch (Throwable throwable) {
                    Value fnl = this.fnlly.value(qc);
                    if (!fnl.isEmpty()) {
                        throw QueryError.FINALLY_X.get(this.info, fnl);
                    }
                    throw throwable;
                }
                Value fnl = this.fnlly.value(qc);
                if (!fnl.isEmpty()) {
                    throw QueryError.FINALLY_X.get(this.info, fnl);
                }
                return value2;
            }
            throw ex;
        }
        Value fnl = this.fnlly.value(qc);
        if (!fnl.isEmpty()) {
            throw QueryError.FINALLY_X.get(this.info, fnl);
        }
        return value;
    }

    private Catch matches(QueryException ex) {
        for (Catch ctch : this.catches) {
            if (!ctch.matches(ex)) continue;
            return ctch;
        }
        return null;
    }

    @Override
    public VarUsage count(Var var) {
        return VarUsage.maximum(var, this.catches).plus(this.expr.count(var)).plus(this.fnlly.count(var));
    }

    @Override
    public Expr inline(InlineContext ic) throws QueryException {
        Expr inlined;
        Expr fnlInlined = this.fnlly.inline(ic);
        if (fnlInlined != null) {
            this.fnlly = fnlInlined;
        }
        boolean changed = false;
        for (Catch ctch : this.catches) {
            changed |= ctch.inline(ic) != null;
        }
        try {
            inlined = this.expr.inline(ic);
        }
        catch (QueryException ex) {
            inlined = FnError.get(ex, this.expr);
        }
        if (inlined != null) {
            this.expr = inlined;
        }
        return changed || inlined != null || fnlInlined != null ? this.optimize(ic.cc) : null;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new Try(this.info, this.expr.copy(cc, vm), this.fnlly.copy(cc, vm), (Catch[])Arr.copyAll((CompileContext)cc, vm, (Expr[])this.catches)));
    }

    @Override
    public boolean vacuous() {
        return this.expr.vacuous() && ((Checks<Catch>)ctch -> ctch.expr.vacuous()).all((Catch[])this.catches) && this.fnlly.vacuous();
    }

    @Override
    public boolean ddo() {
        return this.expr.ddo() && ((Checks<Catch>)ctch -> ctch.expr.ddo()).all((Catch[])this.catches);
    }

    @Override
    public boolean has(Flag ... flags) {
        return ((Checks<Catch>)ctch -> ctch.has(flags)).any((Catch[])this.catches) || super.has(flags) || this.fnlly.has(flags);
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        for (Catch ctch : this.catches) {
            if (ctch.inlineable(ic)) continue;
            return false;
        }
        return super.inlineable(ic) && this.fnlly.inlineable(ic);
    }

    @Override
    public void markTailCalls(CompileContext cc) {
        if (this.fnlly == Empty.VALUE) {
            this.expr.markTailCalls(cc);
            for (Catch ctch : this.catches) {
                ctch.markTailCalls(cc);
            }
        }
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return super.accept(visitor) && Try.visitAll(visitor, this.catches) && this.fnlly.accept(visitor);
    }

    @Override
    public int exprSize() {
        int size = 0;
        for (Catch ctch : this.catches) {
            size += ctch.exprSize();
        }
        return size + this.fnlly.exprSize() + super.exprSize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Try)) return false;
        Try t = (Try)obj;
        if (!Array.equals(this.catches, t.catches)) return false;
        if (!this.fnlly.equals(t.fnlly)) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, new Object[0]), new Object[]{this.expr, this.catches, this.fnlly});
    }

    @Override
    public void toString(QueryString qs) {
        qs.token("try").brace(this.expr).tokens(this.catches).token("finally").brace(this.fnlly);
    }
}

