/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.constr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.constr.CName;
import org.basex.query.expr.path.Test;
import org.basex.query.value.Value;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.FAttr;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.IntObjectMap;

public final class CAttr
extends CName {
    private static final byte[] NS0 = Token.token("ns0:");

    public CAttr(InputInfo info, boolean computed, Expr name, Expr ... value) {
        super(info, SeqType.ATTRIBUTE_O, computed, name, value);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.name = this.name.simplifyFor(CompileContext.Simplify.STRING, cc);
        if (this.name instanceof Value) {
            QNm nm = this.qname(false, cc.qc);
            this.name = nm;
            this.exprType.assign(SeqType.get(NodeType.ATTRIBUTE, Occ.EXACTLY_ONE, Test.get(NodeType.ATTRIBUTE, nm, null)));
        }
        this.optValue(cc);
        return this;
    }

    @Override
    public FAttr item(QueryContext qc, InputInfo ii) throws QueryException {
        QNm nm = this.qname(false, qc);
        byte[] nmPrefix = nm.prefix();
        byte[] nmUri = nm.uri();
        if (this.computed) {
            if (Token.eq(nmPrefix, Token.XML) ^ Token.eq(nmUri, QueryText.XML_URI)) {
                throw QueryError.CAXML.get(this.info, new Object[0]);
            }
            if (Token.eq(nmUri, QueryText.XMLNS_URI)) {
                throw QueryError.CAINV_.get(this.info, new Object[]{nmUri});
            }
            if (Token.eq(nmPrefix, Token.XMLNS) || nmPrefix.length == 0 && Token.eq(nm.string(), Token.XMLNS)) {
                throw QueryError.CAINV_.get(this.info, new Object[]{nm.string()});
            }
            if (Token.eq(nmPrefix, Token.EMPTY) && !Token.eq(nmUri, Token.EMPTY)) {
                nm = qc.shared.qName(Token.concat(NS0, nm.string()), nmUri);
            }
        }
        if (!nm.hasURI() && nm.hasPrefix()) {
            throw QueryError.NOQNNAMENS_X.get(this.info, new Object[]{nmPrefix});
        }
        byte[] value = this.atomValue(qc, true);
        if (Token.eq(nmPrefix, Token.XML) && Token.eq(nm.local(), Token.ID)) {
            value = Token.normalize(value);
        }
        return new FAttr(nm, qc.shared.token(value));
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new CAttr(this.info, this.computed, this.name.copy(cc, vm), CAttr.copyAll((CompileContext)cc, vm, (Expr[])this.exprs)));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof CAttr && super.equals(obj);
    }

    @Override
    public void toString(QueryString qs) {
        if (this.computed) {
            this.toString(qs, "attribute");
        } else {
            Expr expr;
            qs.token(((QNm)this.name).string()).token('=');
            if (this.exprs.length == 1 && (expr = this.exprs[0]) instanceof Str) {
                Str str = (Str)expr;
                qs.quoted(str.string());
            } else {
                qs.token("\"{").tokens(this.exprs, ", ").token("}\"");
            }
        }
    }
}

