/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.ft;

import java.util.Objects;
import org.basex.core.MainOptions;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.index.IndexType;
import org.basex.index.query.FTIndexIterator;
import org.basex.index.query.IndexIterator;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ft.FTExpr;
import org.basex.query.expr.ft.FTNot;
import org.basex.query.expr.ft.FTTokenizer;
import org.basex.query.expr.ft.FTTokens;
import org.basex.query.expr.index.IndexDb;
import org.basex.query.iter.FTIter;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.ft.FTMatches;
import org.basex.query.util.index.IndexCosts;
import org.basex.query.util.index.IndexInfo;
import org.basex.query.value.Value;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FTNode;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.ft.FTBitapSearch;
import org.basex.util.ft.FTCase;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTMode;
import org.basex.util.ft.FTOpt;
import org.basex.util.ft.Scoring;
import org.basex.util.ft.StopWords;
import org.basex.util.hash.IntObjectMap;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.TokenList;

public final class FTWords
extends FTExpr {
    final FTMode mode;
    Expr query;
    Expr[] occ;
    boolean simple;
    private IndexDb db;
    private TokenList inputs;
    private FTOpt ftOpt;

    public FTWords(InputInfo info, Expr query, FTMode mode, Expr[] occ) {
        super(info, new FTExpr[0]);
        this.query = query;
        this.mode = mode;
        this.occ = occ;
    }

    public FTWords(InputInfo info, IndexDb db, Value query, FTMode mode) {
        super(info, new FTExpr[0]);
        this.db = db;
        this.query = query;
        this.mode = mode;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoneUp(this.occ);
        this.checkNoUp(this.query);
    }

    @Override
    public FTWords compile(CompileContext cc) throws QueryException {
        if (this.occ != null) {
            int ol = this.occ.length;
            for (int o = 0; o < ol; ++o) {
                this.occ[o] = this.occ[o].compile(cc);
            }
        }
        this.query = this.query.compile(cc);
        if (this.db != null) {
            this.db.compile(cc);
        }
        if (this.ftOpt == null) {
            this.ftOpt = cc.qc.ftOpt().copy();
        }
        return this.optimize(cc);
    }

    @Override
    public FTWords optimize(CompileContext cc) throws QueryException {
        this.optimize(cc.qc);
        if (this.occ != null) {
            int ol = this.occ.length;
            for (int o = 0; o < ol; ++o) {
                this.occ[o] = this.occ[o].simplifyFor(CompileContext.Simplify.NUMBER, cc);
            }
        }
        return this;
    }

    public FTWords optimize(QueryContext qc) throws QueryException {
        if (this.query instanceof Value && this.inputs == null) {
            this.inputs = this.inputs(qc);
            this.simple = this.mode == FTMode.ANY && this.occ == null;
        }
        return this;
    }

    public FTWords ftOpt(FTOpt opt) {
        this.ftOpt = opt;
        return this;
    }

    @Override
    public FTNode item(QueryContext qc, InputInfo ii) throws QueryException {
        FTTokenizer ftt = this.get(qc);
        if (ftt.pos == 0) {
            ftt.pos = ++qc.ftPos;
        }
        ftt.matches.reset(ftt.pos);
        int count = this.contains(qc, ftt);
        if (count == 0) {
            ftt.matches.size(0);
        }
        return new FTNode(ftt.matches, count == 0 ? 0.0 : Scoring.word(count, qc.ftLexer.count()));
    }

    @Override
    public FTIter iter(final QueryContext qc) throws QueryException {
        final Data data = this.db.data(qc, IndexType.FULLTEXT);
        return new FTIter(){
            FTIndexIterator ftiter;
            int length;

            @Override
            public FTNode next() throws QueryException {
                if (this.ftiter == null) {
                    FTTokenizer ftt = FTWords.this.get(qc);
                    FTLexer lexer = new FTLexer(FTWords.this.ftOpt).errors(qc.context.options.get(MainOptions.LSERROR));
                    int len = 0;
                    for (byte[] input : FTWords.this.unique(FTWords.this.inputs != null ? FTWords.this.inputs : FTWords.this.inputs(qc))) {
                        lexer.init(input);
                        if (!lexer.hasNext()) {
                            return null;
                        }
                        int d = 0;
                        IndexIterator iter = null;
                        StopWords sw = FTWords.this.ftOpt.sw;
                        do {
                            byte[] token = lexer.nextToken();
                            len += token.length;
                            if (sw != null && sw.contains(token)) {
                                ++d;
                                continue;
                            }
                            FTIndexIterator ir = lexer.token().length > data.meta.maxlen ? FTWords.this.scan(lexer, ftt, data) : (FTIndexIterator)data.iter(lexer);
                            ir.pos(++qc.ftPos);
                            if (iter == null) {
                                iter = ir;
                                continue;
                            }
                            iter = FTIndexIterator.intersect((FTIndexIterator)iter, ir, ++d);
                            d = 0;
                        } while (lexer.hasNext());
                        if (iter == null) continue;
                        if (this.ftiter == null) {
                            this.length = len;
                            this.ftiter = iter;
                            continue;
                        }
                        if (FTWords.this.mode == FTMode.ALL || FTWords.this.mode == FTMode.ALL_WORDS) {
                            if (iter.size() == 0) {
                                return null;
                            }
                            this.length += len;
                            this.ftiter = FTIndexIterator.intersect(this.ftiter, (FTIndexIterator)iter, 0);
                            continue;
                        }
                        if (iter.size() == 0) continue;
                        this.length = Math.max(len, this.length);
                        this.ftiter = FTIndexIterator.union(new FTIndexIterator[]{this.ftiter, iter});
                    }
                }
                return this.ftiter == null || !this.ftiter.more() ? null : new FTNode(this.ftiter.matches(), data, this.ftiter.pre(), this.length, this.ftiter.size());
            }
        };
    }

    private FTIndexIterator scan(FTLexer lexer, final FTTokenizer ftt, final Data data) throws QueryException {
        final FTLexer input = new FTLexer(this.ftOpt);
        final FTTokens fttokens = ftt.cache(lexer.token());
        return new FTIndexIterator(){
            final int sz;
            int pre;
            int ps;
            {
                this.sz = data.meta.size;
                this.pre = -1;
            }

            @Override
            public int pre() {
                return this.pre;
            }

            @Override
            public boolean more() {
                while (++this.pre < this.sz) {
                    if (data.kind(this.pre) != 2) continue;
                    input.init(data.text(this.pre, true));
                    ftt.matches.reset(this.ps);
                    try {
                        if (FTWords.this.contains(fttokens, input, ftt) == 0) continue;
                        return true;
                    }
                    catch (QueryException ex) {
                        Util.debug(ex);
                    }
                }
                return false;
            }

            @Override
            public FTMatches matches() {
                return ftt.matches;
            }

            @Override
            public void pos(int p) {
                this.ps = p;
            }

            @Override
            public int size() {
                return Math.max(1, this.sz >>> 1);
            }
        };
    }

    private TokenList inputs(QueryContext qc) throws QueryException {
        Item item;
        TokenList tl = new TokenList();
        Iter iter = this.query.atomIter(qc, this.info);
        while ((item = qc.next(iter)) != null) {
            byte[] token = this.toToken(item);
            if (token.length == 0 && this.mode != FTMode.ALL && this.mode != FTMode.ALL_WORDS) continue;
            tl.add(token);
        }
        return tl;
    }

    private int contains(QueryContext qc, FTTokenizer ftt) throws QueryException {
        long mx;
        ftt.first = true;
        FTLexer lexer = qc.ftLexer.copy(this.ftOpt);
        int num = 0;
        if (this.simple) {
            for (byte[] input : this.inputs) {
                FTTokens tokens = ftt.cache(input);
                num = Math.max(num, this.contains(tokens, lexer, ftt) * tokens.firstSize());
            }
            return num;
        }
        boolean all = this.mode == FTMode.ALL || this.mode == FTMode.ALL_WORDS;
        int oc = 0;
        for (byte[] input : this.unique(this.inputs(qc))) {
            FTTokens tokens = ftt.cache(input);
            int o = this.contains(tokens, lexer, ftt);
            if (all && o == 0) {
                return 0;
            }
            num = Math.max(num, o * tokens.firstSize());
            oc += o;
        }
        long mn = this.occ != null ? this.toLong(this.occ[0], qc) : 1L;
        long l = mx = this.occ != null ? this.toLong(this.occ[1], qc) : Long.MAX_VALUE;
        if (mn == 0L && oc == 0) {
            ftt.matches = FTNot.not(ftt.matches);
        }
        return (long)oc >= mn && (long)oc <= mx ? Math.max(1, num) : 0;
    }

    private int contains(FTTokens tokens, FTLexer input, FTTokenizer ftt) throws QueryException {
        int count = 0;
        FTMatches matches = ftt.matches;
        boolean and = !ftt.first && (this.mode == FTMode.ALL || this.mode == FTMode.ALL_WORDS);
        FTBitapSearch bs = new FTBitapSearch(input.init(), tokens, ftt.cmp);
        while (bs.hasNext()) {
            int s = bs.next();
            int e = s + tokens.firstSize() - 1;
            if (and) {
                matches.and(s, e);
            } else {
                matches.or(s, e);
            }
            ++count;
        }
        ++matches.pos;
        ftt.first = false;
        return count;
    }

    private TokenSet unique(TokenList tokens) {
        TokenSet ts = new TokenSet();
        switch (this.mode) {
            case ALL: 
            case ANY: {
                for (byte[] token : tokens) {
                    ts.add(token);
                }
                break;
            }
            case ALL_WORDS: 
            case ANY_WORD: {
                FTLexer lexer = new FTLexer(this.ftOpt);
                for (byte[] token : tokens) {
                    lexer.init(token);
                    while (lexer.hasNext()) {
                        ts.add(lexer.nextToken());
                    }
                }
                break;
            }
            case PHRASE: {
                TokenBuilder tb = new TokenBuilder();
                for (byte[] token : tokens) {
                    tb.add(token).add(32);
                }
                ts.add(tb.trim().finish());
            }
        }
        return ts;
    }

    private FTTokenizer get(QueryContext qc) {
        ThreadLocal<FTTokenizer> tl = qc.threads.get(this);
        FTTokenizer ftt = tl.get();
        if (ftt == null) {
            ftt = new FTTokenizer(this.ftOpt, qc.context.options.get(MainOptions.LSERROR), this.info);
            tl.set(ftt);
        }
        return ftt;
    }

    @Override
    public boolean indexAccessible(IndexInfo ii) {
        Data data = ii.db.data();
        if (data == null && !ii.enforce() || this.occ != null) {
            return false;
        }
        if (data != null) {
            MetaData md = data.meta;
            if (this.ftOpt.cs != null && md.casesens == (this.ftOpt.cs == FTCase.INSENSITIVE) || this.ftOpt.isSet(FTFlag.DC) && md.diacritics != this.ftOpt.is(FTFlag.DC) || this.ftOpt.isSet(FTFlag.ST) && md.stemming != this.ftOpt.is(FTFlag.ST) || this.ftOpt.ln != null && !this.ftOpt.ln.equals(md.language)) {
                return false;
            }
            this.ftOpt.assign(md);
        }
        if (this.inputs == null) {
            ii.costs = ii.enforce() ? IndexCosts.ENFORCE_DYNAMIC : IndexCosts.get(Math.max(2, data.meta.size / 30));
        } else {
            ii.costs = IndexCosts.ZERO;
            FTLexer lexer = new FTLexer(this.ftOpt);
            TokenSet ts = new TokenSet();
            StopWords sw = this.ftOpt.sw;
            for (byte[] input : this.inputs) {
                lexer.init(input);
                while (lexer.hasNext()) {
                    byte[] token = lexer.nextToken();
                    if (!ts.add(token) || sw != null && sw.contains(token)) continue;
                    if (this.ftOpt.is(FTFlag.WC) && token[0] == 46) {
                        return false;
                    }
                    IndexCosts ic = IndexInfo.costs(data, lexer);
                    if (ic == null) {
                        return false;
                    }
                    int r = ic.results();
                    if (r == 0) continue;
                    ii.costs = IndexCosts.add(ii.costs, IndexCosts.get(Math.max(2, r / 100)));
                }
            }
        }
        this.db = ii.db;
        return true;
    }

    @Override
    public boolean usesExclude() {
        return this.occ != null;
    }

    @Override
    public boolean has(Flag ... flags) {
        if (this.occ != null) {
            for (Expr o : this.occ) {
                if (!o.has(flags)) continue;
                return true;
            }
        }
        return (this.db == null || this.db.has(flags)) && this.query.has(flags);
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        if (this.occ != null) {
            for (Expr o : this.occ) {
                if (o.inlineable(ic)) continue;
                return false;
            }
        }
        return (this.db == null || this.db.inlineable(ic)) && this.query.inlineable(ic);
    }

    @Override
    public VarUsage count(Var var) {
        VarUsage vu = this.query.count(var);
        if (this.occ != null) {
            vu = vu.plus(VarUsage.sum(var, this.occ));
        }
        if (this.db != null) {
            vu = vu.plus(this.db.count(var));
        }
        return vu;
    }

    @Override
    public FTExpr inline(InlineContext ic) throws QueryException {
        IndexDb id;
        boolean changed = this.occ != null && ic.inline(this.occ);
        Expr inlined = this.query.inline(ic);
        if (inlined != null) {
            this.query = inlined;
            changed = true;
        }
        if (this.db != null && (id = this.db.inline(ic)) != null) {
            this.db = id;
            changed = true;
        }
        return changed ? this.optimize(ic.cc) : null;
    }

    @Override
    public FTExpr copy(CompileContext cc, IntObjectMap<Var> vm) {
        FTWords ftw = new FTWords(this.info, this.query.copy(cc, vm), this.mode, this.occ == null ? null : Arr.copyAll((CompileContext)cc, vm, (Expr[])this.occ));
        ftw.simple = this.simple;
        ftw.inputs = this.inputs;
        ftw.ftOpt = this.ftOpt;
        if (this.db != null) {
            ftw.db = this.db.copy(cc, (IntObjectMap)vm);
        }
        return this.copyType(ftw);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return !(!super.accept(visitor) || !this.query.accept(visitor) || this.occ != null && !FTWords.visitAll(visitor, this.occ) || this.db != null && !this.db.accept(visitor));
    }

    @Override
    public int exprSize() {
        int size = 1;
        for (FTExpr expr : this.exprs) {
            size += ((Expr)expr).exprSize();
        }
        if (this.occ != null) {
            for (Expr o : this.occ) {
                size += o.exprSize();
            }
        }
        if (this.db != null) {
            size += this.db.exprSize();
        }
        return size + this.query.exprSize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof FTWords)) return false;
        FTWords f = (FTWords)obj;
        if (!this.query.equals(f.query)) return false;
        if (this.mode != f.mode) return false;
        if (!Objects.equals(this.db, f.db)) return false;
        if (!Objects.equals(this.ftOpt, f.ftOpt)) return false;
        if (!Array.equals(this.occ, f.occ)) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, new Object[0]), new Object[]{this.ftOpt, this.occ, this.query});
    }

    @Override
    public void toString(QueryString qs) {
        if (this.query instanceof AStr) {
            qs.token(this.query);
        } else {
            qs.brace(this.query);
        }
        switch (this.mode) {
            case ALL: {
                qs.token("all");
                break;
            }
            case ALL_WORDS: {
                qs.token("all").token("words");
                break;
            }
            case ANY_WORD: {
                qs.token("any").token("word");
                break;
            }
            case PHRASE: {
                qs.token("phrase");
                break;
            }
        }
        if (this.occ != null) {
            qs.token("occurs").token(this.occ[0]).token("to").token(this.occ[1]).token("times");
        }
        if (this.ftOpt != null) {
            qs.token(this.ftOpt);
        }
    }
}

