/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.path;

import java.util.ArrayList;
import java.util.List;
import org.basex.data.Data;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.ExprInfo;
import org.basex.query.expr.path.NamePart;
import org.basex.query.expr.path.NameTest;
import org.basex.query.expr.path.UnionTest;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.util.Util;

public abstract class Test
extends ExprInfo {
    public final NodeType type;

    Test(NodeType type) {
        this.type = type;
    }

    public static Test get(NodeType type, QNm name, byte[] defaultNs) {
        NamePart part = type == NodeType.PROCESSING_INSTRUCTION ? NamePart.LOCAL : NamePart.FULL;
        return new NameTest(name, part, type, defaultNs);
    }

    public static Test get(List<Test> tests) {
        int tl = tests.size();
        if (tl == 0) {
            return null;
        }
        if (tl == 1) {
            return tests.get(0);
        }
        ArrayList<Test> list = new ArrayList<Test>(tl);
        for (Test test : tests) {
            if (test == null) {
                return null;
            }
            if (test instanceof UnionTest) {
                UnionTest ut = (UnionTest)test;
                for (Test t : ut.tests) {
                    if (list.contains(t)) continue;
                    list.add(t);
                }
                continue;
            }
            if (list.contains(test)) continue;
            list.add(test);
        }
        return list.size() == 1 ? (Test)list.get(0) : new UnionTest((Test[])list.toArray(Test[]::new));
    }

    public Test optimize(Data data) {
        return this;
    }

    public abstract boolean matches(ANode var1);

    public final boolean matches(Item item) {
        ANode node;
        return item instanceof ANode && this.matches(node = (ANode)item);
    }

    public Boolean matches(SeqType seqType) {
        return null;
    }

    public abstract Test copy();

    public boolean instanceOf(Test test) {
        boolean bl;
        if (test instanceof UnionTest) {
            UnionTest ut = (UnionTest)test;
            bl = ut.instance(this);
        } else {
            bl = this.type.instanceOf(test.type);
        }
        return bl;
    }

    public abstract Test intersect(Test var1);

    public abstract String toString(boolean var1);

    @Override
    public void toXml(QueryPlan plan) {
        throw Util.notExpected();
    }

    @Override
    public final void toString(QueryString qs) {
        qs.token(this.toString(true));
    }
}

