/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.bin;

import java.nio.ByteOrder;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.bin.BinFn;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Item;
import org.basex.util.InputInfo;

public final class BinPackInteger
extends BinFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        long integer = this.toLong(this.arg(0), qc);
        long size = this.toLong(this.arg(1), qc);
        ByteOrder order = this.order(this.arg(2), qc);
        if (size < 0L) {
            throw QueryError.BIN_NS_X.get(this.info, size);
        }
        byte[] tmp = new byte[(int)size];
        int tl = tmp.length;
        if (order == ByteOrder.BIG_ENDIAN) {
            for (int t = tl - 1; t >= 0; --t) {
                tmp[t] = (byte)integer;
                integer >>= 8;
            }
        } else {
            for (int t = 0; t < tl; ++t) {
                tmp[t] = (byte)integer;
                integer >>= 8;
            }
        }
        return B64.get(tmp);
    }
}

