/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.ft;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.ft.FtAccessFn;
import org.basex.query.func.ft.FtTokenizeOptions;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.StrSeq;
import org.basex.util.ft.FTCase;
import org.basex.util.ft.FTDiacritics;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTOpt;
import org.basex.util.ft.Language;
import org.basex.util.list.TokenList;

public class FtTokenize
extends FtAccessFn {
    @Override
    public Value value(QueryContext qc) throws QueryException {
        return StrSeq.get(this.tokens(qc, false));
    }

    protected final TokenList tokens(QueryContext qc, boolean all) throws QueryException {
        Item value = this.arg(0).atomItem(qc, this.info);
        FtTokenizeOptions options = this.toOptions(this.arg(1), new FtTokenizeOptions(), qc);
        TokenList tl = new TokenList();
        if (!value.isEmpty()) {
            FTCase cs;
            String ln;
            Boolean st;
            FTOpt opt = new FTOpt().assign(qc.ftOpt());
            FTDiacritics dc = options.get(FtTokenizeOptions.DIACRITICS);
            if (dc != null) {
                opt.set(FTFlag.DC, dc == FTDiacritics.SENSITIVE);
            }
            if ((st = options.get(FtTokenizeOptions.STEMMING)) != null) {
                opt.set(FTFlag.ST, st);
            }
            if ((ln = options.get(FtTokenizeOptions.LANGUAGE)) != null) {
                opt.ln = Language.get(ln);
            }
            if ((cs = options.get(FtTokenizeOptions.CASE)) != null) {
                opt.cs = cs;
            }
            FTLexer lexer = new FTLexer(opt).init(this.toToken(value));
            if (all) {
                lexer.all();
            }
            while (lexer.hasNext()) {
                tl.add(lexer.nextToken());
            }
        }
        return tl;
    }
}

