/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.DTDur;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public final class GDt
extends ADate {
    private static final Type[] TYPES = new Type[]{AtomType.G_YEAR, AtomType.G_YEAR_MONTH, AtomType.G_MONTH, AtomType.G_MONTH_DAY, AtomType.G_DAY};
    private static final Pattern[] PATTERNS = new Pattern[]{Pattern.compile("(-?(000[1-9]|00[1-9]\\d|0[1-9]\\d{2}|[1-9]\\d{3,}))(([-+])(\\d{2}):(\\d{2})|Z)?"), Pattern.compile("(-?(000[1-9]|00[1-9]\\d|0[1-9]\\d{2}|[1-9]\\d{3,}))-(\\d{2})(([-+])(\\d{2}):(\\d{2})|Z)?"), Pattern.compile("--(\\d{2})(([-+])(\\d{2}):(\\d{2})|Z)?"), Pattern.compile("--(\\d{2})-(\\d{2})(([-+])(\\d{2}):(\\d{2})|Z)?"), Pattern.compile("---(\\d{2})(([-+])(\\d{2}):(\\d{2})|Z)?")};
    private static final String[] EXAMPLES = new String[]{"2000", "2000-12", "--12", "--12-31", "---31"};
    private static final int[] ZONES = new int[]{3, 4, 2, 3, 2};

    public GDt(ADate date, Type type) {
        super(type, date);
        if (type != AtomType.G_YEAR && type != AtomType.G_YEAR_MONTH) {
            this.year = Long.MAX_VALUE;
        }
        if (type != AtomType.G_MONTH && type != AtomType.G_YEAR_MONTH && type != AtomType.G_MONTH_DAY) {
            this.month = (byte)-1;
        }
        if (type != AtomType.G_DAY && type != AtomType.G_MONTH_DAY) {
            this.day = (byte)-1;
        }
        this.hour = (byte)-1;
        this.minute = (byte)-1;
        this.seconds = null;
    }

    public GDt(byte[] date, Type type, InputInfo info) throws QueryException {
        super(type);
        String dt = Token.string(date).trim();
        int i = GDt.type(type);
        Matcher mt = PATTERNS[i].matcher(dt);
        if (!mt.matches()) {
            throw this.dateError(date, EXAMPLES[i], info);
        }
        if (i < 2) {
            this.year = this.toLong(mt.group(1), false, info);
            if (this.year < 0L) {
                ++this.year;
            }
            if (this.year < -25252734927766554L || this.year >= 25252734927766554L) {
                throw QueryError.DATERANGE_X_X.get(info, type, date);
            }
        }
        if (i > 0 && i < 4) {
            this.month = (byte)(Strings.toLong(mt.group(i == 1 ? 3 : 1)) - 1L);
            if (this.month < 0 || this.month > 11) {
                throw this.dateError(date, EXAMPLES[i], info);
            }
        }
        if (i > 2) {
            this.day = (byte)(Strings.toLong(mt.group(i == 3 ? 2 : 1)) - 1L);
            int m = Math.max(this.month, 0);
            if (this.day < 0 || this.day >= DAYS[m] + (m == 1 ? (byte)1 : 0)) {
                throw this.dateError(date, EXAMPLES[i], info);
            }
        }
        this.zone(mt, ZONES[i], date, info);
    }

    private static int type(Type type) {
        int tl = TYPES.length;
        for (int t = 0; t < tl; ++t) {
            if (TYPES[t] != type) continue;
            return t;
        }
        throw Util.notExpected();
    }

    @Override
    public GDt timeZone(DTDur dur, boolean undefined, InputInfo info) {
        throw Util.notExpected();
    }

    @Override
    public int compare(Item item, Collation coll, boolean transitive, InputInfo ii) throws QueryException {
        throw QueryError.compareError(item, this, ii);
    }

    @Override
    public byte[] string(InputInfo ii) {
        TokenBuilder tb = new TokenBuilder();
        if (this.year == Long.MAX_VALUE) {
            tb.add(45);
        } else {
            if (this.year <= 0L) {
                tb.add(45);
            }
            GDt.prefix(tb, Math.abs(this.yea()), 4);
        }
        if (this.month >= 0 || this.day >= 0) {
            tb.add(45);
        }
        if (this.month >= 0) {
            GDt.prefix(tb, this.month + 1, 2);
        }
        if (this.day >= 0) {
            tb.add(45);
        }
        if (this.day >= 0) {
            GDt.prefix(tb, this.day + 1, 2);
        }
        this.zone(tb);
        return tb.finish();
    }
}

