/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.util.ArrayList;
import java.util.Collections;
import org.basex.util.ft.FTOpt;
import org.basex.util.ft.FTUnit;
import org.basex.util.ft.JapaneseTokenizer;
import org.basex.util.ft.Language;
import org.basex.util.ft.LanguageImpl;
import org.basex.util.ft.WesternTokenizer;

public abstract class Tokenizer
extends LanguageImpl {
    static final ArrayList<Tokenizer> IMPL = new ArrayList();
    boolean original;
    boolean all;

    public static boolean supportFor(Language language) {
        for (Tokenizer impl : IMPL) {
            if (!impl.supports(language)) continue;
            return true;
        }
        return false;
    }

    abstract Tokenizer get(FTOpt var1);

    int[][] info() {
        return new int[0][];
    }

    boolean paragraph() {
        return false;
    }

    int pos(int word, FTUnit unit) {
        return 0;
    }

    static {
        IMPL.add(new WesternTokenizer(null));
        if (JapaneseTokenizer.available()) {
            IMPL.add(new JapaneseTokenizer(null));
        }
        Collections.sort(IMPL);
    }
}

