/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.jobs;

import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.basex.core.Context;
import org.basex.core.jobs.Job;
import org.basex.core.jobs.JobContext;
import org.basex.core.jobs.JobException;
import org.basex.core.jobs.JobOptions;
import org.basex.core.jobs.JobPool;
import org.basex.core.jobs.JobState;
import org.basex.core.jobs.QueryJobResult;
import org.basex.core.jobs.QueryJobSpec;
import org.basex.core.jobs.QueryJobTask;
import org.basex.query.QueryDateTime;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.query.value.Value;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.DTDur;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.item.Tim;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.log.LogType;

public final class QueryJob
extends Job
implements Runnable {
    private final QueryJobResult result = new QueryJobResult(this);
    private final QueryJobSpec job;
    private final Consumer<QueryJobResult> notify;
    private QueryProcessor qp;
    private boolean remove;
    private final AtomicBoolean running = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryJob(QueryJobSpec job, Context context, InputInfo info, Consumer<QueryJobResult> notify) throws QueryException {
        boolean cache;
        long duration;
        long delay;
        this.job = job;
        this.notify = notify;
        this.jc().context = context;
        JobOptions opts = job.options;
        Item start = QueryJob.toTime(opts.get(JobOptions.START), info);
        long interval = 0L;
        String inter = opts.get(JobOptions.INTERVAL);
        if (inter != null && !inter.isEmpty()) {
            interval = new DTDur(Token.token(inter), info).ms(info);
            if (interval < 1000L) {
                throw QueryError.JOBS_RANGE_X.get(info, inter);
            }
            for (delay = start == null ? 0L : QueryJob.toDelay(start, 0L, info); delay < 0L; delay += interval) {
            }
        }
        if (delay < 0L) {
            throw QueryError.JOBS_RANGE_X.get(info, start);
        }
        Item end = QueryJob.toTime(opts.get(JobOptions.END), info);
        long l = duration = end == null ? Long.MAX_VALUE : QueryJob.toDelay(end, delay, info);
        if (duration <= delay) {
            throw QueryError.JOBS_RANGE_X.get(info, end);
        }
        boolean bl = cache = opts.contains(JobOptions.CACHE) && opts.get(JobOptions.CACHE) != false;
        if (cache && interval > 0L) {
            throw QueryError.JOBS_OPTIONS.get(info, new Object[0]);
        }
        JobPool jobs = context.jobs;
        if (jobs.tasks.size() + jobs.active.size() >= 0x100000) {
            throw QueryError.JOBS_OVERFLOW.get(info, new Object[0]);
        }
        Map<String, QueryJobTask> map = jobs.tasks;
        synchronized (map) {
            String id = opts.get(JobOptions.ID);
            if (id != null) {
                if (id.startsWith("job")) {
                    throw QueryError.JOBS_ID_INVALID_X.get(info, id);
                }
                if (jobs.tasks.containsKey(id) || jobs.active.containsKey(id) || jobs.results.containsKey(id)) {
                    throw QueryError.JOBS_ID_EXISTS_X.get(info, id);
                }
                this.jc().id(id);
            } else {
                id = this.jc().id();
            }
            if (cache) {
                if (jobs.results.size() >= 1024) {
                    throw QueryError.JOBS_OVERFLOW.get(info, new Object[0]);
                }
                jobs.results.put(id, this.result);
            }
            QueryJobTask task = new QueryJobTask(this, delay, interval, duration);
            jobs.tasks.put(id, task);
            if (interval > 0L) {
                jobs.timer.scheduleAtFixedRate((TimerTask)task, delay, interval);
            } else {
                jobs.timer.schedule((TimerTask)task, delay);
            }
        }
    }

    public static Item toTime(String string, InputInfo info) throws QueryException {
        if (string == null || string.isEmpty()) {
            return null;
        }
        if (string.matches("^\\d+$")) {
            return Itr.get(Itr.parse(Token.token(string), info));
        }
        if (Dur.DTD.matcher(string).matches()) {
            return new DTDur(Token.token(string), info);
        }
        if (ADate.TIME.matcher(string).matches()) {
            return new Tim(Token.token(string), info);
        }
        return new Dtm(Token.token(string), (Type)AtomType.DATE_TIME, info);
    }

    public HashMap<String, Value> bindings() {
        return this.job.bindings;
    }

    public static long toDelay(Item start, long min, InputInfo info) throws QueryException {
        long ms;
        QueryDateTime qdt = new QueryDateTime();
        if (start instanceof Itr) {
            Itr itr = (Itr)start;
            ms = itr.itr() * 60000L;
            ms -= qdt.time.daySeconds().multiply(Dec.BD_1000).longValue();
            while (ms <= min) {
                ms += 3600000L;
            }
        } else if (start instanceof DTDur) {
            DTDur dur = (DTDur)start;
            ms = dur.ms(info);
        } else if (start instanceof Dtm) {
            Dtm dtm = (Dtm)start;
            ms = new DTDur(dtm, qdt.datm, info).ms(info);
        } else {
            for (ms = new DTDur((Tim)start, qdt.time, info).ms(info); ms <= min; ms += 86400000L) {
            }
        }
        return ms;
    }

    void remove() {
        this.remove = true;
    }

    void startIfNotRunning() {
        if (this.running.compareAndSet(false, true)) {
            new Thread(this).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        try {
            this.result.init();
            JobContext jc = this.jc();
            String id = jc.id();
            Context ctx = jc.context;
            JobOptions opts = this.job.options;
            String log = opts.get(JobOptions.LOG);
            if (log != null && log.isEmpty()) {
                log = null;
            }
            if (log != null) {
                ctx.log.write((Object)LogType.REQUEST, log, null, "JOB:" + id, ctx);
            }
            Performance perf = new Performance();
            this.qp = new QueryProcessor(this.job.query, opts.get(JobOptions.BASE_URI), ctx, null);
            try {
                for (Map.Entry<String, Value> binding : this.job.bindings.entrySet()) {
                    String key = binding.getKey();
                    Value value = binding.getValue();
                    if (key.isEmpty()) {
                        this.qp.context(value);
                        continue;
                    }
                    this.qp.variable(key, value);
                }
                this.qp.parse();
                this.updating = this.qp.updating;
                this.result.time = perf.nanoRuntime();
                this.pushJob(this.qp);
                this.register(ctx);
                perf.nanoRuntime();
                if (this.remove) {
                    ctx.jobs.tasks.remove(id);
                }
                this.result.value = this.qp.value().materialize(d -> d == null || d.inMemory(), null, this.qp.qc);
            }
            catch (JobException ex) {
                Util.debug(ex);
                ctx.jobs.results.remove(id);
            }
            catch (QueryException ex) {
                this.result.exception = ex;
            }
            catch (Throwable ex2) {
                block35: {
                    block34: {
                        this.result.exception = QueryError.XQUERY_UNEXPECTED_X.get(null, ex2);
                        if (!Boolean.TRUE.equals(opts.get(JobOptions.CACHE))) break block34;
                        ctx.jobs.scheduleResult(this);
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        this.state(JobState.CACHED);
                        break block35;
                    }
                    this.state(JobState.SCHEDULED);
                }
                if (ctx.jobs.active.containsKey(id)) {
                    this.qp.close();
                    this.unregister(ctx);
                    this.popJob();
                    this.qp = null;
                    this.result.time += jc.performance.nanoRuntime();
                }
                if (log != null) {
                    LogType type;
                    String msg = null;
                    if (this.result.exception != null) {
                        type = LogType.ERROR;
                        msg = this.result.exception.getMessage();
                    } else {
                        type = LogType.OK;
                    }
                    ctx.log.write((Object)type, msg, perf, "JOB:" + id, ctx);
                }
                jc.performance = null;
                if (this.remove) {
                    ctx.jobs.tasks.remove(id);
                }
                if (this.notify != null) {
                    this.notify.accept(this.result);
                }
                if (this.result.value != null && this.result.value.isEmpty()) {
                    ctx.jobs.results.remove(id);
                }
            }
            finally {
                if (Boolean.TRUE.equals(opts.get(JobOptions.CACHE))) {
                    ctx.jobs.scheduleResult(this);
                    this.state(JobState.CACHED);
                } else {
                    this.state(JobState.SCHEDULED);
                }
                if (ctx.jobs.active.containsKey(id)) {
                    this.qp.close();
                    this.unregister(ctx);
                    this.popJob();
                    this.qp = null;
                    this.result.time += jc.performance.nanoRuntime();
                }
                if (log != null) {
                    LogType type;
                    String msg = null;
                    if (this.result.exception != null) {
                        type = LogType.ERROR;
                        msg = this.result.exception.getMessage();
                    } else {
                        type = LogType.OK;
                    }
                    ctx.log.write((Object)type, msg, perf, "JOB:" + id, ctx);
                }
                jc.performance = null;
                if (this.remove) {
                    ctx.jobs.tasks.remove(id);
                }
                if (this.notify != null) {
                    this.notify.accept(this.result);
                }
                if (this.result.value != null && this.result.value.isEmpty()) {
                    ctx.jobs.results.remove(id);
                }
            }
        }
        finally {
            this.running.set(false);
        }
    }

    @Override
    public void addLocks() {
        this.qp.addLocks();
    }

    public String toString() {
        return this.job.simple ? this.job.query : this.job.options.get(JobOptions.BASE_URI);
    }
}

