/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIMenuCmd;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXPanel;
import org.basex.gui.view.ViewNotifier;

public abstract class View
extends BaseXPanel {
    protected View(String name, ViewNotifier notifier) {
        super(notifier.gui);
        this.setFocusable(true);
        this.setBackground(GUIConstants.BACK);
        this.setName(name);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        this.addComponentListener(this);
        notifier.add(this);
    }

    public abstract void refreshInit();

    public abstract void refreshFocus();

    public abstract void refreshMark();

    public abstract void refreshContext(boolean var1, boolean var2);

    public abstract void refreshLayout();

    public abstract void refreshUpdate();

    public abstract boolean visible();

    public abstract void visible(boolean var1);

    protected abstract boolean db();

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.gui.updating && this.gui.gopts.get(GUIOptions.MOUSEFOCUS).booleanValue()) {
            this.requestFocusInWindow();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.gui.updating) {
            this.gui.cursor(GUIConstants.CURSORARROW);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.gui.updating) {
            this.requestFocusInWindow();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.gui.updating) {
            return;
        }
        if (BaseXKeys.ESCAPE.is(e)) {
            this.gui.fullscreen(false);
        }
        if (this.gui.context.data() == null) {
            return;
        }
        if (BaseXKeys.SPACE.is(e)) {
            this.gui.notify.mark(BaseXKeys.sc(e) ? 2 : (e.isShiftDown() ? 1 : 0), null);
        } else if (BaseXKeys.ENTER.is(e)) {
            GUIMenuCmd.C_FILTER_NODES.execute(this.gui);
        }
    }

    @Override
    public final String toString() {
        return this.getName();
    }
}

