/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.ArrayList;
import org.basex.index.stats.Stats;
import org.basex.index.stats.StatsType;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Range;
import org.basex.query.expr.path.Path;
import org.basex.query.func.Function;
import org.basex.query.func.fn.FnDuplicateValues;
import org.basex.query.iter.Iter;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.hash.ItemSet;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.seq.IntSeq;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.util.hash.IntSet;
import org.basex.util.list.IntList;

public final class FnDistinctValues
extends FnDuplicateValues {
    @Override
    public Iter iter(final QueryContext qc) throws QueryException {
        final Iter values = this.arg(0).atomIter(qc, this.info);
        final Collation collation = this.toCollation(this.arg(1), qc);
        return new Iter(){
            IntSet ints = new IntSet();
            ItemSet set;

            @Override
            public Item next() throws QueryException {
                Item item;
                while ((item = qc.next(values)) != null) {
                    if (this.ints != null) {
                        int v = FnDuplicateValues.toInt(item);
                        if (v != Integer.MIN_VALUE) {
                            if (!this.ints.add(v)) continue;
                            return item;
                        }
                        this.set = ItemSet.get(collation, FnDistinctValues.this.info);
                        for (int i : this.ints.keys()) {
                            this.set.add(Itr.get(i));
                        }
                        this.ints = null;
                    }
                    if (!this.set.add(item)) continue;
                    return item;
                }
                return null;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        int v;
        Item item;
        Iter values = this.arg(0).atomIter(qc, this.info);
        Collation collation = this.toCollation(this.arg(1), qc);
        IntList list = new IntList();
        IntSet ints = new IntSet();
        while ((item = qc.next(values)) != null && (v = FnDistinctValues.toInt(item)) != Integer.MIN_VALUE) {
            if (!ints.add(v)) continue;
            list.add(v);
        }
        Value intseq = IntSeq.get(list.finish());
        if (item == null) {
            return intseq;
        }
        ValueBuilder vb = new ValueBuilder(qc).add(intseq);
        ItemSet set = ItemSet.get(collation, this.info);
        for (int i : ints.keys()) {
            set.add(Itr.get(i));
        }
        ints = null;
        do {
            if (!set.add(item)) continue;
            vb.add(item);
        } while ((item = qc.next(values)) != null);
        return vb.value(this);
    }

    @Override
    protected void simplifyArgs(CompileContext cc) throws QueryException {
        super.simplifyArgs(cc);
        if (!this.defined(1)) {
            this.arg(0, arg -> arg.simplifyFor(CompileContext.Simplify.DISTINCT, cc));
        }
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr values = this.arg(0);
        SeqType st = values.seqType();
        if (st.zero()) {
            return values;
        }
        if (Function.SORT.is(values) && (values.args().length == 1 || values.arg((int)0).seqType().type.instanceOf(AtomType.ANY_ATOMIC_TYPE))) {
            ExprList list = (ExprList)new ExprList().add(values.args());
            list.set(0, cc.function(Function.DISTINCT_VALUES, this.info, values.arg(0)));
            return cc.function(Function.SORT, this.info, (Expr[])list.finish());
        }
        if (Function.DISTINCT_VALUES.is(values) && this.arg(1).equals(values.arg(1))) {
            return values;
        }
        Expr opt = this.optStats(cc);
        if (opt != null) {
            return opt;
        }
        AtomType type = st.type.atomic();
        if (type != null) {
            if (!this.defined(1)) {
                if (values instanceof Range || values instanceof RangeSeq) {
                    return values;
                }
                if (st.zeroOrOne() && !st.mayBeArray()) {
                    return type == st.type ? values : cc.function(Function.DATA, this.info, this.exprs);
                }
            }
            this.exprType.assign(type);
        }
        return this;
    }

    public Expr duplicates(CmpV.OpV op, CompileContext cc) throws QueryException {
        if (op == CmpV.OpV.LT) {
            return Bln.FALSE;
        }
        if (op == CmpV.OpV.GE) {
            return Bln.TRUE;
        }
        Expr dupl = cc.function(Function.DUPLICATE_VALUES, this.info, this.exprs);
        return cc.function(op == CmpV.OpV.LE || op == CmpV.OpV.EQ ? Function.EMPTY : Function.EXISTS, this.info, dupl);
    }

    private Expr optStats(CompileContext cc) throws QueryException {
        Path path;
        ArrayList<Stats> list;
        Expr values = this.arg(0);
        if (!this.defined(1) && values instanceof Path && (list = (path = (Path)values).pathStats()) != null) {
            ValueBuilder vb = new ValueBuilder(cc.qc);
            ItemSet set = ItemSet.get(null, this.info);
            for (Stats stats : list) {
                if (!StatsType.isCategory(stats.type)) {
                    return null;
                }
                for (byte[] value : stats.values) {
                    Atm item = Atm.get(value);
                    if (!set.add(item)) continue;
                    vb.add(item);
                }
            }
            return vb.value(this);
        }
        return null;
    }
}

