/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.func.Functions;
import org.basex.query.func.Records;
import org.basex.query.func.StandardFunc;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.MapBuilder;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.ListType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Util;
import org.basex.util.hash.IntObjectMap;

public class FnSchemaType
extends StandardFunc {
    @Override
    public Value value(QueryContext qc) throws QueryException {
        QNm name = this.toQNm(this.arg(0).atomItem(qc, this.info));
        Enum type = AtomType.find(name, true);
        if (type == null) {
            type = ListType.find(name);
        }
        return FnSchemaType.annotate(qc, this.info, new Type[]{type});
    }

    protected static Value annotate(QueryContext qc, InputInfo info, Type ... types) throws QueryException {
        ValueBuilder vb = new ValueBuilder(qc);
        for (Type type : types) {
            Variety variety;
            AtomType baseType;
            QNm name;
            AtomType primType = null;
            FuncItem members = null;
            FuncItem matches = null;
            boolean constructor = false;
            if (type instanceof ListType) {
                ListType listType = (ListType)type;
                name = listType.qname();
                baseType = AtomType.ANY_SIMPLE_TYPE;
                variety = Variety.list;
                members = TypeAnnotation.funcItem(info, listType.atomic());
                constructor = true;
            } else if (type instanceof AtomType) {
                AtomType atomType = (AtomType)type;
                name = atomType.qname();
                if (atomType.atomic() != null) {
                    matches = Matches.funcItem(atomType, qc, info);
                }
                switch (atomType) {
                    case ANY_TYPE: {
                        baseType = null;
                        variety = Variety.mixed;
                        break;
                    }
                    case UNTYPED: {
                        baseType = AtomType.ANY_TYPE;
                        variety = Variety.mixed;
                        break;
                    }
                    case ANY_SIMPLE_TYPE: {
                        baseType = AtomType.ANY_TYPE;
                        variety = null;
                        break;
                    }
                    case ANY_ATOMIC_TYPE: {
                        baseType = AtomType.ANY_SIMPLE_TYPE;
                        variety = Variety.atomic;
                        break;
                    }
                    case NUMERIC: {
                        baseType = AtomType.ANY_SIMPLE_TYPE;
                        variety = Variety.union;
                        members = TypeAnnotation.funcItem(info, AtomType.DOUBLE, AtomType.FLOAT, AtomType.DECIMAL);
                        constructor = true;
                        break;
                    }
                    default: {
                        AtomType parent = atomType.parent();
                        baseType = parent == AtomType.NUMERIC ? AtomType.ANY_ATOMIC_TYPE : parent;
                        variety = Variety.atomic;
                        primType = atomType;
                        while (!primType.parent().oneOf(AtomType.ANY_ATOMIC_TYPE, AtomType.NUMERIC, null)) {
                            primType = primType.parent();
                        }
                        constructor = !type.oneOf(AtomType.QNAME, AtomType.NOTATION);
                        break;
                    }
                }
            } else {
                throw Util.notExpected();
            }
            MapBuilder mb = new MapBuilder();
            mb.put("name", (Value)name);
            mb.put("is-simple", (Value)Bln.get(!type.oneOf(AtomType.ANY_TYPE, AtomType.UNTYPED)));
            mb.put("base-type", (Value)(baseType == null ? TypeAnnotation.funcItem(info, new AtomType[0]) : TypeAnnotation.funcItem(info, baseType)));
            if (primType != null) {
                mb.put("primitive-type", (Value)TypeAnnotation.funcItem(info, primType));
            }
            if (variety != null) {
                mb.put("variety", Types.SCHEMA_TYPE_RECORD_VARIETY.cast(Str.get(variety.name()), qc, info));
            }
            if (members != null) {
                mb.put("members", (Value)members);
            }
            if (matches != null) {
                mb.put("matches", (Value)matches);
            }
            if (constructor) {
                mb.put("constructor", (Value)FuncType.get(Types.ANY_ATOMIC_TYPE_ZM, Types.ANY_ATOMIC_TYPE_ZO).cast((FuncItem)Functions.item(name, 1, true, info, qc, true), qc, info));
            }
            vb.add(mb.map());
        }
        return vb.value();
    }

    private static enum Variety {
        mixed,
        list,
        atomic,
        union;

    }

    private static final class TypeAnnotation
    extends Arr {
        private final SeqType seqType;
        private final AtomType[] types;

        private TypeAnnotation(SeqType seqType, InputInfo info, AtomType ... types) {
            super(info, seqType, new Expr[0]);
            this.seqType = seqType;
            this.types = types;
        }

        public static FuncItem funcItem(InputInfo info, AtomType ... types) {
            SeqType st = Records.SCHEMA_TYPE.get().seqType(Occ.get(types.length, types.length));
            return new FuncItem(info, new TypeAnnotation(st, info, types), new Var[0], AnnList.EMPTY, FuncType.get(st, new SeqType[0]), 0, null);
        }

        @Override
        public Value value(QueryContext qc) throws QueryException {
            return FnSchemaType.annotate(qc, this.info, this.types);
        }

        @Override
        public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
            return new TypeAnnotation(this.seqType, this.info, this.types);
        }

        @Override
        public void toString(QueryString qs) {
            qs.token("type-annotation").params(this.exprs);
        }
    }

    private static final class Matches
    extends Arr {
        private static final FuncType FUNC_TYPE = FuncType.get(Types.BOOLEAN_O, Types.ANY_ATOMIC_TYPE_O);
        final AtomType type;

        private Matches(InputInfo info, AtomType type, Expr ... args) {
            super(info, Types.BOOLEAN_O, args);
            this.type = type;
        }

        public static FuncItem funcItem(AtomType type, QueryContext qc, InputInfo info) {
            Var var = new VarScope().addNew(new QNm("value"), Types.ANY_ATOMIC_TYPE_O, qc, info);
            Var[] params = new Var[]{var};
            return new FuncItem(info, new Matches(info, type, new VarRef(info, var)), params, AnnList.EMPTY, FUNC_TYPE, params.length, null);
        }

        @Override
        public Item item(QueryContext qc, InputInfo ii) throws QueryException {
            Item value = this.toAtomItem(this.arg(0), qc);
            return Bln.get(value.type.instanceOf(this.type));
        }

        @Override
        public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
            return new Matches(this.info, this.type, Matches.copyAll((CompileContext)cc, vm, (Expr[])this.args()));
        }

        @Override
        public void toString(QueryString qs) {
            qs.token("matches").params(this.exprs);
        }
    }
}

