/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.hof;

import java.util.Comparator;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryRTException;
import org.basex.query.expr.Expr;
import org.basex.query.func.HofArgs;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.util.MinHeap;

public final class HofTopKWith
extends StandardFunc {
    @Override
    public Value value(QueryContext qc) throws QueryException {
        Iter input = this.arg(0).iter(qc);
        Comparator<Item> comparator = this.comparator(qc);
        long k = Math.min(this.toLong(this.arg(2), qc), Integer.MAX_VALUE);
        if (k < 1L) {
            return Empty.VALUE;
        }
        MinHeap<Item, Item> heap = new MinHeap<Item, Item>(comparator);
        try {
            Item item;
            while ((item = qc.next(input)) != null) {
                heap.insert(item, item);
                if ((long)heap.size() <= k) continue;
                heap.removeMin();
            }
        }
        catch (QueryRTException ex) {
            throw ex.getCause();
        }
        ValueBuilder vb = new ValueBuilder(qc);
        while (!heap.isEmpty()) {
            vb.add((Value)heap.removeMin());
        }
        return vb.value(this).reverse(qc);
    }

    @Override
    protected Expr opt(CompileContext cc) {
        Expr input = this.arg(0);
        return input.seqType().zero() ? input : this.adoptType(input);
    }

    private Comparator<Item> comparator(QueryContext qc) throws QueryException {
        FItem comparator = this.toFunction(this.arg(1), 2, qc);
        HofArgs args = new HofArgs(2);
        return (item1, item2) -> {
            try {
                return this.test(comparator, args.set(0, (Value)item1).set(1, (Value)item2), qc) ? -1 : 1;
            }
            catch (QueryException ex) {
                throw new QueryRTException(ex);
            }
        };
    }

    @Override
    public int hofIndex() {
        return 1;
    }
}

