/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core;

import com.xqj2.XQConnection2;
import com.xqj2.XQInsertOptions;
import com.xqj2.XQMetaData2;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import javax.transaction.xa.XAResource;
import javax.xml.xquery.XQConnection;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQExpression;
import javax.xml.xquery.XQItem;
import javax.xml.xquery.XQMetaData;
import javax.xml.xquery.XQPreparedExpression;
import javax.xml.xquery.XQStaticContext;
import net.xqj.basic.BasicConnection;
import net.xqj.core.BasicResultSequenceIterator;
import net.xqj.core.Factory;
import net.xqj.core.GenericXQDataSource;
import net.xqj.core.Version;
import net.xqj.core.XQDataFactoryImpl;
import net.xqj.core.XQStaticContextImpl;
import net.xqj.core.XQToolkit;
import net.xqj.core.exception.XQExceptionImpl;
import net.xqj.core.proxy.XQueryModuleProxy;
import net.xqj.core.xqsequence.ForwardOnlyXQSequence;
import net.xqj.core.xqsequence.ScrollableXQSequence;
import net.xqj.core.xqsequence.XQResultSequenceProxy;

public abstract class GenericXQConnection
extends XQDataFactoryImpl
implements XQConnection,
XQConnection2,
XQMetaData2,
Cloneable {
    private static int instanceCounter = 0;
    protected final int instanceId = ++instanceCounter;
    protected XQStaticContextImpl staticContext = new XQStaticContextImpl();
    protected final BasicConnection conn;
    protected GenericXQDataSource datasource = null;
    protected boolean isClosed = false;
    protected boolean isReadOnly = false;
    protected boolean autoCommit = true;
    protected boolean needsToCommit = false;
    protected XQExpression currentExpression = null;
    protected XQPreparedExpression currentPreparedExpression = null;
    protected XQResultSequenceProxy resultSequenceProxy;
    protected ForwardOnlyXQSequence forwardOnlySequence;
    protected ScrollableXQSequence scrollableSequence;
    protected BasicResultSequenceIterator xqItemIterator;
    protected final String USER;

    public GenericXQConnection(BasicConnection connection, GenericXQDataSource parent) throws XQException {
        this.conn = connection;
        this.datasource = parent;
        this.conn.connect();
        this.USER = parent.getProperty("user");
        this.setReadOnly(parent.getReadOnly());
    }

    public void close() throws XQException {
        if (this.isClosed()) {
            return;
        }
        this.isClosed = true;
        if (this.currentExpression != null) {
            this.currentExpression.close();
        }
        if (this.currentPreparedExpression != null) {
            this.currentPreparedExpression.close();
        }
        this.conn.close();
    }

    public void setNeedsToCommit() {
        this.needsToCommit = true;
    }

    public void setAutoCommit(boolean autoCommit) throws XQException {
        this.getLogger().trace(126, this, autoCommit);
        this.checkIfClosed();
        if (this.inXATransaction() && autoCommit) {
            throw new XQExceptionImpl(XQToolkit.formatMessage(140, "setAutoCommit(true)", this), "XQJGC019");
        }
        if (!autoCommit) {
            this.assertTransactionsSupported();
        }
        if (!this.autoCommit && autoCommit && this.needsToCommit) {
            this.commit();
        }
        this.conn.setAutoCommit(autoCommit);
        this.autoCommit = autoCommit;
        this.getDataSource().getLogger().trace(126, this.toString(), autoCommit);
    }

    public boolean getAutoCommit() throws XQException {
        this.checkIfClosed();
        return this.autoCommit;
    }

    public void commit() throws XQException {
        this.getLogger().trace(141, this);
        this.checkIfClosed();
        if (this.inXATransaction()) {
            throw new XQExceptionImpl(XQToolkit.formatMessage(140, "commit()", this), "XQJGC020");
        }
        this.assertTransactionsSupported();
        if (this.getAutoCommit()) {
            throw new XQExceptionImpl("Tried to perform a commit whilst connection is in auto commit mode", "XQJGC008");
        }
        if (this.needsToCommit) {
            this.conn.commit();
        }
        this.needsToCommit = false;
    }

    public XQExpression createExpression() throws XQException {
        if (this.getDataSource().getLogger().isTraceLoggable()) {
            this.getDataSource().getLogger().log(5, XQToolkit.formatMessage(2, this.toString()));
        }
        this.checkIfClosed();
        this.currentExpression = Factory.newXQExpression(this);
        return this.currentExpression;
    }

    public XQExpression createExpression(XQStaticContext properties) throws XQException {
        if (this.getDataSource().getLogger().isTraceLoggable()) {
            this.getDataSource().getLogger().log(5, XQToolkit.formatMessage(3, this.toString()));
        }
        this.checkIfClosed();
        if (properties == null) {
            throw new XQExceptionImpl("XQStaticContext Properties can not be null.", "XQJGC010");
        }
        this.currentExpression = Factory.newXQExpression(this, properties);
        return this.currentExpression;
    }

    public XQMetaData getMetaData() throws XQException {
        this.checkIfClosed();
        return this;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    public XQPreparedExpression prepareExpression(String xquery) throws XQException {
        if (this.getDataSource().getLogger().isTraceLoggable()) {
            this.getDataSource().getLogger().log(5, XQToolkit.formatMessage(4, this.toString(), xquery));
        }
        this.checkIfClosed();
        return this.prepareExpression(xquery, (XQStaticContext)this.staticContext);
    }

    public XQPreparedExpression prepareExpression(String xquery, XQStaticContext properties) throws XQException {
        if (this.getDataSource().getLogger().isTraceLoggable()) {
            this.getDataSource().getLogger().log(5, XQToolkit.formatMessage(5, this.toString(), xquery));
        }
        this.checkIfClosed();
        if (xquery == null) {
            throw new XQExceptionImpl("Cannot prepare an expression from a null xquery argument.", "XQJGC011");
        }
        if (properties == null) {
            throw new XQException("Cannot prepare an expression from a null XQStaticContext properties argument.", "XQJGC012");
        }
        this.currentPreparedExpression = Factory.newXQPreparedExpression(this, xquery, properties);
        return this.currentPreparedExpression;
    }

    public XQPreparedExpression prepareExpression(Reader xquery) throws XQException {
        if (this.getDataSource().getLogger().isTraceLoggable()) {
            this.getDataSource().getLogger().log(5, XQToolkit.formatMessage(6, this.toString()));
        }
        this.checkIfClosed();
        return this.prepareExpression(xquery, (XQStaticContext)this.staticContext);
    }

    public XQPreparedExpression prepareExpression(Reader xquery, XQStaticContext properties) throws XQException {
        if (this.getDataSource().getLogger().isTraceLoggable()) {
            this.getDataSource().getLogger().log(5, XQToolkit.formatMessage(7, this.toString()));
        }
        this.checkIfClosed();
        if (xquery == null) {
            throw new XQExceptionImpl("Cannot prepare an expression from a null xquery argument.", "XQJGC013");
        }
        if (properties == null) {
            throw new XQExceptionImpl("Cannot prepare an expression from a null XQStaticContext properties argument.", "XQJGC014");
        }
        this.currentPreparedExpression = Factory.newXQPreparedExpression(this, xquery, properties);
        return this.currentPreparedExpression;
    }

    public XQPreparedExpression prepareExpression(InputStream xquery) throws XQException {
        if (this.getDataSource().getLogger().isTraceLoggable()) {
            this.getDataSource().getLogger().log(5, XQToolkit.formatMessage(8, this.toString()));
        }
        this.checkIfClosed();
        return this.prepareExpression(xquery, (XQStaticContext)this.staticContext);
    }

    public XQPreparedExpression prepareExpression(InputStream xquery, XQStaticContext properties) throws XQException {
        if (this.getDataSource().getLogger().isTraceLoggable()) {
            this.getDataSource().getLogger().log(5, XQToolkit.formatMessage(9, this.toString()));
        }
        this.checkIfClosed();
        if (xquery == null) {
            throw new XQExceptionImpl("Cannot prepare an expression from a null xquery argument.", "XQJGC015");
        }
        if (properties == null) {
            throw new XQExceptionImpl("Cannot prepare an expression from a null XQStaticContext properties argument.", "XQJGC016");
        }
        this.currentPreparedExpression = Factory.newXQPreparedExpression(this, xquery, properties);
        return this.currentPreparedExpression;
    }

    public void rollback() throws XQException {
        this.getLogger().trace(10, this);
        this.checkIfClosed();
        if (this.inXATransaction()) {
            throw new XQExceptionImpl(XQToolkit.formatMessage(140, "rollback()", this), "XQJGC021");
        }
        this.assertTransactionsSupported();
        if (this.getAutoCommit()) {
            throw new XQExceptionImpl("Tried to perform a rollback whilst connection is in auto commit mode", "XQJGC017");
        }
        if (this.needsToCommit) {
            this.conn.rollback();
        }
        this.needsToCommit = false;
    }

    @Override
    public XQStaticContext getStaticContext() throws XQException {
        if (this.getDataSource().getLogger().isTraceLoggable()) {
            this.getDataSource().getLogger().log(5, XQToolkit.formatMessage(11, this.toString()));
        }
        this.checkIfClosed();
        return (XQStaticContext)this.staticContext.clone();
    }

    public GenericXQDataSource getDataSource() {
        return this.datasource;
    }

    public void setStaticContext(XQStaticContext properties) throws XQException {
        this.checkIfClosed();
        if (properties == null) {
            throw new XQExceptionImpl("XQStaticContext properties is null, this is not allowed.", "XQJGC018");
        }
        this.staticContext = (XQStaticContextImpl)properties;
    }

    @Override
    public void checkIfClosed() throws XQException {
        if (this.isClosed()) {
            throw new XQExceptionImpl("XQConnection is in a closed state", "XQJGC006");
        }
    }

    public void reset() throws XQException {
        this.staticContext = new XQStaticContextImpl();
        if (this.currentExpression != null) {
            this.currentExpression.close();
        }
        if (this.currentPreparedExpression != null) {
            this.currentPreparedExpression.close();
        }
        this.setAutoCommit(true);
        this.setReadOnly(false);
    }

    public XQConnection getConnection() throws XQException {
        return this;
    }

    @Override
    public GenericXQConnection getUnderlyingConnection() {
        return this;
    }

    public BasicConnection getBasicConnection() {
        return this.conn;
    }

    public String toString() {
        return "XQConnection-" + this.instanceId;
    }

    public XQResultSequenceProxy getResultSequenceProxy() {
        return this.resultSequenceProxy;
    }

    public void setResultSequenceProxy(XQResultSequenceProxy resultSequenceProxy) {
        this.resultSequenceProxy = resultSequenceProxy;
    }

    public ForwardOnlyXQSequence getForwardOnlySequence() {
        return this.forwardOnlySequence;
    }

    public void setForwardOnlySequence(ForwardOnlyXQSequence forwardOnlySequence) {
        this.forwardOnlySequence = forwardOnlySequence;
    }

    public ScrollableXQSequence getScrollableSequence() {
        return this.scrollableSequence;
    }

    public void setScrollableSequence(ScrollableXQSequence scrollableSequence) {
        this.scrollableSequence = scrollableSequence;
    }

    public BasicResultSequenceIterator getXQItemBaseIterator() {
        return this.xqItemIterator;
    }

    public void setXQItemBaseIterator(BasicResultSequenceIterator xqItemIterator) {
        this.xqItemIterator = xqItemIterator;
    }

    public int getProductMajorVersion() throws XQException {
        this.checkIfClosed();
        return Version.getProductMajorVersion();
    }

    public int getProductMinorVersion() throws XQException {
        this.checkIfClosed();
        return Version.getProductMinorVersion();
    }

    public String getProductName() throws XQException {
        this.checkIfClosed();
        return Version.getProductName();
    }

    public String getProductVersion() throws XQException {
        this.checkIfClosed();
        return Version.getProductVersion();
    }

    public int getXQJMajorVersion() throws XQException {
        this.checkIfClosed();
        return 1;
    }

    public int getXQJMinorVersion() throws XQException {
        this.checkIfClosed();
        return 0;
    }

    public String getXQJVersion() throws XQException {
        this.checkIfClosed();
        return "1.0";
    }

    public boolean isXQueryXSupported() throws XQException {
        this.checkIfClosed();
        return false;
    }

    public boolean isTransactionSupported() throws XQException {
        this.checkIfClosed();
        return false;
    }

    public boolean isStaticTypingFeatureSupported() throws XQException {
        this.checkIfClosed();
        return false;
    }

    public boolean isSchemaImportFeatureSupported() throws XQException {
        this.checkIfClosed();
        return false;
    }

    public boolean isSchemaValidationFeatureSupported() throws XQException {
        this.checkIfClosed();
        return false;
    }

    public boolean isFullAxisFeatureSupported() throws XQException {
        this.checkIfClosed();
        return true;
    }

    public boolean isModuleFeatureSupported() throws XQException {
        this.checkIfClosed();
        return true;
    }

    public boolean isSerializationFeatureSupported() throws XQException {
        this.checkIfClosed();
        return true;
    }

    public boolean isStaticTypingExtensionsSupported() throws XQException {
        this.checkIfClosed();
        return false;
    }

    public String getUserName() throws XQException {
        this.checkIfClosed();
        return this.USER;
    }

    public int getMaxExpressionLength() throws XQException {
        this.checkIfClosed();
        return 0;
    }

    public int getMaxUserNameLength() throws XQException {
        this.checkIfClosed();
        return 0;
    }

    public boolean wasCreatedFromJDBCConnection() throws XQException {
        this.checkIfClosed();
        return false;
    }

    public boolean isXQueryEncodingDeclSupported() throws XQException {
        this.checkIfClosed();
        return true;
    }

    public Set getSupportedXQueryEncodings() throws XQException {
        this.checkIfClosed();
        HashSet<String> set = new HashSet<String>();
        set.add("UTF-8");
        set.add("UTF-16");
        return set;
    }

    public boolean isXQueryEncodingSupported(String encoding) throws XQException {
        this.checkIfClosed();
        return encoding.equalsIgnoreCase("UTF-8") || encoding.equalsIgnoreCase("UTF-16");
    }

    public boolean isUserDefinedXMLSchemaTypeSupported() throws XQException {
        this.checkIfClosed();
        return false;
    }

    public int getXQJ2MajorVersion() throws XQException {
        this.checkIfClosed();
        return Version.getXQJ2MajorVersion();
    }

    public int getXQJ2MinorVersion() throws XQException {
        this.checkIfClosed();
        return Version.getXQJ2MinorVersion();
    }

    public String getXQJ2Version() throws XQException {
        this.checkIfClosed();
        return new String(this.getXQJ2MajorVersion() + "." + this.getXQJ2MinorVersion());
    }

    public boolean isXQueryUpdateFacilitySupported() throws XQException {
        this.checkIfClosed();
        return false;
    }

    public boolean isXQueryFullTextSupported() throws XQException {
        this.checkIfClosed();
        return false;
    }

    public boolean isXQuery30Supported() throws XQException {
        this.checkIfClosed();
        return false;
    }

    protected void assertTransactionsSupported() throws XQException {
        if (!this.getMetaData().isTransactionSupported()) {
            throw new XQExceptionImpl("Client-side transactions are unsupported.", "XQJTX001");
        }
    }

    public void insertItem(String uri, XQItem item, XQInsertOptions options) throws XQException {
        if (uri == null) {
            throw new XQExceptionImpl("uri can not be null.", "XQJGC001");
        }
        if (item == null) {
            throw new XQExceptionImpl("item can not be null.", "XQJGC002");
        }
        if (this.isReadOnly()) {
            throw new XQExceptionImpl("Can not insert item when XQConnection is in read-only mode.", "XQJGC009");
        }
        int itemKind = item.getItemType().getItemKind();
        if (itemKind != 4 && itemKind != 5 && itemKind != 6) {
            throw new XQExceptionImpl("item is not a document node.", "XQJGC003");
        }
        this.conn.insert(uri, item, options);
        if (!this.getAutoCommit()) {
            this.needsToCommit = true;
        }
    }

    public <T> T createModuleProxy(String namespaceUri, String moduleUri, Class<T> clazz) throws XQException {
        if (!clazz.isInterface()) {
            throw new XQExceptionImpl("Class parameter must be a Java interface.", "XQJGC004");
        }
        if (namespaceUri == null) {
            throw new XQExceptionImpl("namespaceUri parameter must not be null.", "XQJGC005");
        }
        return (T)XQueryModuleProxy.createProxy(this, namespaceUri, moduleUri, new Class[]{clazz});
    }

    public <T> T createModuleProxy(String namespaceUri, String moduleUri, Class<T> clazz, XQStaticContext context) throws XQException {
        return this.createModuleProxy(namespaceUri, moduleUri, clazz, null);
    }

    public boolean isInsideTransaction() {
        return !this.autoCommit && this.needsToCommit;
    }

    public void setReadOnly(boolean readOnly) throws XQException {
        this.checkIfClosed();
        if (this.isReadOnly == readOnly) {
            return;
        }
        if (this.isInsideTransaction()) {
            throw new XQExceptionImpl("Can not change the connection's read-only mode when a manual transaction has already been started.", "XQJGC007");
        }
        this.conn.setReadOnly(readOnly);
        this.isReadOnly = readOnly;
    }

    public boolean isReadOnly() throws XQException {
        this.checkIfClosed();
        return this.isReadOnly;
    }

    public void setTransactionTimeout(int seconds) throws XQException {
        throw new UnsupportedOperationException("Method currently unsupported.");
    }

    public int getTransactionTimeout() throws XQException {
        throw new UnsupportedOperationException("Method currently unsupported.");
    }

    public XAResource getXAResource() throws XQException {
        throw new UnsupportedOperationException("Method currently unsupported.");
    }

    public boolean isXASupported() throws XQException {
        throw new UnsupportedOperationException("Method currently unsupported.");
    }

    public boolean inXATransaction() {
        return false;
    }

    @Override
    public Object clone() {
        return (GenericXQConnection)super.clone();
    }
}

