/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.util;

import java.nio.ByteBuffer;
import java.text.NumberFormat;

public class BufferRecycler {
    private ByteBuffer smallBuffer = null;
    private ByteBuffer mediumBuffer = null;
    private ByteBuffer largeBuffer = null;
    private ByteBuffer hugeBuffer = null;
    private ByteBuffer expandableBuffer = null;
    private static final int _smallBufferMaxSize = 1024;
    private static final int _mediumBufferMaxSize = 0x100000;
    private static final int _largeBufferMaxSize = 0xA00000;
    private static final int _hugeBufferMaxSize = 0x6400000;
    private boolean debug = true;

    public ByteBuffer allocateDirect(int size) {
        ByteBuffer buffer = null;
        if (size <= 1024) {
            if (this.smallBuffer == null) {
                buffer = this.__allocateDirect(1024);
            } else {
                buffer = this.smallBuffer;
                if (this.debug) {
                    System.out.println("re-used small buffer 1024 bytes [current-thread=" + Thread.currentThread().getName() + "]");
                }
                this.smallBuffer = null;
            }
        } else if (size <= 0x100000) {
            if (this.mediumBuffer == null) {
                buffer = this.__allocateDirect(0x100000);
            } else {
                buffer = this.mediumBuffer;
                if (this.debug) {
                    System.out.println("re-used small buffer 1024 bytes [current-thread=" + Thread.currentThread().getName() + "]");
                }
                this.mediumBuffer = null;
            }
        } else if (size <= 0xA00000) {
            if (this.largeBuffer == null) {
                buffer = this.__allocateDirect(0xA00000);
            } else {
                buffer = this.largeBuffer;
                if (this.debug) {
                    System.out.println("re-used large buffer " + NumberFormat.getInstance().format(0xA00000L) + " bytes [current-thread=" + Thread.currentThread().getName() + "]");
                }
                this.largeBuffer = null;
            }
        } else if (size <= 0x6400000) {
            if (this.hugeBuffer == null) {
                buffer = this.__allocateDirect(0x6400000);
            } else {
                buffer = this.hugeBuffer;
                if (this.debug) {
                    System.out.println("re-used huge buffer " + NumberFormat.getInstance().format(0x6400000L) + " bytes [current-thread=" + Thread.currentThread().getName() + "]");
                }
                this.hugeBuffer = null;
            }
        } else if (this.expandableBuffer != null && this.expandableBuffer.capacity() <= size) {
            buffer = this.expandableBuffer;
            if (this.debug) {
                System.out.println("re-used expandable buffer " + NumberFormat.getInstance().format(buffer.capacity()) + " bytes [current-thread=" + Thread.currentThread().getName() + "]");
            }
            this.expandableBuffer = null;
        } else {
            buffer = this.__allocateDirect(size);
        }
        buffer.limit(size);
        return buffer;
    }

    public void cache(ByteBuffer buffer) {
        if (buffer.capacity() <= 1024) {
            this.smallBuffer = buffer;
            if (this.debug) {
                System.out.println("cached small buffer [" + System.identityHashCode(buffer) + "] [current-thread='" + Thread.currentThread().getName() + "']");
            }
        } else if (buffer.capacity() <= 0x100000) {
            this.mediumBuffer = buffer;
            if (this.debug) {
                System.out.println("cached medium buffer [" + System.identityHashCode(buffer) + "] [current-thread='" + Thread.currentThread().getName() + "']");
            }
        } else if (buffer.capacity() <= 0xA00000) {
            this.largeBuffer = buffer;
            if (this.debug) {
                System.out.println("cached large buffer [" + System.identityHashCode(buffer) + "] [current-thread='" + Thread.currentThread().getName() + "']");
            }
        } else if (buffer.capacity() <= 0x6400000) {
            this.hugeBuffer = buffer;
            if (this.debug) {
                System.out.println("cached huge buffer [" + System.identityHashCode(buffer) + "] [current-thread='" + Thread.currentThread().getName() + "']");
            }
        } else if (this.expandableBuffer == null) {
            this.expandableBuffer = buffer;
            if (this.debug) {
                System.out.println("cached expandable buffer [" + System.identityHashCode(buffer) + "] " + NumberFormat.getInstance().format(buffer.capacity()) + " bytes [current-thread='" + Thread.currentThread().getName() + "']");
            }
        } else if (buffer.capacity() > this.expandableBuffer.capacity()) {
            if (this.debug) {
                System.out.println("cached expandable buffer [" + System.identityHashCode(buffer) + "] " + buffer.capacity() + " bytes, overwriting previous cachedexpandable buffer which had " + NumberFormat.getInstance().format(this.expandableBuffer.capacity()) + " bytes [current-thread='" + Thread.currentThread().getName() + "']");
            }
            this.expandableBuffer = buffer;
        }
    }

    private final ByteBuffer __allocateDirect(int size) {
        float mb = (float)size / 1024.0f / 1024.0f;
        if (this.debug) {
            System.out.println(this.getClass().getName() + ": Trying to create new Direct ByteBuffer of size " + NumberFormat.getInstance().format(mb) + " MB. [current-thread=\"" + Thread.currentThread().getName() + "\"]");
        }
        try {
            ByteBuffer buffer = ByteBuffer.allocateDirect(size);
            if (this.debug) {
                System.out.println(this.getClass().getName() + ": Created new Direct ByteBuffer [" + System.identityHashCode(buffer) + "] of size " + NumberFormat.getInstance().format(mb) + " MB. [current-thread=\"" + Thread.currentThread().getName() + "\"]");
            }
            return buffer;
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(0);
            return null;
        }
    }
}

