/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.xml;

import java.io.IOException;
import org.basex.build.BuildException;
import org.basex.build.BuildText;
import org.basex.build.SingleParser;
import org.basex.build.xml.XMLScanner;
import org.basex.core.MainOptions;
import org.basex.data.DataText;
import org.basex.io.IO;
import org.basex.util.Token;
import org.basex.util.list.BoolList;
import org.basex.util.list.TokenList;

public class XMLParser
extends SingleParser {
    private final boolean stripNS;
    private final boolean stripWS;
    private final BoolList strips = new BoolList();
    private final XMLScanner scanner;
    private final TokenList elms = new TokenList();
    private final boolean fragment;
    private boolean closed;

    public XMLParser(IO source, MainOptions options) throws IOException {
        this(source, options, false);
    }

    public XMLParser(IO source, MainOptions options, boolean fragment) throws IOException {
        super(source, options);
        this.scanner = new XMLScanner(source, options, fragment);
        this.stripNS = options.get(MainOptions.STRIPNS);
        this.stripWS = options.get(MainOptions.STRIPWS);
        this.strips.push(this.stripWS);
        this.fragment = fragment;
    }

    @Override
    public final void parse() throws IOException {
        this.scanner.more();
        while (true) {
            if (this.scanner.type == BuildText.Type.TEXT) {
                byte[] text = this.scanner.token.toArray();
                if (!this.elms.isEmpty() || this.fragment || !Token.ws(text)) {
                    if (this.strips.peek()) {
                        this.scanner.token.trim();
                    }
                    this.builder.text(this.scanner.token.toArray());
                }
            } else if (this.scanner.type == BuildText.Type.COMMENT) {
                this.builder.comment(this.scanner.token.toArray());
            } else if (this.scanner.type == BuildText.Type.PI) {
                this.builder.pi(this.scanner.token.toArray());
            } else {
                if (this.scanner.type == BuildText.Type.EOF) break;
                if (this.scanner.type != BuildText.Type.DTD) {
                    if (!this.fragment && this.closed) {
                        throw new BuildException("%: No elements allowed after closed root element.", this.detailedInfo());
                    }
                    if (this.parseElement()) continue;
                    break;
                }
            }
            if (!this.scanner.more()) break;
        }
        this.scanner.close();
        if (!this.elms.isEmpty()) {
            throw new BuildException("%: Closing element </%> expected.", this.detailedInfo(), this.elms.pop());
        }
    }

    @Override
    public void close() throws IOException {
        this.scanner.close();
    }

    private boolean parseElement() throws IOException {
        int a;
        if (this.scanner.type == BuildText.Type.L_BR_CLOSE) {
            this.scanner.more();
            byte[] name = this.consumeToken(BuildText.Type.ELEMNAME);
            if (this.stripNS) {
                name = Token.local(name);
            }
            this.skipSpace();
            if (this.elms.isEmpty()) {
                throw new BuildException("%: Opening element <%> expected.", this.detailedInfo(), name);
            }
            byte[] open = (byte[])this.elms.pop();
            if (!Token.eq(open, name)) {
                throw new BuildException("%: </%> found, </%> expected.", this.detailedInfo(), name, open);
            }
            this.strips.pop();
            this.builder.closeElem();
            if (this.elms.isEmpty()) {
                this.closed = true;
            }
            return this.consume(BuildText.Type.R_BR);
        }
        this.consume(BuildText.Type.L_BR);
        this.atts.reset();
        this.nsp.reset();
        byte[] en = this.consumeToken(BuildText.Type.ELEMNAME);
        if (this.stripNS) {
            en = Token.local(en);
        }
        this.skipSpace();
        while (this.scanner.type != BuildText.Type.R_BR && this.scanner.type != BuildText.Type.CLOSE_R_BR) {
            byte[] an = this.consumeToken(BuildText.Type.ATTNAME);
            this.skipSpace();
            this.consume(BuildText.Type.EQ);
            this.skipSpace();
            this.consume(BuildText.Type.QUOTE);
            byte[] av = Token.EMPTY;
            if (this.scanner.type == BuildText.Type.ATTVALUE) {
                av = this.scanner.token.toArray();
                this.scanner.more();
            }
            this.consume(BuildText.Type.QUOTE);
            if (Token.startsWith(an, Token.XMLNS_COLON)) {
                if (!this.stripNS) {
                    this.nsp.add(Token.local(an), av);
                }
            } else if (Token.eq(an, Token.XMLNS)) {
                if (!this.stripNS) {
                    this.nsp.add(Token.EMPTY, av);
                }
            } else {
                this.atts.add(an, av, this.stripNS);
            }
            if (this.scanner.type == BuildText.Type.R_BR || this.scanner.type == BuildText.Type.CLOSE_R_BR) continue;
            this.consume(BuildText.Type.WS);
        }
        if (this.scanner.type == BuildText.Type.CLOSE_R_BR) {
            this.builder.emptyElem(en, this.atts, this.nsp);
            if (this.elms.isEmpty()) {
                this.closed = true;
            }
            return this.scanner.more();
        }
        this.builder.openElem(en, this.atts, this.nsp);
        this.elms.push(en);
        boolean strip = this.strips.peek();
        if (this.stripWS && (a = this.atts.get(DataText.XML_SPACE)) != -1) {
            byte[] s = this.atts.value(a);
            if (Token.eq(s, DataText.DEFAULT)) {
                strip = true;
            } else if (Token.eq(s, DataText.PRESERVE)) {
                strip = false;
            }
        }
        this.strips.push(strip);
        return this.consume(BuildText.Type.R_BR);
    }

    private boolean consume(BuildText.Type type) throws IOException {
        if (this.scanner.type == type) {
            return this.scanner.more();
        }
        throw new BuildException("%: % expected, % found.", this.detailedInfo(), type.string, this.scanner.type.string);
    }

    private byte[] consumeToken(BuildText.Type type) throws IOException {
        if (this.scanner.type == type) {
            byte[] token = this.scanner.token.toArray();
            this.scanner.more();
            return token;
        }
        throw new BuildException("%: % expected, % found.", this.detailedInfo(), type.string, this.scanner.type.string);
    }

    private void skipSpace() throws IOException {
        if (this.scanner.type == BuildText.Type.WS) {
            this.scanner.more();
        }
    }

    @Override
    public final String detailedInfo() {
        return this.scanner.detailedInfo();
    }

    @Override
    public final double progressInfo() {
        return this.scanner.progressInfo();
    }
}

