/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.util.Arrays;
import org.basex.util.Array;
import org.basex.util.Token;

public final class TokenBuilder {
    public static final byte NLINE = 10;
    public static final int PRIVATE_START = 57344;
    public static final int PRIVATE_END = 63743;
    public static final int HLINE = 63743;
    public static final int BOLD = 63742;
    public static final int NORM = 63741;
    public static final int MARK = 63740;
    public static final int ULINE = 63739;
    private static final int LIMIT = 128;
    private byte[] chars;
    private int size;

    public TokenBuilder() {
        this(-1L);
    }

    public TokenBuilder(long capacity) {
        this.chars = new byte[Array.initialCapacity(capacity)];
    }

    public TokenBuilder(byte[] token) {
        int sz = token.length;
        this.chars = Arrays.copyOf(token, sz);
        this.size = sz;
    }

    public int size() {
        return this.size;
    }

    public void size(int sz) {
        this.size = sz;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public TokenBuilder reset() {
        this.size = 0;
        return this;
    }

    public TokenBuilder bold() {
        return this.add(63742);
    }

    public TokenBuilder uline() {
        return this.add(63739);
    }

    public TokenBuilder norm() {
        return this.add(63741);
    }

    public TokenBuilder hline() {
        return this.add(63743);
    }

    public TokenBuilder nline() {
        return this.add(10);
    }

    public TokenBuilder add(int cp) {
        if (cp <= 127) {
            return this.addByte((byte)cp);
        }
        if (cp <= 2047) {
            this.addByte((byte)(cp >> 6 | 0xC0));
        } else {
            if (cp <= 65535) {
                this.addByte((byte)(cp >> 12 | 0xE0));
            } else {
                this.addByte((byte)(cp >> 18 | 0xF0));
                this.addByte((byte)(cp >> 12 & 0x3F | 0x80));
            }
            this.addByte((byte)(cp >> 6 & 0x3F | 0x80));
        }
        return this.addByte((byte)(cp & 0x3F | 0x80));
    }

    public TokenBuilder removeLast() {
        while (--this.size > 0 && (this.chars[this.size] & 0xC0) == 128) {
        }
        return this;
    }

    public int cp(int pos) {
        return Token.cp(this.chars, pos);
    }

    public int cl(int pos) {
        return Token.cl(this.chars, pos);
    }

    public byte get(int pos) {
        return this.chars[pos];
    }

    public void set(int pos, byte value) {
        this.chars[pos] = value;
    }

    public TokenBuilder delete(int start, int end) {
        int length = end - start;
        Array.remove(this.chars, start, length, this.size);
        this.size -= length;
        return this;
    }

    public TokenBuilder addByte(byte value) {
        int s = this.size;
        byte[] chrs = this.chars;
        if (s == chrs.length) {
            chrs = Arrays.copyOf(chrs, Array.newCapacity(s));
        }
        chrs[s] = value;
        this.chars = chrs;
        this.size = s + 1;
        return this;
    }

    public TokenBuilder addInt(int value) {
        return this.add(Token.token(value));
    }

    public TokenBuilder addLong(long value) {
        return this.add(Token.token(value));
    }

    public TokenBuilder add(byte[] token) {
        return this.add(token, 0, token.length);
    }

    public TokenBuilder add(byte[] token, int start, int end) {
        int l = end - start;
        if (l > 0) {
            int s = this.size;
            int ns = s + l;
            byte[] chrs = this.chars;
            int cl = chrs.length;
            if (ns > cl) {
                chrs = Arrays.copyOf(chrs, Array.newCapacity(ns));
            }
            Array.copy(token, start, l, chrs, s);
            this.chars = chrs;
            this.size = ns;
        }
        return this;
    }

    public TokenBuilder add(String string) {
        return this.add(Token.token(string));
    }

    public TokenBuilder addAll(Object[] objects, String separator) {
        int ol = objects.length;
        for (int o = 0; o < ol; ++o) {
            if (o > 0) {
                this.add(separator);
            }
            this.add(objects[o]);
        }
        return this;
    }

    public TokenBuilder add(Object object) {
        return this.add(Token.token(object));
    }

    public TokenBuilder addExt(Object object, Object ... extensions) {
        byte[] t = Token.token(object);
        int tl = t.length;
        int el = extensions.length;
        int e = 0;
        for (int i = 0; i < tl; ++i) {
            boolean d;
            if (t[i] != 37 || e == el) {
                this.addByte(t[i]);
                continue;
            }
            byte c = i + 1 < tl ? t[i + 1] : (byte)0;
            boolean bl = d = c >= 49 && c <= 57;
            if (d) {
                ++i;
            }
            int n = d ? c - 49 : e++;
            this.add(n < el ? extensions[n] : null);
        }
        return this;
    }

    public TokenBuilder trim() {
        int s;
        byte[] chrs = this.chars;
        for (s = this.size; s > 0 && Token.ws(chrs[s - 1]); --s) {
        }
        int c = -1;
        while (++c < s && Token.ws(chrs[c])) {
        }
        if (c != 0 && c != s) {
            Array.remove(chrs, 0, c, s);
        }
        this.size = s - c;
        return this;
    }

    public TokenBuilder normalize() {
        byte[] chrs = this.chars;
        int s = this.size;
        int n = 0;
        for (int c = 0; c < s; ++c) {
            int ch = chrs[c];
            if (ch == 13) {
                ch = 10;
                if (c + 1 < s && chrs[c + 1] == 10) {
                    ++c;
                }
            }
            chrs[n++] = ch;
        }
        this.size = n;
        return this;
    }

    public byte[] toArray() {
        return TokenBuilder.finish(this.chars, this.size, true);
    }

    public byte[] next() {
        int s = this.size;
        this.size = 0;
        return TokenBuilder.finish(this.chars, s, true);
    }

    public byte[] finish() {
        byte[] chrs = this.chars;
        this.chars = null;
        return TokenBuilder.finish(chrs, this.size, false);
    }

    private static byte[] finish(byte[] chars, int size, boolean copy) {
        return size == 0 ? Token.EMPTY : (size == 1 && chars[0] >= 0 ? Token.cpToken(chars[0]) : (size != chars.length || copy ? Arrays.copyOf(chars, size) : chars));
    }

    public boolean moreInfo() {
        if (this.size <= 128) {
            return true;
        }
        if (this.chars[this.size - 1] != 46 || this.chars[this.size - 2] != 46 || this.chars[this.size - 3] != 46) {
            this.add("...");
        }
        return false;
    }

    public String toString() {
        return this.chars == null ? "" : Token.string(this.chars, 0, this.size);
    }
}

