/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.classfile.ClassPool;
import proguard.classfile.visitor.AllClassVisitor;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;

public class TimedClassPoolVisitor
implements ClassPoolVisitor {
    private static final Logger logger = LogManager.getFormatterLogger(TimedClassPoolVisitor.class);
    private final String message;
    private final ClassPoolVisitor classPoolVisitor;

    public TimedClassPoolVisitor(String message, ClassVisitor classVisitor) {
        this(message, (ClassPoolVisitor)new AllClassVisitor(classVisitor));
    }

    public TimedClassPoolVisitor(String message, ClassPoolVisitor classPoolVisitor) {
        this.message = message;
        this.classPoolVisitor = classPoolVisitor;
    }

    public void visitClassPool(ClassPool classPool) {
        long start = System.currentTimeMillis();
        classPool.accept(this.classPoolVisitor);
        long end = System.currentTimeMillis();
        logger.trace("%s %s took: %6d ms", (Object)this.message, (Object)this.getPadding(this.message.length(), 48), (Object)(end - start));
    }

    private String getPadding(int pos, int size) {
        StringBuilder sb = new StringBuilder();
        for (int i = pos; i < size; ++i) {
            sb.append('.');
        }
        return sb.toString();
    }
}

