/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker.handler;

import com.google.caliper.api.SkipThisScenarioException;
import com.google.caliper.bridge.DryRunRequest;
import com.google.caliper.bridge.DryRunSuccessLogMessage;
import com.google.caliper.bridge.ExperimentSpec;
import com.google.caliper.bridge.WorkerRequest;
import com.google.caliper.core.UserCodeException;
import com.google.caliper.worker.connection.ClientConnectionService;
import com.google.caliper.worker.handler.RequestHandler;
import com.google.caliper.worker.instrument.WorkerInstrument;
import com.google.caliper.worker.instrument.WorkerInstrumentFactory;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import javax.inject.Inject;

final class DryRunHandler
implements RequestHandler {
    private final ClientConnectionService clientConnection;
    private final WorkerInstrumentFactory instrumentFactory;

    @Inject
    DryRunHandler(ClientConnectionService clientConnection, WorkerInstrumentFactory instrumentFactory) {
        this.clientConnection = clientConnection;
        this.instrumentFactory = instrumentFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(WorkerRequest request) throws Exception {
        DryRunRequest dryRunRequest = (DryRunRequest)request;
        ImmutableSet.Builder successes = ImmutableSet.builder();
        for (ExperimentSpec experiment : dryRunRequest.experiments()) {
            try {
                WorkerInstrument workerInstrument = this.instrumentFactory.createWorkerInstrument(experiment);
                workerInstrument.setUpBenchmark();
                try {
                    workerInstrument.dryRun();
                }
                finally {
                    workerInstrument.tearDownBenchmark();
                }
                successes.add((Object)experiment.id());
            }
            catch (InvocationTargetException e) {
                Throwable userException = e.getCause();
                if (userException instanceof SkipThisScenarioException) continue;
                throw new UserCodeException(userException);
            }
        }
        this.clientConnection.send(new Serializable[]{DryRunSuccessLogMessage.create((Iterable)successes.build())});
    }
}

