/*
 * Decompiled with CFR 0.152.
 */
package proguard.resources.kotlinmodule.io;

import java.io.IOException;
import java.io.InputStream;
import proguard.io.DataEntry;
import proguard.io.DataEntryReader;
import proguard.resources.file.visitor.ResourceFileVisitor;
import proguard.resources.kotlinmodule.KotlinModule;
import proguard.resources.kotlinmodule.io.KotlinModuleReader;

public class KotlinModuleDataEntryReader
implements DataEntryReader {
    private final ResourceFileVisitor resourceFileVisitor;

    public KotlinModuleDataEntryReader(ResourceFileVisitor resourceFileVisitor) {
        this.resourceFileVisitor = resourceFileVisitor;
    }

    @Override
    public void read(DataEntry dataEntry) throws IOException {
        try {
            InputStream inputStream = dataEntry.getInputStream();
            KotlinModule kotlinModule = new KotlinModule(dataEntry.getName(), dataEntry.getSize());
            kotlinModule.accept(new KotlinModuleReader(inputStream));
            dataEntry.closeInputStream();
            kotlinModule.accept(this.resourceFileVisitor);
        }
        catch (Exception ex) {
            throw new IOException("Can't read Kotlin module file [" + dataEntry.getName() + "] (" + ex.getMessage() + ")", ex);
        }
    }
}

