;; NOTE: Assertions have been generated by update_lit_checks.py --output=fuzz-exec and should not be edited.

;; RUN: foreach %s %t wasm-opt -all --fuzz-exec-before -q -o /dev/null 2>&1 | filecheck %s

(module
  (type $none (func))
  (type $cont (cont $none))

  (import "fuzzing-support" "log" (func $log (param i32)))

  (import "fuzzing-support" "call-export" (func $call-export (param i32 i32)))

  (tag $tag (type $none))

  ;; CHECK:      [fuzz-exec] calling suspend
  ;; CHECK-NEXT: [LoggingExternalInterface logging 10]
  ;; CHECK-NEXT: [exception thrown: unhandled suspend]
  (func $suspend (export "suspend")
    ;; Helper for below.
    (call $log (i32.const 10))
    (suspend $tag)
    (call $log (i32.const 20))
  )

  ;; CHECK:      [fuzz-exec] calling call-call-export
  ;; CHECK-NEXT: [LoggingExternalInterface logging 10]
  ;; CHECK-NEXT: [exception thrown: imported-js-tag externref]
  (func $call-call-export (export "call-call-export")
    ;; Call suspend as an export. We cannot suspend through JS, so we throw.
    (call $call-export
      (i32.const 0)
      (i32.const 0)
    )
  )

  ;; CHECK:      [fuzz-exec] calling handled
  ;; CHECK-NEXT: [LoggingExternalInterface logging 10]
  ;; CHECK-NEXT: [exception thrown: imported-js-tag externref]
  (func $handled (export "handled")
    ;; As above, but inside a continuation, so it would be handled - if we could
    ;; suspend though JS. But we can't, so we throw.
    (drop
      (block $inner (result (ref $cont))
        (resume $cont (on $tag $inner)
          (cont.new $cont
            (ref.func $call-call-export)
          )
        )
        (unreachable)
      )
    )
  )
)
