// prettier-ignore
/* eslint-disable */
// @ts-nocheck
/* auto-generated by NAPI-RS */

const { createRequire } = require('node:module')
require = createRequire(__filename)

const { readFileSync } = require('node:fs')
let nativeBinding = null
const loadErrors = []

const isMusl = () => {
  let musl = false
  if (process.platform === 'linux') {
    musl = isMuslFromFilesystem()
    if (musl === null) {
      musl = isMuslFromReport()
    }
    if (musl === null) {
      musl = isMuslFromChildProcess()
    }
  }
  return musl
}

const isFileMusl = (f) => f.includes('libc.musl-') || f.includes('ld-musl-')

const isMuslFromFilesystem = () => {
  try {
    return readFileSync('/usr/bin/ldd', 'utf-8').includes('musl')
  } catch {
    return null
  }
}

const isMuslFromReport = () => {
  let report = null
  if (typeof process.report?.getReport === 'function') {
    process.report.excludeNetwork = true
    report = process.report.getReport()
  }
  if (!report) {
    return null
  }
  if (report.header && report.header.glibcVersionRuntime) {
    return false
  }
  if (Array.isArray(report.sharedObjects)) {
    if (report.sharedObjects.some(isFileMusl)) {
      return true
    }
  }
  return false
}

const isMuslFromChildProcess = () => {
  try {
    return require('child_process').execSync('ldd --version', { encoding: 'utf8' }).includes('musl')
  } catch (e) {
    // If we reach this case, we don't know if the system is musl or not, so is better to just fallback to false
    return false
  }
}

function requireNative() {
  if (process.env.NAPI_RS_NATIVE_LIBRARY_PATH) {
    try {
      nativeBinding = require(process.env.NAPI_RS_NATIVE_LIBRARY_PATH);
    } catch (err) {
      loadErrors.push(err)
    }
  } else if (process.platform === 'android') {
    if (process.arch === 'arm64') {
      try {
        return require('./ast-grep-napi.android-arm64.node')
      } catch (e) {
        loadErrors.push(e)
      }
      try {
        return require('@ast-grep/napi-android-arm64')
      } catch (e) {
        loadErrors.push(e)
      }
    } else if (process.arch === 'arm') {
      try {
        return require('./ast-grep-napi.android-arm-eabi.node')
      } catch (e) {
        loadErrors.push(e)
      }
      try {
        return require('@ast-grep/napi-android-arm-eabi')
      } catch (e) {
        loadErrors.push(e)
      }
    } else {
      loadErrors.push(new Error(`Unsupported architecture on Android ${process.arch}`))
    }
  } else if (process.platform === 'win32') {
    if (process.arch === 'x64') {
      try {
        return require('./ast-grep-napi.win32-x64-msvc.node')
      } catch (e) {
        loadErrors.push(e)
      }
      try {
        return require('@ast-grep/napi-win32-x64-msvc')
      } catch (e) {
        loadErrors.push(e)
      }
    } else if (process.arch === 'ia32') {
      try {
        return require('./ast-grep-napi.win32-ia32-msvc.node')
      } catch (e) {
        loadErrors.push(e)
      }
      try {
        return require('@ast-grep/napi-win32-ia32-msvc')
      } catch (e) {
        loadErrors.push(e)
      }
    } else if (process.arch === 'arm64') {
      try {
        return require('./ast-grep-napi.win32-arm64-msvc.node')
      } catch (e) {
        loadErrors.push(e)
      }
      try {
        return require('@ast-grep/napi-win32-arm64-msvc')
      } catch (e) {
        loadErrors.push(e)
      }
    } else {
      loadErrors.push(new Error(`Unsupported architecture on Windows: ${process.arch}`))
    }
  } else if (process.platform === 'darwin') {
    try {
      return require('./ast-grep-napi.darwin-universal.node')
    } catch (e) {
      loadErrors.push(e)
    }
    try {
      return require('@ast-grep/napi-darwin-universal')
    } catch (e) {
      loadErrors.push(e)
    }
    if (process.arch === 'x64') {
      try {
        return require('./ast-grep-napi.darwin-x64.node')
      } catch (e) {
        loadErrors.push(e)
      }
      try {
        return require('@ast-grep/napi-darwin-x64')
      } catch (e) {
        loadErrors.push(e)
      }
    } else if (process.arch === 'arm64') {
      try {
        return require('./ast-grep-napi.darwin-arm64.node')
      } catch (e) {
        loadErrors.push(e)
      }
      try {
        return require('@ast-grep/napi-darwin-arm64')
      } catch (e) {
        loadErrors.push(e)
      }
    } else {
      loadErrors.push(new Error(`Unsupported architecture on macOS: ${process.arch}`))
    }
  } else if (process.platform === 'freebsd') {
    if (process.arch === 'x64') {
      try {
        return require('./ast-grep-napi.freebsd-x64.node')
      } catch (e) {
        loadErrors.push(e)
      }
      try {
        return require('@ast-grep/napi-freebsd-x64')
      } catch (e) {
        loadErrors.push(e)
      }
    } else if (process.arch === 'arm64') {
      try {
        return require('./ast-grep-napi.freebsd-arm64.node')
      } catch (e) {
        loadErrors.push(e)
      }
      try {
        return require('@ast-grep/napi-freebsd-arm64')
      } catch (e) {
        loadErrors.push(e)
      }
    } else {
      loadErrors.push(new Error(`Unsupported architecture on FreeBSD: ${process.arch}`))
    }
  } else if (process.platform === 'linux') {
    if (process.arch === 'x64') {
      if (isMusl()) {
        try {
          return require('./ast-grep-napi.linux-x64-musl.node')
        } catch (e) {
          loadErrors.push(e)
        }
        try {
          return require('@ast-grep/napi-linux-x64-musl')
        } catch (e) {
          loadErrors.push(e)
        }
      } else {
        try {
          return require('./ast-grep-napi.linux-x64-gnu.node')
        } catch (e) {
          loadErrors.push(e)
        }
        try {
          return require('@ast-grep/napi-linux-x64-gnu')
        } catch (e) {
          loadErrors.push(e)
        }
      }
    } else if (process.arch === 'arm64') {
      if (isMusl()) {
        try {
          return require('./ast-grep-napi.linux-arm64-musl.node')
        } catch (e) {
          loadErrors.push(e)
        }
        try {
          return require('@ast-grep/napi-linux-arm64-musl')
        } catch (e) {
          loadErrors.push(e)
        }
      } else {
        try {
          return require('./ast-grep-napi.linux-arm64-gnu.node')
        } catch (e) {
          loadErrors.push(e)
        }
        try {
          return require('@ast-grep/napi-linux-arm64-gnu')
        } catch (e) {
          loadErrors.push(e)
        }
      }
    } else if (process.arch === 'arm') {
      if (isMusl()) {
        try {
          return require('./ast-grep-napi.linux-arm-musleabihf.node')
        } catch (e) {
          loadErrors.push(e)
        }
        try {
          return require('@ast-grep/napi-linux-arm-musleabihf')
        } catch (e) {
          loadErrors.push(e)
        }
      } else {
        try {
          return require('./ast-grep-napi.linux-arm-gnueabihf.node')
        } catch (e) {
          loadErrors.push(e)
        }
        try {
          return require('@ast-grep/napi-linux-arm-gnueabihf')
        } catch (e) {
          loadErrors.push(e)
        }
      }
    } else if (process.arch === 'riscv64') {
      if (isMusl()) {
        try {
          return require('./ast-grep-napi.linux-riscv64-musl.node')
        } catch (e) {
          loadErrors.push(e)
        }
        try {
          return require('@ast-grep/napi-linux-riscv64-musl')
        } catch (e) {
          loadErrors.push(e)
        }
      } else {
        try {
          return require('./ast-grep-napi.linux-riscv64-gnu.node')
        } catch (e) {
          loadErrors.push(e)
        }
        try {
          return require('@ast-grep/napi-linux-riscv64-gnu')
        } catch (e) {
          loadErrors.push(e)
        }
      }
    } else if (process.arch === 'ppc64') {
      try {
        return require('./ast-grep-napi.linux-ppc64-gnu.node')
      } catch (e) {
        loadErrors.push(e)
      }
      try {
        return require('@ast-grep/napi-linux-ppc64-gnu')
      } catch (e) {
        loadErrors.push(e)
      }
    } else if (process.arch === 's390x') {
      try {
        return require('./ast-grep-napi.linux-s390x-gnu.node')
      } catch (e) {
        loadErrors.push(e)
      }
      try {
        return require('@ast-grep/napi-linux-s390x-gnu')
      } catch (e) {
        loadErrors.push(e)
      }
    } else {
      loadErrors.push(new Error(`Unsupported architecture on Linux: ${process.arch}`))
    }
  } else if (process.platform === 'openharmony') {
    if (process.arch === 'arm64') {
      try {
        return require('./ast-grep-napi.linux-arm64-ohos.node')
      } catch (e) {
        loadErrors.push(e)
      }
      try {
        return require('@ast-grep/napi-linux-arm64-ohos')
      } catch (e) {
        loadErrors.push(e)
      }
    } else if (process.arch === 'x64') {
      try {
        return require('./ast-grep-napi.linux-x64-ohos.node')
      } catch (e) {
        loadErrors.push(e)
      }
      try {
        return require('@ast-grep/napi-linux-x64-ohos')
      } catch (e) {
        loadErrors.push(e)
      }
    } else if (process.arch === 'arm') {
      try {
        return require('./ast-grep-napi.linux-arm-ohos.node')
      } catch (e) {
        loadErrors.push(e)
      }
      try {
        return require('@ast-grep/napi-linux-arm-ohos')
      } catch (e) {
        loadErrors.push(e)
      }
    } else {
      loadErrors.push(new Error(`Unsupported architecture on OpenHarmony: ${process.arch}`))
    }
  } else {
    loadErrors.push(new Error(`Unsupported OS: ${process.platform}, architecture: ${process.arch}`))
  }
}

nativeBinding = requireNative()

if (!nativeBinding || process.env.NAPI_RS_FORCE_WASI) {
  try {
    nativeBinding = require('./ast-grep-napi.wasi.cjs')
  } catch (err) {
    if (process.env.NAPI_RS_FORCE_WASI) {
      loadErrors.push(err)
    }
  }
  if (!nativeBinding) {
    try {
      nativeBinding = require('@ast-grep/napi-wasm32-wasi')
    } catch (err) {
      if (process.env.NAPI_RS_FORCE_WASI) {
        loadErrors.push(err)
      }
    }
  }
}

if (!nativeBinding) {
  if (loadErrors.length > 0) {
    throw new Error(
      `Cannot find native binding. ` +
        `npm has a bug related to optional dependencies (https://github.com/npm/cli/issues/4828). ` +
        'Please try `npm i` again after removing both package-lock.json and node_modules directory.',
      { cause: loadErrors }
    )
  }
  throw new Error(`Failed to load native binding`)
}

module.exports = nativeBinding
module.exports.SgNode = nativeBinding.SgNode
module.exports.SgRoot = nativeBinding.SgRoot
module.exports.findInFiles = nativeBinding.findInFiles
module.exports.kind = nativeBinding.kind
module.exports.Lang = nativeBinding.Lang
module.exports.parse = nativeBinding.parse
module.exports.parseAsync = nativeBinding.parseAsync
module.exports.parseFiles = nativeBinding.parseFiles
module.exports.pattern = nativeBinding.pattern
module.exports.registerDynamicLanguage = nativeBinding.registerDynamicLanguage
module.exports.css = nativeBinding.css
module.exports.html = nativeBinding.html
module.exports.js = nativeBinding.js
module.exports.jsx = nativeBinding.jsx
module.exports.ts = nativeBinding.ts
module.exports.tsx = nativeBinding.tsx
