const FONT_SIZE = 24;
const SMALL_FONT_SIZE = 18;

const FONT_CAP_HEIGHT = 1356;
const FONT_DESCENT = 443;
const FONT_XHEIGHT = 916;

const ROMAN_FONT = 1;
const ITALIC_FONT = 2;
const SMALL_ROMAN_FONT = 3;
const SMALL_ITALIC_FONT = 4;

function
get_cap_height(font_num)
{
	switch (font_num) {
	case ROMAN_FONT:
	case ITALIC_FONT:
		return FONT_CAP_HEIGHT * FONT_SIZE / 2048;
	case SMALL_ROMAN_FONT:
	case SMALL_ITALIC_FONT:
		return FONT_CAP_HEIGHT * SMALL_FONT_SIZE / 2048;
	}
}

function
get_descent(font_num)
{
	switch (font_num) {
	case ROMAN_FONT:
	case ITALIC_FONT:
		return FONT_DESCENT * FONT_SIZE / 2048;
	case SMALL_ROMAN_FONT:
	case SMALL_ITALIC_FONT:
		return FONT_DESCENT * SMALL_FONT_SIZE / 2048;
	}
}

const roman_descent_tab = [

	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,

//	  ! " # $ % & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ?
	0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,

//	@ A B C D E F G H I J K L M N O P Q R S T U V W X Y Z [   ] ^ _
	1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,

//	` a b c d e f g h i j k l m n o p q r s t u v w x y z { | } ~
	0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,1,1,1,0,0,

	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, // upper case greek
	0,1,1,0,0,1,1,0,0,0,0,1,0,1,0,0,1,0,0,0,1,1,1,0, // lower case greek

	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
];

const italic_descent_tab = [

	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,

//	  ! " # $ % & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ?
	0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,

//	@ A B C D E F G H I J K L M N O P Q R S T U V W X Y Z [   ] ^ _
	1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,

//	` a b c d e f g h i j k l m n o p q r s t u v w x y z { | } ~
	0,0,0,0,0,0,1,1,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,1,1,1,0,0,

	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, // upper case greek
	0,1,1,0,0,1,1,0,0,0,0,1,0,1,0,0,1,0,0,0,1,1,1,0, // lower case greek

	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
];

function
get_char_depth(font_num, char_num)
{
	switch (font_num) {
	case ROMAN_FONT:
	case SMALL_ROMAN_FONT:
		return get_descent(font_num) * roman_descent_tab[char_num];
	case ITALIC_FONT:
	case SMALL_ITALIC_FONT:
		return get_descent(font_num) * italic_descent_tab[char_num];
	}
}

const roman_width_tab = [

909,909,909,909,909,909,909,909,
909,909,909,909,909,909,909,909,
909,909,909,909,909,909,909,909,
909,909,909,909,909,909,909,909,

512,682,836,1024,1024,1706,1593,369,		// printable ascii
682,682,1024,1155,512,682,512,569,
1024,1024,1024,1024,1024,1024,1024,1024,
1024,1024,569,569,1155,1155,1155,909,
1886,1479,1366,1366,1479,1251,1139,1479,
1479,682,797,1479,1251,1821,1479,1479,
1139,1479,1366,1139,1251,1479,1479,1933,
1479,1479,1251,682,569,682,961,1024,
682,909,1024,909,1024,909,682,1024,
1024,569,569,1024,569,1593,1024,1024,
1024,1024,682,797,569,1024,1024,1479,
1024,1024,909,983,410,983,1108,1593,

1479,1366,1184,1253,1251,1251,1479,1479,	// upper case greek
682,1479,1485,1821,1479,1317,1479,1479,
1139,1192,1251,1479,1497,1479,1511,1522,

1073,1042,905,965,860,848,1071,981,		// lower case greek
551,1032,993,1098,926,913,1024,1034,
1022,1104,823,1014,1182,909,1282,1348,

1024,1155,1155,1155,1124,1124,1012,909,		// other symbols

909,909,909,909,909,909,909,909,
909,909,909,909,909,909,909,909,
909,909,909,909,909,909,909,909,
909,909,909,909,909,909,909,909,
909,909,909,909,909,909,909,909,
909,909,909,909,909,909,909,909,
909,909,909,909,909,909,909,909,
909,909,909,909,909,909,909,909,
909,909,909,909,909,909,909,909,
];

const italic_width_tab = [

1024,1024,1024,1024,1024,1024,1024,1024,
1024,1024,1024,1024,1024,1024,1024,1024,
1024,1024,1024,1024,1024,1024,1024,1024,
1024,1024,1024,1024,1024,1024,1024,1024,

512,682,860,1024,1024,1706,1593,438,		// printable ascii
682,682,1024,1382,512,682,512,569,
1024,1024,1024,1024,1024,1024,1024,1024,
1024,1024,682,682,1382,1382,1382,1024,
1884,1251,1251,1366,1479,1251,1251,1479,
1479,682,909,1366,1139,1706,1366,1479,
1251,1479,1251,1024,1139,1479,1251,1706,
1251,1139,1139,797,569,797,864,1024,
682,1024,1024,909,1024,909,569,1024,
1024,569,569,909,569,1479,1024,1024,
1024,1024,797,797,569,1024,909,1366,
909,909,797,819,563,819,1108,1593,

1251,1251,1165,1253,1251,1139,1479,1479,	// upper case greek
682,1366,1237,1706,1366,1309,1479,1479,
1251,1217,1139,1139,1559,1251,1440,1481,

1075,1020,807,952,807,829,1016,1006,		// lower case greek
569,983,887,1028,909,877,1024,1026,
983,1010,733,940,1133,901,1272,1446,

1024,1382,1382,1382,1124,1124,1012,1024,	// other symbols

1024,1024,1024,1024,1024,1024,1024,1024,
1024,1024,1024,1024,1024,1024,1024,1024,
1024,1024,1024,1024,1024,1024,1024,1024,
1024,1024,1024,1024,1024,1024,1024,1024,
1024,1024,1024,1024,1024,1024,1024,1024,
1024,1024,1024,1024,1024,1024,1024,1024,
1024,1024,1024,1024,1024,1024,1024,1024,
1024,1024,1024,1024,1024,1024,1024,1024,
1024,1024,1024,1024,1024,1024,1024,1024,
];

function
get_char_width(font_num, char_num)
{
	switch (font_num) {
	case ROMAN_FONT:
		return FONT_SIZE * roman_width_tab[char_num] / 2048;
	case ITALIC_FONT:
		return FONT_SIZE * italic_width_tab[char_num] / 2048;
	case SMALL_ROMAN_FONT:
		return SMALL_FONT_SIZE * roman_width_tab[char_num] / 2048;
	case SMALL_ITALIC_FONT:
		return SMALL_FONT_SIZE * italic_width_tab[char_num] / 2048;
	}
}

function
get_xheight(font_num)
{
	switch (font_num) {
	case ROMAN_FONT:
	case ITALIC_FONT:
		return FONT_XHEIGHT * FONT_SIZE / 2048;
	case SMALL_ROMAN_FONT:
	case SMALL_ITALIC_FONT:
		return FONT_XHEIGHT * SMALL_FONT_SIZE / 2048;
	}
}

function
get_operator_height(font_num)
{
	return get_cap_height(font_num) / 2;
}
