/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.exception;

import java.sql.SQLException;
import org.flywaydb.core.api.CoreErrorCode;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.util.ExceptionUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class FlywaySqlException
extends FlywayException {
    private final String sqlState;
    private final int sqlErrorCode;

    public FlywaySqlException(String message, SQLException sqlException) {
        super(message, sqlException, CoreErrorCode.DB_CONNECTION);
        this.sqlState = sqlException.getSQLState();
        this.sqlErrorCode = sqlException.getErrorCode();
    }

    @Override
    public String getMessage() {
        String title = super.getMessage();
        String underline = StringUtils.trimOrPad("", title.length(), '-');
        return title + "\n" + underline + "\n" + ExceptionUtils.toMessage((SQLException)this.getCause());
    }

    public String getSqlState() {
        return this.sqlState;
    }

    public int getSqlErrorCode() {
        return this.sqlErrorCode;
    }
}

