/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.secretsmanager.util;

import com.amazonaws.secretsmanager.util.Config;
import java.net.URI;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.utils.StringUtils;

public class JDBCSecretCacheBuilderProvider {
    static final String PROPERTY_VPC_ENDPOINT_URL = "vpcEndpointUrl";
    static final String PROPERTY_VPC_ENDPOINT_REGION = "vpcEndpointRegion";
    static final String PROPERTY_REGION = "region";
    static final String REGION_ENVIRONMENT_VARIABLE = "AWS_SECRET_JDBC_REGION";
    private Config configFile;

    public JDBCSecretCacheBuilderProvider() {
        this(Config.loadMainConfig());
    }

    public JDBCSecretCacheBuilderProvider(Config config) {
        this.configFile = config;
    }

    public SecretsManagerClientBuilder build() {
        SecretsManagerClientBuilder builder = SecretsManagerClient.builder();
        String vpcEndpointUrl = this.configFile.getStringPropertyWithDefault("drivers.vpcEndpointUrl", null);
        String vpcEndpointRegion = this.configFile.getStringPropertyWithDefault("drivers.vpcEndpointRegion", null);
        String envRegion = System.getenv(REGION_ENVIRONMENT_VARIABLE);
        String configRegion = this.configFile.getStringPropertyWithDefault("drivers.region", null);
        if (StringUtils.isNotBlank((CharSequence)vpcEndpointUrl) && StringUtils.isNotBlank((CharSequence)vpcEndpointRegion)) {
            ((SecretsManagerClientBuilder)builder.endpointOverride(URI.create(vpcEndpointUrl))).region(Region.of((String)vpcEndpointRegion));
        } else if (StringUtils.isNotBlank((CharSequence)envRegion)) {
            builder.region(Region.of((String)envRegion));
        } else if (StringUtils.isNotBlank((CharSequence)configRegion)) {
            builder.region(Region.of((String)configRegion));
        }
        return builder;
    }
}

