/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc.internal;

import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;

@InternalApi
public final class ApiCallContextOptions {
    private final ImmutableMap<ApiCallContext.Key, Object> options;
    private static final ApiCallContextOptions DEFAULT_OPTIONS = new ApiCallContextOptions((ImmutableMap<ApiCallContext.Key, Object>)ImmutableMap.of());

    private ApiCallContextOptions(ImmutableMap<ApiCallContext.Key, Object> options) {
        this.options = (ImmutableMap)Preconditions.checkNotNull(options);
    }

    public static ApiCallContextOptions getDefaultOptions() {
        return DEFAULT_OPTIONS;
    }

    public <T> ApiCallContextOptions withOption(ApiCallContext.Key<T> key, T value) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (!this.options.containsKey(key)) {
            builder.putAll(this.options).put(key, value);
        } else {
            builder.put(key, value);
            for (ApiCallContext.Key oldKey : this.options.keySet()) {
                if (oldKey.equals(key)) continue;
                builder.put((Object)oldKey, this.options.get((Object)oldKey));
            }
        }
        return new ApiCallContextOptions((ImmutableMap<ApiCallContext.Key, Object>)builder.build());
    }

    public <T> T getOption(ApiCallContext.Key<T> key) {
        Preconditions.checkNotNull(key);
        return (T)this.options.get(key);
    }

    public ApiCallContextOptions merge(ApiCallContextOptions newOptions) {
        Preconditions.checkNotNull((Object)newOptions);
        ImmutableMap.Builder builder = ImmutableMap.builder().putAll(newOptions.options);
        for (ApiCallContext.Key key : this.options.keySet()) {
            if (newOptions.options.containsKey((Object)key)) continue;
            builder.put((Object)key, this.options.get((Object)key));
        }
        return new ApiCallContextOptions((ImmutableMap<ApiCallContext.Key, Object>)builder.build());
    }
}

