/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc;

import com.ing.data.cassandra.jdbc.AbstractConnection;
import com.ing.data.cassandra.jdbc.CassandraConnection;
import com.ing.data.cassandra.jdbc.ManagedPreparedStatement;
import com.ing.data.cassandra.jdbc.PooledCassandraConnection;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLTimeoutException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

class ManagedConnection
extends AbstractConnection
implements Connection {
    private PooledCassandraConnection pooledCassandraConnection;
    private CassandraConnection physicalConnection;
    private final Set<Statement> statements = new HashSet<Statement>();

    ManagedConnection(PooledCassandraConnection pooledCassandraConnection) {
        this.pooledCassandraConnection = pooledCassandraConnection;
        this.physicalConnection = pooledCassandraConnection.getConnection();
    }

    private void checkNotClosed() throws SQLNonTransientConnectionException {
        if (this.isClosed()) {
            throw new SQLNonTransientConnectionException("Method was called on a closed Connection.");
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkNotClosed();
        try {
            this.physicalConnection.clearWarnings();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.connectionErrorOccurred(sqlException);
            throw sqlException;
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        for (Statement statement : this.statements) {
            if (statement.isClosed()) continue;
            statement.close();
        }
        this.pooledCassandraConnection.connectionClosed();
        this.pooledCassandraConnection = null;
        this.physicalConnection = null;
    }

    @Override
    public void commit() throws SQLException {
        this.checkNotClosed();
        try {
            this.physicalConnection.commit();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.connectionErrorOccurred(sqlException);
            throw sqlException;
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkNotClosed();
        Statement statement = this.physicalConnection.createStatement();
        this.statements.add(statement);
        return statement;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkNotClosed();
        Statement statement = this.physicalConnection.createStatement(resultSetType, resultSetConcurrency);
        this.statements.add(statement);
        return statement;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkNotClosed();
        Statement statement = this.physicalConnection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        this.statements.add(statement);
        return statement;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkNotClosed();
        try {
            return this.physicalConnection.getAutoCommit();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.connectionErrorOccurred(sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkNotClosed();
        try {
            this.physicalConnection.setAutoCommit(autoCommit);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.connectionErrorOccurred(sqlException);
            throw sqlException;
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkNotClosed();
        try {
            return this.physicalConnection.getCatalog();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.connectionErrorOccurred(sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkNotClosed();
        try {
            this.physicalConnection.setCatalog(catalog);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.connectionErrorOccurred(sqlException);
            throw sqlException;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkNotClosed();
        try {
            return this.physicalConnection.getClientInfo();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.connectionErrorOccurred(sqlException);
            throw sqlException;
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkNotClosed();
        try {
            return this.physicalConnection.getClientInfo(name);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.connectionErrorOccurred(sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setClientInfo(Properties properties) {
        if (!this.isClosed()) {
            this.physicalConnection.setClientInfo(properties);
        }
    }

    @Override
    public void setClientInfo(String name, String value) {
        if (!this.isClosed()) {
            this.physicalConnection.setClientInfo(name, value);
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkNotClosed();
        try {
            return this.physicalConnection.getHoldability();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.connectionErrorOccurred(sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkNotClosed();
        try {
            this.physicalConnection.setHoldability(holdability);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.connectionErrorOccurred(sqlException);
            throw sqlException;
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkNotClosed();
        try {
            return this.physicalConnection.getMetaData();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.connectionErrorOccurred(sqlException);
            throw sqlException;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkNotClosed();
        try {
            return this.physicalConnection.isReadOnly();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.connectionErrorOccurred(sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkNotClosed();
        try {
            this.physicalConnection.setReadOnly(readOnly);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.connectionErrorOccurred(sqlException);
            throw sqlException;
        }
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkNotClosed();
        try {
            return this.physicalConnection.getSchema();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.connectionErrorOccurred(sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkNotClosed();
        try {
            this.physicalConnection.setSchema(schema);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.connectionErrorOccurred(sqlException);
            throw sqlException;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkNotClosed();
        try {
            return this.physicalConnection.getTransactionIsolation();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.connectionErrorOccurred(sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkNotClosed();
        try {
            this.physicalConnection.setTransactionIsolation(level);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.connectionErrorOccurred(sqlException);
            throw sqlException;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkNotClosed();
        try {
            return this.physicalConnection.getTypeMap();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.connectionErrorOccurred(sqlException);
            throw sqlException;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkNotClosed();
        try {
            return this.physicalConnection.getWarnings();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.connectionErrorOccurred(sqlException);
            throw sqlException;
        }
    }

    @Override
    public boolean isClosed() {
        return this.physicalConnection == null;
    }

    @Override
    public boolean isValid(int timeout) throws SQLTimeoutException {
        return this.physicalConnection.isValid(timeout);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkNotClosed();
        try {
            return this.physicalConnection.nativeSQL(sql);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.connectionErrorOccurred(sqlException);
            throw sqlException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String cql) throws SQLException {
        this.checkNotClosed();
        ManagedPreparedStatement statement = this.pooledCassandraConnection.prepareStatement(this, cql);
        this.statements.add(statement);
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public void rollback() throws SQLException {
        this.checkNotClosed();
        try {
            this.physicalConnection.rollback();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.connectionErrorOccurred(sqlException);
            throw sqlException;
        }
    }
}

