import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Box, Text } from 'ink';
import { theme } from '../semantic-colors.js';
import { useConfig } from '../contexts/ConfigContext.js';
import { ToolConfirmationMessage } from './messages/ToolConfirmationMessage.js';
import { ToolStatusIndicator, ToolInfo } from './messages/ToolShared.js';
import { useUIState } from '../contexts/UIStateContext.js';
import { OverflowProvider } from '../contexts/OverflowContext.js';
import { ShowMoreLines } from './ShowMoreLines.js';
import { StickyHeader } from './StickyHeader.js';
import { useAlternateBuffer } from '../hooks/useAlternateBuffer.js';
export const ToolConfirmationQueue = ({ confirmingTool, }) => {
    const config = useConfig();
    const isAlternateBuffer = useAlternateBuffer();
    const { mainAreaWidth, terminalHeight, constrainHeight } = useUIState();
    const { tool, index, total } = confirmingTool;
    // Safety check: ToolConfirmationMessage requires confirmationDetails
    if (!tool.confirmationDetails)
        return null;
    // V1: Constrain the queue to at most 50% of the terminal height to ensure
    // some history is always visible and to prevent flickering.
    // We pass this to ToolConfirmationMessage so it can calculate internal
    // truncation while keeping buttons visible.
    const maxHeight = Math.floor(terminalHeight * 0.5);
    // ToolConfirmationMessage needs to know the height available for its OWN content.
    // We subtract the lines used by the Queue wrapper:
    // - 2 lines for the rounded border
    // - 2 lines for the Header (text + margin)
    // - 2 lines for Tool Identity (text + margin)
    const availableContentHeight = constrainHeight && !isAlternateBuffer
        ? Math.max(maxHeight - 6, 4)
        : undefined;
    const borderColor = theme.status.warning;
    return (_jsxs(OverflowProvider, { children: [_jsxs(Box, { flexDirection: "column", width: mainAreaWidth, flexShrink: 0, children: [_jsx(StickyHeader, { width: mainAreaWidth, isFirst: true, borderColor: borderColor, borderDimColor: false, children: _jsxs(Box, { flexDirection: "column", width: mainAreaWidth - 4, children: [_jsxs(Box, { marginBottom: 1, justifyContent: "space-between", children: [_jsx(Text, { color: theme.status.warning, bold: true, children: "Action Required" }), _jsxs(Text, { color: theme.text.secondary, children: [index, " of ", total] })] }), _jsxs(Box, { children: [_jsx(ToolStatusIndicator, { status: tool.status, name: tool.name }), _jsx(ToolInfo, { name: tool.name, status: tool.status, description: tool.description, emphasis: "high" })] })] }) }), _jsx(Box, { width: mainAreaWidth, borderStyle: "round", borderColor: borderColor, borderTop: false, borderBottom: false, borderLeft: true, borderRight: true, paddingX: 1, flexDirection: "column", children: _jsx(ToolConfirmationMessage, { callId: tool.callId, confirmationDetails: tool.confirmationDetails, config: config, terminalWidth: mainAreaWidth - 4, availableTerminalHeight: availableContentHeight, isFocused: true }) }), _jsx(Box, { height: 0, width: mainAreaWidth, borderLeft: true, borderRight: true, borderTop: false, borderBottom: true, borderColor: borderColor, borderStyle: "round" })] }), _jsx(Box, { paddingX: 2, marginBottom: 1, children: _jsx(ShowMoreLines, { constrainHeight: constrainHeight }) })] }));
};
//# sourceMappingURL=ToolConfirmationQueue.js.map