/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.lisa.pcode.contexts;

import ghidra.program.model.pcode.PcodeOp;

public class ConditionContext extends PcodeContext {

	public ConditionContext(PcodeOp op) {
		super(op);
	}

	public VarnodeContext expression() {
		// opcode should be CBRANCH
		assert (op.getInputs().length < 2);
		return new VarnodeContext(op.getInput(1));
	}

}
