!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubetools_help_tool
  use gbl_message
  use cubetools_parameters
  use cubetools_cmessaging
  !---------------------------------------------------------------------
  ! This module provides methods to display help lines, i.e. lines
  ! with severity xxxseve%help. This is usually trigerred by a command
  ! help (e.g. VIEW ?) or the COLLECT command. Such lines can go either
  ! to screen or to a file (may be with a specific format like Tex or
  ! Markdown)
  !---------------------------------------------------------------------
  !
  type :: help_tool_t
  contains
    procedure, public, nopass :: message    => cubetools_help_message
    procedure, public, nopass :: open_file  => cubetools_help_open_file
    procedure, public, nopass :: close_file => cubetools_help_close_file
  end type help_tool_t
  !
  integer(kind=code_k), parameter :: sevehelp=999  ! Value must not clash with the other seve%
  integer(kind=4) :: help_lun = 0
  !
  public :: help_tool_t,sevehelp
  private
  !
contains
  !
  subroutine cubetools_help_message(message_id,procname,message)
    !-------------------------------------------------------------------
    !
    !-------------------------------------------------------------------
    integer(kind=4),  intent(in) :: message_id
    character(len=*), intent(in) :: procname
    character(len=*), intent(in) :: message
    !
    if (help_lun.ne.0) then
      write(help_lun,'(A)')  trim(message)
    else
      call cubetools_cmessage(message_id,seve%r,procname,message)
    endif
  end subroutine cubetools_help_message
  !
  subroutine cubetools_help_open_file(file,error)
    use gkernel_interfaces
    use gpack_def
    !-------------------------------------------------------------------
    ! Open the file where toolseve%help messages will be redirected
    ! as long as the file is not closed.
    ! If the file is closed, these messages go to the terminal.
    !-------------------------------------------------------------------
    character(len=*), intent(in)    :: file
    logical,          intent(inout) :: error
    !
    integer(kind=4) :: ier
    character(len=*), parameter :: rname='HELP>OPEN>FILE'
    !
    ier = sic_getlun(help_lun)
    if (ier.ne.1) then
      call cubetools_cmessage(gpack_global_id,seve%e,rname,'No logical unit left')
      error = .true.
      return
    endif
    ier = sic_open(help_lun,file,'NEW',.false.)
    if (ier.ne.0) then
      call cubetools_cmessage(gpack_global_id,seve%e,rname,'Cannot open file '//file)
      error = .true.
      call sic_frelun(help_lun)
      return
    endif
  end subroutine cubetools_help_open_file
  !
  subroutine cubetools_help_close_file(error)
    use gkernel_interfaces
    !-------------------------------------------------------------------
    !
    !-------------------------------------------------------------------
    logical, intent(inout) :: error
    !
    integer(kind=4) :: ier
    character(len=*), parameter :: rname='HELP>CLOSE>FILE'
    !
    ier = sic_close(help_lun)
    call sic_frelun(help_lun)
    help_lun = 0
  end subroutine cubetools_help_close_file
end module cubetools_help_tool
