/***************************************************************************
                          nullgdl.cpp  -  class for GDL !NULL
                             -------------------
    begin                : July 22 2002
    copyright            : (C) 2002 by Marc Schellens
    email                : m_schellens@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "nullgdl.hpp"
#include "dinterpreter.hpp"

using namespace std;

char NullGDL::buf[sizeof(NullGDL)];

NullGDL* NullGDL::instance = NULL;

/**
 * @brief as GetParString of EnvT but directly from BaseGDL if possible
 * @return 
 */
const std::string NullGDL::GetParString() {
  EnvUDT* caller = interpreter->CallStackBack();
  int i = caller->findvar(this);
  DString parString = "!NULL";
  if (i > 0) parString = caller->GetParString(i);
  return parString;
}

NullGDL::~NullGDL()
{
// Nulling "instance" will recreate !NULL correctly.
  instance=NULL;
}

NullGDL* NullGDL::GetSingleInstance() {
  if (instance == NULL) instance = new (NullGDL::buf) NullGDL();
  return instance;
}

bool NullGDL::IsAssoc() const { return false;}
  
BaseGDL* NullGDL::AssocVar( int, SizeT)
{
  throw GDLException("NullGDL::AssocVar(...) called.");
}

SizeT NullGDL::N_Elements() const 
{
  return 0;
}
SizeT NullGDL::Size() const { return 0;}
SizeT NullGDL::ToTransfer() const { return 0;}
SizeT NullGDL::Sizeof() const { return 0;}
SizeT NullGDL::NBytes() const { return 0;} // for assoc function

BaseGDL& NullGDL::operator=(const BaseGDL& right)
{
  return *this;
}
BaseGDL& NullGDL::operator<<=(const BaseGDL& right)
{
  throw GDLException("NullGDL::operator<<=(const BaseGDL& right) called.");
}
void  NullGDL::InitFrom(const BaseGDL& right)
{
  throw GDLException("NullGDL::InitFrom(const BaseGDL& right) called.");
}


// BaseGDL* NullGDL::Abs() const
// {
//   throw GDLException("NullGDL::Abs() called.");
// }

bool NullGDL::Greater(SizeT i1, SizeT i2) const
{
  throw GDLException("NullGDL::Greater(SizeT,SizeT) called.");
}
bool NullGDL::Equal(SizeT i1, SizeT i2) const
{
  throw GDLException("NullGDL::Equal(SizeT,SizeT) called.");
}

BaseGDL* NullGDL::CShift( DLong d) const
{
  throw GDLException("NullGDL::CShift(...) called.");
}
BaseGDL* NullGDL::CShift( DLong d[MAXRANK]) const
{
  throw GDLException("NullGDL::CShift( DLong d[MAXRANK]) called.");
}

  
BaseGDL* NullGDL::Transpose( DUInt* perm)
{
  throw GDLException("NullGDL::Transpose(...) called.");
}

void NullGDL::MinMax( DLong* minE, DLong* maxE, 
		      BaseGDL** minVal, BaseGDL** maxVal, bool omitNaN,
              SizeT start, SizeT stop, SizeT step, DLong valIx, bool useAbs)
{
  throw GDLException("NullGDL::MinMax(...) called.");
}

void NullGDL::Clear() 
{
  throw GDLException("NullGDL::Clear() called.");
}
void NullGDL::Construct() 
{
  throw GDLException("NullGDL::Construct() called.");
}
void NullGDL::ConstructTo0() 
{
  throw GDLException("NullGDL::ConstructTo0() called.");
}
void NullGDL::Destruct() 
{
  throw GDLException("NullGDL::Destruct() called.");
}

void NullGDL::Assign( BaseGDL* src, SizeT nEl)
{
  throw GDLException("NullGDL::Assign(...) called.");
}

std::ostream& NullGDL::Write( std::ostream& os, bool swapEndian, 
			      bool compress, XDR *xdrs)
{
  throw GDLException("NullGDL::Write(...) called.");
}
std::istream& NullGDL::Read( std::istream& os, bool swapEndian, 
			     bool compress, XDR *xdrs)
{
  throw GDLException("NullGDL::Read(...) called.");
}

std::ostream& NullGDL::ToStream(std::ostream& o, SizeT width, 
				SizeT* actPosPtr )
{
  o << "!NULL";
  return o;
}
std::istream& NullGDL::FromStream(std::istream& i)
{
  i >> *this;
  return i;
}

bool NullGDL::Scalar() const { return false;}
bool NullGDL::StrictScalar() const { return false;}
DType   NullGDL::Type() const { return GDL_UNDEF;}
int   NullGDL::SizeOfType() const { return sizeof(void*);}
const std::string& NullGDL::TypeStr() const
{ static const std::string s("UNDEFINED"); return s;}
bool NullGDL::EqType( const BaseGDL*) const
{
  throw GDLException("NullGDL::EqType(...) called.");
}

void* NullGDL::DataAddr()// SizeT elem)
{
  return buf; //throw GDLException("NullGDL::DataAddr(...) called.");
}
  
// make same type on the heap
BaseGDL* NullGDL::New( const dimension& dim_, InitType noZero) const
{
  return NullGDL::GetSingleInstance();
}
BaseGDL* NullGDL::NewResult() const
{
  return NullGDL::GetSingleInstance();
}

BaseGDL* NullGDL::Dup() const
{ 
  return NullGDL::GetSingleInstance();
}
// BaseGDL* NullGDL::Dup( void*) const 
// { 
//   throw GDLException("NullGDL::Dup(...) called.");
// }

BaseGDL* NullGDL::Convert2( DType destTy, Convert2Mode mode)
{
  if( destTy == GDL_STRING)
    return new DStringGDL( "!NULL");
  throw GDLException("Variable is undefined: "+GetParString());  
}

BaseGDL* NullGDL::GetTag() const 
{
  throw GDLException("!NULL not allowed in tag definition.");
}

BaseGDL* NullGDL::GetInstance() const
{
  throw GDLException("NullGDL::GetInstance(...) called.");
}
BaseGDL* NullGDL::GetEmptyInstance() const
{
  throw GDLException("NullGDL::GetEmptyInstance(...) called.");
}
BaseGDL* NullGDL::SetBuffer( const void* b)
{
  throw GDLException("NullGDL::SetBuffer called.");
}
void NullGDL::SetBufferSize( SizeT s)
{
  throw GDLException("NullGDL::SetBufferSize called.");
}

int NullGDL::Scalar2Index(SizeT& ret) const 
{ 
  throw GDLException("Operation not defined for !NULL 1.");
}
int NullGDL::Scalar2RangeT(RangeT& ret) const
{ 
  throw GDLException("Operation not defined for !NULL 1a.");
}

SizeT NullGDL::GetAsIndex( SizeT i) const
{ 
  throw GDLException("NullGDL::GetAsIndex called.");
}
SizeT NullGDL::GetAsIndexStrict( SizeT i) const
{ 
  throw GDLException("NullGDL::GetAsIndexStrict called.");
}

#ifdef _MSC_VER
bool NullGDL::True()
#else
bool NullGDL::NullGDL::True()
#endif
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 3.");
}

#ifdef _MSC_VER
bool NullGDL::False()
#else
bool NullGDL::NullGDL::False()
#endif
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 4.");
}

bool NullGDL::LogTrue()
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 4a.");
}

bool NullGDL::LogTrue( SizeT ix)
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 4b.");
}
void NullGDL::Where(DLong* &ret, SizeT &passed_count, bool comp, DLong* &comp_ret)
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 4b.");
}
void NullGDL::Where(DLong64* &ret, SizeT &passed_count, bool comp, DLong64* &comp_ret)
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 4b.");
}

BaseGDL* NullGDL::LogNeg()
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 4c.");
}

int NullGDL::Sgn() // -1,0,1
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 5.");
}

bool NullGDL::Equal( BaseGDL*) const
{
  throw GDLException("Operation not defined for !NULL 6.");
}

bool NullGDL::EqualNoDelete( const BaseGDL*) const
{
  throw GDLException("Operation not defined for !NULL 6a.");
}

bool NullGDL::ArrayEqual( BaseGDL*)
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 6b.");
}

// for statement compliance (int types , float types scalar only)
bool NullGDL::ForCheck( BaseGDL**, BaseGDL**)
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 7.");
  return false;
}

bool NullGDL::ForCondUp( BaseGDL*)
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 8.");
}

bool NullGDL::ForAddCondUp( BaseGDL* loopInfo)
// bool NullGDL::ForAddCondUp( ForLoopInfoT& loopInfo)
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 8a.");
}

bool NullGDL::ForCondDown( BaseGDL*)
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 9.");
}

// bool NullGDL::ForCondUpDown( BaseGDL*)
// {
//   throw GDLException("Operation not defined for "+GetParString()+" - !NULL 9a.");
// }

void NullGDL::ForAdd( BaseGDL* add)
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 10.");
}

BaseGDL* NullGDL::CatArray( ExprListT& exprList,
			    const SizeT catRank, 
			    const SizeT rank) 
{
  throw GDLException("NullGDL::CatArray(...) called.");
}

BaseGDL* NullGDL::Index( ArrayIndexListT* ixList) 
{
  throw GDLException("NullGDL::Index(...) called.");
}

// used in r_expr
BaseGDL* NullGDL::UMinus()              
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 11.");
}

BaseGDL* NullGDL::NotOp()               
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 12.");
}

BaseGDL* NullGDL::AndOp( BaseGDL* r)    
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 13.");
}

BaseGDL* NullGDL::AndOpInv( BaseGDL* r) 
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 14.");
}

BaseGDL* NullGDL::OrOp( BaseGDL* r)    
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 13.");
}

BaseGDL* NullGDL::OrOpInv( BaseGDL* r) 
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 14.");
}

BaseGDL* NullGDL::XorOp( BaseGDL* r)    
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 13.");
}

BaseGDL* NullGDL::XorOpS( BaseGDL* r)    
{
  throw GDLException("XOR: Operation not defined for !NULL.");
}

BaseGDL* NullGDL::EqOp( BaseGDL* r)    
{
  if( (r == NULL) || (r == NullGDL::GetSingleInstance()))
  {
    return new Data_<SpDByte>( 1);
  }
  // check for null object and pointer
  DType rTy= r->Type();
  if( rTy == GDL_PTR)
  {
    DPtrGDL* rP = static_cast<DPtrGDL*>(r);
    DPtr pVal;
    if( rP->Scalar( pVal) ) {
      if (pVal==0) return new Data_<SpDByte>( 1);
      return new DByteGDL( !interpreter->PtrValid( pVal ));
      }
  }
  //following never happens since comparison with !NULL is never done in this direction, it is always converted to !NULL eq something in AdjustTypesNCNull
  else if( rTy == GDL_OBJ)
  {
    DObjGDL* rP = static_cast<DObjGDL*>(r);
    DObj pVal;
    if( rP->Scalar( pVal)) {
      if (pVal==0) return new Data_<SpDByte>( 1);
      return new DByteGDL( !interpreter->ObjValid( pVal ));
      }
  }
  return new Data_<SpDByte>( 0);
}

BaseGDL* NullGDL::NeOp( BaseGDL* r)    
{
  if( (r == NULL) || (r == NullGDL::GetSingleInstance()))
  {
    return new Data_<SpDByte>( 0);
  }
  // check for null opject and pointer
  DType rTy= r->Type();
  if( rTy == GDL_PTR)
  {
    DPtrGDL* rP = static_cast<DPtrGDL*>(r);
    DPtr pVal;
    if( rP->Scalar( pVal) && pVal == 0)
      return new Data_<SpDByte>( 0);
  }
  else if( rTy == GDL_OBJ)
  {
    DObjGDL* rP = static_cast<DObjGDL*>(r);
    DObj pVal;
    if( rP->Scalar( pVal) && pVal == 0)
      return new Data_<SpDByte>( 0);
  }
  return new Data_<SpDByte>( 1);
}

BaseGDL* NullGDL::LeOp( BaseGDL* r)    
{
  throw GDLException("LE: Operation not defined for !NULL.");
}

BaseGDL* NullGDL::GeOp( BaseGDL* r)    
{
  throw GDLException("GE: Operation not defined for !NULL.");
}

BaseGDL* NullGDL::LtOp( BaseGDL* r)    
{
  throw GDLException("LT: Operation not defined for !NULL.");
}

BaseGDL* NullGDL::GtOp( BaseGDL* r)    
{
  throw GDLException("GT: Operation not defined for !NULL.");
}

BaseGDL* NullGDL::Add( BaseGDL* r)      
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 15.");
}
BaseGDL* NullGDL::AddInv( BaseGDL* r)      
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 15.");
}

BaseGDL* NullGDL::Sub( BaseGDL* r)      
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 16.");
}
BaseGDL* NullGDL::SubInv( BaseGDL* r)   
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 17.");
}

BaseGDL* NullGDL::LtMark( BaseGDL* r)   
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 18.");
}

BaseGDL* NullGDL::GtMark( BaseGDL* r)   
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 19.");
}

BaseGDL* NullGDL::Mult( BaseGDL* r)   
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 19a.");
}

BaseGDL* NullGDL::Div( BaseGDL* r)      
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 16.");
}
BaseGDL* NullGDL::DivInv( BaseGDL* r)   
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 17.");
}

BaseGDL* NullGDL::Mod( BaseGDL* r)      
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 16.");
}
BaseGDL* NullGDL::ModInv( BaseGDL* r)   
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 17.");
}

BaseGDL* NullGDL::Pow( BaseGDL* r)      
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 16.");
}
BaseGDL* NullGDL::PowInv( BaseGDL* r)   
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 17.");
}
BaseGDL* NullGDL::PowInt( BaseGDL* r)      
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 170.");
}

BaseGDL* NullGDL::MatrixOp( BaseGDL* r, bool atranspose, bool btranspose)
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 18.");
}

void NullGDL::AssignAt( BaseGDL* srcIn,	ArrayIndexListT* ixList, SizeT offset)
{
  throw GDLException("NullGDL::AssignAt(...) called.");
}
void NullGDL::AssignAt( BaseGDL* srcIn, ArrayIndexListT* ixList)
{
  throw GDLException("NullGDL::AssignAt(..) called.");
}
void NullGDL::AssignAt( BaseGDL* srcIn)
{
  throw GDLException("NullGDL::AssignAt(.) called.");
}

void NullGDL::DecAt( ArrayIndexListT* ixList)
{
  throw GDLException("NullGDL::DecAt(...) called.");
}
void NullGDL::IncAt( ArrayIndexListT* ixList)
{
  throw GDLException("NullGDL::IncAt(...) called.");
}
void NullGDL::Dec()
{
  throw GDLException("NullGDL::Dec(...) called.");
}
void NullGDL::Inc()
{
  throw GDLException("NullGDL::Inc(...) called.");
}

void NullGDL::InsertAt(  SizeT offset, BaseGDL* srcIn, ArrayIndexListT* ixList)
{
  throw GDLException("NullGDL::InsertAt( SizeT, ...) called.");
}

// formatting output functions
SizeT NullGDL::OFmtA( std::ostream* os, SizeT offset, SizeT num, int width)
{throw GDLException("NullGDL::OFmtA(...) called.");}

SizeT NullGDL::OFmtF( std::ostream* os, SizeT offs, SizeT num, int width, int prec, const int code, const BaseGDL::IOMode oM) 
{throw GDLException("NullGDL::OFmtF(...) called.");}

SizeT NullGDL::OFmtI( std::ostream* os, SizeT offs, SizeT num, int width, int minN, int code, BaseGDL::IOMode oM)
{throw GDLException("NullGDL::OFmtI(...) called.");}

SizeT NullGDL::IFmtCal( std::istream* is, SizeT offs, SizeT r, int width, BaseGDL::Cal_IOMode cMode)
{throw GDLException("NullGDL::IFmtCal(...) called.");}

SizeT NullGDL::OFmtCal( std::ostream* os, SizeT offs, SizeT num, int width,
			int minN, const std::string &s, NullGDL::Cal_IOMode cM)
{throw GDLException("NullGDL::OFmtCal(...) called.");}
          
SizeT NullGDL::IFmtA( std::istream* is, SizeT offset, SizeT num, int width)
{throw GDLException("NullGDL::IFmtA(...) called.");}

SizeT NullGDL::IFmtF( std::istream* is, SizeT offs, SizeT num, int width)
{throw GDLException("NullGDL::IFmtF(...) called.");}

SizeT NullGDL::IFmtI( std::istream* is, SizeT offs, SizeT num, int width, 
		      NullGDL::IOMode oM)
{throw GDLException("NullGDL::IFmtI(...) called.");}

BaseGDL* NullGDL::Convol( BaseGDL* kIn, BaseGDL* scaleIn, BaseGDL* bias,
		          bool center, bool normalize, int edgeMode,
                          bool doNan, BaseGDL* missing, bool doMissing,
                          BaseGDL* invalid, bool doInvalid, DDouble edgeVal)
{
  throw GDLException("NullGDL::Convol(...) called.");
}
BaseGDL* NullGDL::Smooth( DLong* width, int edgeMode,
                          bool doNan, BaseGDL* missing)
{
  throw GDLException("NullGDL::Smooth(...) called.");
}
BaseGDL* NullGDL::Rebin( const dimension& newDim, bool sample)
{
  throw GDLException("NullGDL::Rebin(...) called.");
}

#ifdef USE_PYTHON
PyObject* NullGDL::ToPython()
{throw GDLException("NullGDL::ToPython(...) called.");}
#endif





BaseGDL* NullGDL::AndOpS( BaseGDL* r)    
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 13.");
}

BaseGDL* NullGDL::AndOpInvS( BaseGDL* r) 
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 14.");
}

BaseGDL* NullGDL::OrOpS( BaseGDL* r)    
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 13.");
}

BaseGDL* NullGDL::OrOpInvS( BaseGDL* r) 
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 14.");
}

BaseGDL* NullGDL::AddS( BaseGDL* r)      
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 15.");
}
BaseGDL* NullGDL::AddInvS( BaseGDL* r)      
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 15.");
}

BaseGDL* NullGDL::SubS( BaseGDL* r)      
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 16.");
}
BaseGDL* NullGDL::SubInvS( BaseGDL* r)   
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 17.");
}

BaseGDL* NullGDL::LtMarkS( BaseGDL* r)   
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 18.");
}

BaseGDL* NullGDL::GtMarkS( BaseGDL* r)   
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 19.");
}

BaseGDL* NullGDL::MultS( BaseGDL* r)   
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 19a.");
}

BaseGDL* NullGDL::DivS( BaseGDL* r)
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 16.");
}
BaseGDL* NullGDL::DivInvS( BaseGDL* r)   
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 17.");
}

BaseGDL* NullGDL::ModS( BaseGDL* r)      
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 16.");
}
BaseGDL* NullGDL::ModInvS( BaseGDL* r)   
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 17.");
}

BaseGDL* NullGDL::PowS( BaseGDL* r)      
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 16.");
}
BaseGDL* NullGDL::PowInvS( BaseGDL* r)   
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 17.");
}

BaseGDL* NullGDL::NewIx( SizeT ix)
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 20.");
}
BaseGDL* NullGDL::NewIx( BaseGDL* ix, bool strict)
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 21.");
}
BaseGDL* NullGDL::NewIx( AllIxBaseT* ix, const dimension* dIn)
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 22.");
}
BaseGDL* NullGDL::NewIxFrom( SizeT s)
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 23.");
}
BaseGDL* NullGDL::NewIxFrom( SizeT s, SizeT e)
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 24.");
}
BaseGDL* NullGDL::NewIxFromStride( SizeT s, SizeT stride)
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 25.");
}
BaseGDL* NullGDL::NewIxFromStride( SizeT s, SizeT e, SizeT stride)
{
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 26.");
}
BaseGDL* NullGDL::Log()              
{ 
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 27a.");
}
BaseGDL* NullGDL::LogThis()              
{ 
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 27b.");
}
BaseGDL* NullGDL::Log10()              
{ 
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 27c.");
}
BaseGDL* NullGDL::Log10This()              
{ 
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 27d.");
}

void NullGDL::AssignAtIx( RangeT ix, BaseGDL* srcIn)
{ 
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 28.");
}

RangeT NullGDL::LoopIndex() const
{ 
  throw GDLException("Operation not defined for !NULL 29.");
}
DDouble NullGDL::HashValue() const
{ 
  throw GDLException("Operation not defined for !NULL 29a.");
}

BaseGDL* NullGDL::Rotate( DLong dir)
{ 
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 30.");
}

void NullGDL::Reverse( DLong dim)
{ 
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 31.");
}

BaseGDL* NullGDL::DupReverse( DLong dim)
{ 
  throw GDLException("Operation not defined for "+GetParString()+" - !NULL 32.");
}

  BaseGDL* NullGDL::AndOpNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 40.");}
  BaseGDL* NullGDL::AndOpInvNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 41.");}
  BaseGDL* NullGDL::OrOpNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 42.");}
  BaseGDL* NullGDL::OrOpInvNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 43.");}
  BaseGDL* NullGDL::XorOpNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 44.");}
//   BaseGDL* NullGDL::EqOpNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 45.");}
//   BaseGDL* NullGDL::NeOpNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 46.");}
//   BaseGDL* NullGDL::LeOpNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 47.");}
//   BaseGDL* NullGDL::GeOpNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 48.");}
//   BaseGDL* NullGDL::LtOpNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 49.");}
//   BaseGDL* NullGDL::GtOpNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 50.");}
  BaseGDL* NullGDL::AddNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 51.");}       // implemented
  BaseGDL* NullGDL::AddInvNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 52.");}       // implemented
  BaseGDL* NullGDL::SubNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 53.");}
  BaseGDL* NullGDL::SubInvNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 54.");}
  BaseGDL* NullGDL::LtMarkNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 55.");}
  BaseGDL* NullGDL::GtMarkNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 56.");}
  BaseGDL* NullGDL::MultNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 57.");}    // implemented
  BaseGDL* NullGDL::DivNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 58.");}
  BaseGDL* NullGDL::DivInvNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 59.");}
  BaseGDL* NullGDL::ModNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 60.");}
  BaseGDL* NullGDL::ModInvNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 61.");}
  BaseGDL* NullGDL::PowNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 62.");}
  BaseGDL* NullGDL::PowInvNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 63.");}
  BaseGDL* NullGDL::PowIntNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 64.");}    // implemented

  BaseGDL* NullGDL::AndOpSNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 65.");}
  BaseGDL* NullGDL::AndOpInvSNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 66.");}
  BaseGDL* NullGDL::OrOpSNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 67.");}
  BaseGDL* NullGDL::OrOpInvSNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 68.");}
  BaseGDL* NullGDL::XorOpSNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 69.");}
  BaseGDL* NullGDL::AddSNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 70.");}          // implemented
  BaseGDL* NullGDL::AddInvSNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 71.");}     // implemented
  BaseGDL* NullGDL::SubSNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 73.");}
  BaseGDL* NullGDL::SubInvSNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 74.");}
  BaseGDL* NullGDL::LtMarkSNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 75.");}
  BaseGDL* NullGDL::GtMarkSNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 76.");}
  BaseGDL* NullGDL::MultSNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 77.");}       // implemented
  BaseGDL* NullGDL::DivSNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 78.");}
  BaseGDL* NullGDL::DivInvSNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 79.");}
  BaseGDL* NullGDL::ModSNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 80.");}
  BaseGDL* NullGDL::ModInvSNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 81.");}
  BaseGDL* NullGDL::PowSNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 82.");}
  BaseGDL* NullGDL::PowInvSNew( BaseGDL* r) { throw GDLException("Operation not defined for "+GetParString()+" - !NULL 83.");}
