//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armapimanagement_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/apimanagement/armapimanagement/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementListTemplates.json
func ExampleEmailTemplateClient_NewListByServicePager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewEmailTemplateClient().NewListByServicePager("rg1", "apimService1", &armapimanagement.EmailTemplateClientListByServiceOptions{Filter: nil,
		Top:  nil,
		Skip: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.EmailTemplateCollection = armapimanagement.EmailTemplateCollection{
		// 	Count: to.Ptr[int64](1),
		// 	Value: []*armapimanagement.EmailTemplateContract{
		// 		{
		// 			Name: to.Ptr("ApplicationApprovedNotificationMessage"),
		// 			Type: to.Ptr("Microsoft.ApiManagement/service/templates"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/templates/ApplicationApprovedNotificationMessage"),
		// 			Properties: &armapimanagement.EmailTemplateContractProperties{
		// 				Description: to.Ptr("Developers who submitted their application for publication in the application gallery on the developer portal receive this email after their submission is approved."),
		// 				Body: to.Ptr("<!DOCTYPE html >\r\n<html>\r\n  <head />\r\n  <body>\r\n    <p style=\"font-size:12pt;font-family:'Segoe UI'\">Dear $DevFirstName $DevLastName,</p>\r\n    <p style=\"font-size:12pt;font-family:'Segoe UI'\">\r\n          We are happy to let you know that your request to publish the $AppName application in the application gallery has been approved. Your application has been published and can be viewed <a href=\"http://$DevPortalUrl/Applications/Details/$AppId\">here</a>.\r\n        </p>\r\n    <p style=\"font-size:12pt;font-family:'Segoe UI'\">Best,</p>\r\n    <p style=\"font-size:12pt;font-family:'Segoe UI'\">The $OrganizationName API Team</p>\r\n  </body>\r\n</html>"),
		// 				IsDefault: to.Ptr(true),
		// 				Parameters: []*armapimanagement.EmailTemplateParametersContractProperties{
		// 					{
		// 						Name: to.Ptr("AppId"),
		// 						Title: to.Ptr("Application id"),
		// 					},
		// 					{
		// 						Name: to.Ptr("AppName"),
		// 						Title: to.Ptr("Application name"),
		// 					},
		// 					{
		// 						Name: to.Ptr("DevFirstName"),
		// 						Title: to.Ptr("Developer first name"),
		// 					},
		// 					{
		// 						Name: to.Ptr("DevLastName"),
		// 						Title: to.Ptr("Developer last name"),
		// 					},
		// 					{
		// 						Name: to.Ptr("OrganizationName"),
		// 						Title: to.Ptr("Organization name"),
		// 					},
		// 					{
		// 						Name: to.Ptr("DevPortalUrl"),
		// 						Title: to.Ptr("Developer portal URL"),
		// 				}},
		// 				Subject: to.Ptr("Your application $AppName is published in the application gallery"),
		// 				Title: to.Ptr("Application gallery submission approved"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementHeadEmailTemplate.json
func ExampleEmailTemplateClient_GetEntityTag() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewEmailTemplateClient().GetEntityTag(ctx, "rg1", "apimService1", armapimanagement.TemplateNameNewIssueNotificationMessage, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementGetTemplate.json
func ExampleEmailTemplateClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewEmailTemplateClient().Get(ctx, "rg1", "apimService1", armapimanagement.TemplateNameNewIssueNotificationMessage, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.EmailTemplateContract = armapimanagement.EmailTemplateContract{
	// 	Name: to.Ptr("NewIssueNotificationMessage"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service/templates"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/templates/NewIssueNotificationMessage"),
	// 	Properties: &armapimanagement.EmailTemplateContractProperties{
	// 		Description: to.Ptr("This email is sent to developers after they create a new topic on the Issues page of the developer portal."),
	// 		Body: to.Ptr("<!DOCTYPE html >\r\n<html>\r\n  <head />\r\n  <body>\r\n    <p style=\"font-size:12pt;font-family:'Segoe UI'\">Dear $DevFirstName $DevLastName,</p>\r\n    <p style=\"font-size:12pt;font-family:'Segoe UI'\">Thank you for contacting us. Our API team will review your issue and get back to you soon.</p>\r\n    <p style=\"font-size:12pt;font-family:'Segoe UI'\">\r\n          Click this <a href=\"http://$DevPortalUrl/issues/$IssueId\">link</a> to view or edit your request.\r\n        </p>\r\n    <p style=\"font-size:12pt;font-family:'Segoe UI'\">Best,</p>\r\n    <p style=\"font-size:12pt;font-family:'Segoe UI'\">The $OrganizationName API Team</p>\r\n  </body>\r\n</html>"),
	// 		IsDefault: to.Ptr(true),
	// 		Parameters: []*armapimanagement.EmailTemplateParametersContractProperties{
	// 			{
	// 				Name: to.Ptr("DevFirstName"),
	// 				Title: to.Ptr("Developer first name"),
	// 			},
	// 			{
	// 				Name: to.Ptr("DevLastName"),
	// 				Title: to.Ptr("Developer last name"),
	// 			},
	// 			{
	// 				Name: to.Ptr("IssueId"),
	// 				Title: to.Ptr("Issue id"),
	// 			},
	// 			{
	// 				Name: to.Ptr("IssueName"),
	// 				Title: to.Ptr("Issue name"),
	// 			},
	// 			{
	// 				Name: to.Ptr("OrganizationName"),
	// 				Title: to.Ptr("Organization name"),
	// 			},
	// 			{
	// 				Name: to.Ptr("DevPortalUrl"),
	// 				Title: to.Ptr("Developer portal URL"),
	// 		}},
	// 		Subject: to.Ptr("Your request $IssueName was received"),
	// 		Title: to.Ptr("New issue received"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementCreateTemplate.json
func ExampleEmailTemplateClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewEmailTemplateClient().CreateOrUpdate(ctx, "rg1", "apimService1", armapimanagement.TemplateNameNewIssueNotificationMessage, armapimanagement.EmailTemplateUpdateParameters{
		Properties: &armapimanagement.EmailTemplateUpdateParameterProperties{
			Subject: to.Ptr("Your request for $IssueName was successfully received."),
		},
	}, &armapimanagement.EmailTemplateClientCreateOrUpdateOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.EmailTemplateContract = armapimanagement.EmailTemplateContract{
	// 	Name: to.Ptr("NewIssueNotificationMessage"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service/templates"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/templates/NewIssueNotificationMessage"),
	// 	Properties: &armapimanagement.EmailTemplateContractProperties{
	// 		Description: to.Ptr("This email is sent to developers after they create a new topic on the Issues page of the developer portal."),
	// 		Body: to.Ptr("<!DOCTYPE html >\r\n<html>\r\n  <head />\r\n  <body>\r\n    <p style=\"font-size:12pt;font-family:'Segoe UI'\">Dear $DevFirstName $DevLastName,</p>\r\n    <p style=\"font-size:12pt;font-family:'Segoe UI'\">Thank you for contacting us. Our API team will review your issue and get back to you soon.</p>\r\n    <p style=\"font-size:12pt;font-family:'Segoe UI'\">\r\n          Click this <a href=\"http://$DevPortalUrl/issues/$IssueId\">link</a> to view or edit your request.\r\n        </p>\r\n    <p style=\"font-size:12pt;font-family:'Segoe UI'\">Best,</p>\r\n    <p style=\"font-size:12pt;font-family:'Segoe UI'\">The $OrganizationName API Team</p>\r\n  </body>\r\n</html>"),
	// 		IsDefault: to.Ptr(false),
	// 		Parameters: []*armapimanagement.EmailTemplateParametersContractProperties{
	// 			{
	// 				Name: to.Ptr("DevFirstName"),
	// 				Title: to.Ptr("Developer first name"),
	// 			},
	// 			{
	// 				Name: to.Ptr("DevLastName"),
	// 				Title: to.Ptr("Developer last name"),
	// 			},
	// 			{
	// 				Name: to.Ptr("IssueId"),
	// 				Title: to.Ptr("Issue id"),
	// 			},
	// 			{
	// 				Name: to.Ptr("IssueName"),
	// 				Title: to.Ptr("Issue name"),
	// 			},
	// 			{
	// 				Name: to.Ptr("OrganizationName"),
	// 				Title: to.Ptr("Organization name"),
	// 			},
	// 			{
	// 				Name: to.Ptr("DevPortalUrl"),
	// 				Title: to.Ptr("Developer portal URL"),
	// 		}},
	// 		Subject: to.Ptr("Your request for $IssueName was successfully received."),
	// 		Title: to.Ptr("New issue received"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementUpdateTemplate.json
func ExampleEmailTemplateClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewEmailTemplateClient().Update(ctx, "rg1", "apimService1", armapimanagement.TemplateNameNewIssueNotificationMessage, "*", armapimanagement.EmailTemplateUpdateParameters{
		Properties: &armapimanagement.EmailTemplateUpdateParameterProperties{
			Body:    to.Ptr("<!DOCTYPE html >\r\n<html>\r\n  <head />\r\n  <body>\r\n    <p style=\"font-size:12pt;font-family:'Segoe UI'\">Dear $DevFirstName $DevLastName,</p>\r\n    <p style=\"font-size:12pt;font-family:'Segoe UI'\">\r\n          We are happy to let you know that your request to publish the $AppName application in the gallery has been approved. Your application has been published and can be viewed <a href=\"http://$DevPortalUrl/Applications/Details/$AppId\">here</a>.\r\n        </p>\r\n    <p style=\"font-size:12pt;font-family:'Segoe UI'\">Best,</p>\r\n    <p style=\"font-size:12pt;font-family:'Segoe UI'\">The $OrganizationName API Team</p>\r\n  </body>\r\n</html>"),
			Subject: to.Ptr("Your request $IssueName was received"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.EmailTemplateContract = armapimanagement.EmailTemplateContract{
	// 	Name: to.Ptr("NewIssueNotificationMessage"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service/templates"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/templates/NewIssueNotificationMessage"),
	// 	Properties: &armapimanagement.EmailTemplateContractProperties{
	// 		Description: to.Ptr("This email is sent to developers after they create a new topic on the Issues page of the developer portal."),
	// 		Body: to.Ptr("<!DOCTYPE html >\r\n<html>\r\n  <head />\r\n  <body>\r\n    <p style=\"font-size:12pt;font-family:'Segoe UI'\">Dear $DevFirstName $DevLastName,</p>\r\n    <p style=\"font-size:12pt;font-family:'Segoe UI'\">Thank you for contacting us. Our API team will review your issue and get back to you soon.</p>\r\n    <p style=\"font-size:12pt;font-family:'Segoe UI'\">\r\n          Click this <a href=\"http://$DevPortalUrl/issues/$IssueId\">link</a> to view or edit your request.\r\n        </p>\r\n    <p style=\"font-size:12pt;font-family:'Segoe UI'\">Best,</p>\r\n    <p style=\"font-size:12pt;font-family:'Segoe UI'\">The $OrganizationName API Team</p>\r\n  </body>\r\n</html>"),
	// 		IsDefault: to.Ptr(true),
	// 		Parameters: []*armapimanagement.EmailTemplateParametersContractProperties{
	// 			{
	// 				Name: to.Ptr("DevFirstName"),
	// 				Title: to.Ptr("Developer first name"),
	// 			},
	// 			{
	// 				Name: to.Ptr("DevLastName"),
	// 				Title: to.Ptr("Developer last name"),
	// 			},
	// 			{
	// 				Name: to.Ptr("IssueId"),
	// 				Title: to.Ptr("Issue id"),
	// 			},
	// 			{
	// 				Name: to.Ptr("IssueName"),
	// 				Title: to.Ptr("Issue name"),
	// 			},
	// 			{
	// 				Name: to.Ptr("OrganizationName"),
	// 				Title: to.Ptr("Organization name"),
	// 			},
	// 			{
	// 				Name: to.Ptr("DevPortalUrl"),
	// 				Title: to.Ptr("Developer portal URL"),
	// 		}},
	// 		Subject: to.Ptr("Your request $IssueName was received"),
	// 		Title: to.Ptr("New issue received"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementDeleteTemplate.json
func ExampleEmailTemplateClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewEmailTemplateClient().Delete(ctx, "rg1", "apimService1", armapimanagement.TemplateNameNewIssueNotificationMessage, "*", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}
