//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appplatform/armappplatform/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ConfigServersServer is a fake server for instances of the armappplatform.ConfigServersClient type.
type ConfigServersServer struct {
	// Get is the fake for method ConfigServersClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, serviceName string, options *armappplatform.ConfigServersClientGetOptions) (resp azfake.Responder[armappplatform.ConfigServersClientGetResponse], errResp azfake.ErrorResponder)

	// BeginUpdatePatch is the fake for method ConfigServersClient.BeginUpdatePatch
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdatePatch func(ctx context.Context, resourceGroupName string, serviceName string, configServerResource armappplatform.ConfigServerResource, options *armappplatform.ConfigServersClientBeginUpdatePatchOptions) (resp azfake.PollerResponder[armappplatform.ConfigServersClientUpdatePatchResponse], errResp azfake.ErrorResponder)

	// BeginUpdatePut is the fake for method ConfigServersClient.BeginUpdatePut
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdatePut func(ctx context.Context, resourceGroupName string, serviceName string, configServerResource armappplatform.ConfigServerResource, options *armappplatform.ConfigServersClientBeginUpdatePutOptions) (resp azfake.PollerResponder[armappplatform.ConfigServersClientUpdatePutResponse], errResp azfake.ErrorResponder)

	// BeginValidate is the fake for method ConfigServersClient.BeginValidate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginValidate func(ctx context.Context, resourceGroupName string, serviceName string, configServerSettings armappplatform.ConfigServerSettings, options *armappplatform.ConfigServersClientBeginValidateOptions) (resp azfake.PollerResponder[armappplatform.ConfigServersClientValidateResponse], errResp azfake.ErrorResponder)
}

// NewConfigServersServerTransport creates a new instance of ConfigServersServerTransport with the provided implementation.
// The returned ConfigServersServerTransport instance is connected to an instance of armappplatform.ConfigServersClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewConfigServersServerTransport(srv *ConfigServersServer) *ConfigServersServerTransport {
	return &ConfigServersServerTransport{
		srv:              srv,
		beginUpdatePatch: newTracker[azfake.PollerResponder[armappplatform.ConfigServersClientUpdatePatchResponse]](),
		beginUpdatePut:   newTracker[azfake.PollerResponder[armappplatform.ConfigServersClientUpdatePutResponse]](),
		beginValidate:    newTracker[azfake.PollerResponder[armappplatform.ConfigServersClientValidateResponse]](),
	}
}

// ConfigServersServerTransport connects instances of armappplatform.ConfigServersClient to instances of ConfigServersServer.
// Don't use this type directly, use NewConfigServersServerTransport instead.
type ConfigServersServerTransport struct {
	srv              *ConfigServersServer
	beginUpdatePatch *tracker[azfake.PollerResponder[armappplatform.ConfigServersClientUpdatePatchResponse]]
	beginUpdatePut   *tracker[azfake.PollerResponder[armappplatform.ConfigServersClientUpdatePutResponse]]
	beginValidate    *tracker[azfake.PollerResponder[armappplatform.ConfigServersClientValidateResponse]]
}

// Do implements the policy.Transporter interface for ConfigServersServerTransport.
func (c *ConfigServersServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ConfigServersClient.Get":
		resp, err = c.dispatchGet(req)
	case "ConfigServersClient.BeginUpdatePatch":
		resp, err = c.dispatchBeginUpdatePatch(req)
	case "ConfigServersClient.BeginUpdatePut":
		resp, err = c.dispatchBeginUpdatePut(req)
	case "ConfigServersClient.BeginValidate":
		resp, err = c.dispatchBeginValidate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *ConfigServersServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/configServers/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), resourceGroupNameParam, serviceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ConfigServerResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ConfigServersServerTransport) dispatchBeginUpdatePatch(req *http.Request) (*http.Response, error) {
	if c.srv.BeginUpdatePatch == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdatePatch not implemented")}
	}
	beginUpdatePatch := c.beginUpdatePatch.get(req)
	if beginUpdatePatch == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/configServers/default`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappplatform.ConfigServerResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginUpdatePatch(req.Context(), resourceGroupNameParam, serviceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdatePatch = &respr
		c.beginUpdatePatch.add(req, beginUpdatePatch)
	}

	resp, err := server.PollerResponderNext(beginUpdatePatch, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginUpdatePatch.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdatePatch) {
		c.beginUpdatePatch.remove(req)
	}

	return resp, nil
}

func (c *ConfigServersServerTransport) dispatchBeginUpdatePut(req *http.Request) (*http.Response, error) {
	if c.srv.BeginUpdatePut == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdatePut not implemented")}
	}
	beginUpdatePut := c.beginUpdatePut.get(req)
	if beginUpdatePut == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/configServers/default`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappplatform.ConfigServerResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginUpdatePut(req.Context(), resourceGroupNameParam, serviceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdatePut = &respr
		c.beginUpdatePut.add(req, beginUpdatePut)
	}

	resp, err := server.PollerResponderNext(beginUpdatePut, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginUpdatePut.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdatePut) {
		c.beginUpdatePut.remove(req)
	}

	return resp, nil
}

func (c *ConfigServersServerTransport) dispatchBeginValidate(req *http.Request) (*http.Response, error) {
	if c.srv.BeginValidate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginValidate not implemented")}
	}
	beginValidate := c.beginValidate.get(req)
	if beginValidate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/configServers/validate`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappplatform.ConfigServerSettings](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginValidate(req.Context(), resourceGroupNameParam, serviceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginValidate = &respr
		c.beginValidate.add(req, beginValidate)
	}

	resp, err := server.PollerResponderNext(beginValidate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginValidate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginValidate) {
		c.beginValidate.remove(req)
	}

	return resp, nil
}
