//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/authorization/armauthorization/v3"
	"net/http"
	"net/url"
	"regexp"
)

// ScopeAccessReviewInstanceDecisionsServer is a fake server for instances of the armauthorization.ScopeAccessReviewInstanceDecisionsClient type.
type ScopeAccessReviewInstanceDecisionsServer struct {
	// NewListPager is the fake for method ScopeAccessReviewInstanceDecisionsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(scope string, scheduleDefinitionID string, id string, options *armauthorization.ScopeAccessReviewInstanceDecisionsClientListOptions) (resp azfake.PagerResponder[armauthorization.ScopeAccessReviewInstanceDecisionsClientListResponse])
}

// NewScopeAccessReviewInstanceDecisionsServerTransport creates a new instance of ScopeAccessReviewInstanceDecisionsServerTransport with the provided implementation.
// The returned ScopeAccessReviewInstanceDecisionsServerTransport instance is connected to an instance of armauthorization.ScopeAccessReviewInstanceDecisionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewScopeAccessReviewInstanceDecisionsServerTransport(srv *ScopeAccessReviewInstanceDecisionsServer) *ScopeAccessReviewInstanceDecisionsServerTransport {
	return &ScopeAccessReviewInstanceDecisionsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armauthorization.ScopeAccessReviewInstanceDecisionsClientListResponse]](),
	}
}

// ScopeAccessReviewInstanceDecisionsServerTransport connects instances of armauthorization.ScopeAccessReviewInstanceDecisionsClient to instances of ScopeAccessReviewInstanceDecisionsServer.
// Don't use this type directly, use NewScopeAccessReviewInstanceDecisionsServerTransport instead.
type ScopeAccessReviewInstanceDecisionsServerTransport struct {
	srv          *ScopeAccessReviewInstanceDecisionsServer
	newListPager *tracker[azfake.PagerResponder[armauthorization.ScopeAccessReviewInstanceDecisionsClientListResponse]]
}

// Do implements the policy.Transporter interface for ScopeAccessReviewInstanceDecisionsServerTransport.
func (s *ScopeAccessReviewInstanceDecisionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ScopeAccessReviewInstanceDecisionsClient.NewListPager":
		resp, err = s.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *ScopeAccessReviewInstanceDecisionsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := s.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/accessReviewScheduleDefinitions/(?P<scheduleDefinitionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<id>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/decisions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
		if err != nil {
			return nil, err
		}
		scheduleDefinitionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scheduleDefinitionId")])
		if err != nil {
			return nil, err
		}
		idParam, err := url.PathUnescape(matches[regex.SubexpIndex("id")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armauthorization.ScopeAccessReviewInstanceDecisionsClientListOptions
		if filterParam != nil {
			options = &armauthorization.ScopeAccessReviewInstanceDecisionsClientListOptions{
				Filter: filterParam,
			}
		}
		resp := s.srv.NewListPager(scopeParam, scheduleDefinitionIDParam, idParam, options)
		newListPager = &resp
		s.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armauthorization.ScopeAccessReviewInstanceDecisionsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		s.newListPager.remove(req)
	}
	return resp, nil
}
