//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/automanage/armautomanage"
	"net/http"
	"net/url"
	"regexp"
)

// BestPracticesVersionsServer is a fake server for instances of the armautomanage.BestPracticesVersionsClient type.
type BestPracticesVersionsServer struct {
	// Get is the fake for method BestPracticesVersionsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, bestPracticeName string, versionName string, options *armautomanage.BestPracticesVersionsClientGetOptions) (resp azfake.Responder[armautomanage.BestPracticesVersionsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByTenantPager is the fake for method BestPracticesVersionsClient.NewListByTenantPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByTenantPager func(bestPracticeName string, options *armautomanage.BestPracticesVersionsClientListByTenantOptions) (resp azfake.PagerResponder[armautomanage.BestPracticesVersionsClientListByTenantResponse])
}

// NewBestPracticesVersionsServerTransport creates a new instance of BestPracticesVersionsServerTransport with the provided implementation.
// The returned BestPracticesVersionsServerTransport instance is connected to an instance of armautomanage.BestPracticesVersionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewBestPracticesVersionsServerTransport(srv *BestPracticesVersionsServer) *BestPracticesVersionsServerTransport {
	return &BestPracticesVersionsServerTransport{
		srv:                  srv,
		newListByTenantPager: newTracker[azfake.PagerResponder[armautomanage.BestPracticesVersionsClientListByTenantResponse]](),
	}
}

// BestPracticesVersionsServerTransport connects instances of armautomanage.BestPracticesVersionsClient to instances of BestPracticesVersionsServer.
// Don't use this type directly, use NewBestPracticesVersionsServerTransport instead.
type BestPracticesVersionsServerTransport struct {
	srv                  *BestPracticesVersionsServer
	newListByTenantPager *tracker[azfake.PagerResponder[armautomanage.BestPracticesVersionsClientListByTenantResponse]]
}

// Do implements the policy.Transporter interface for BestPracticesVersionsServerTransport.
func (b *BestPracticesVersionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "BestPracticesVersionsClient.Get":
		resp, err = b.dispatchGet(req)
	case "BestPracticesVersionsClient.NewListByTenantPager":
		resp, err = b.dispatchNewListByTenantPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (b *BestPracticesVersionsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if b.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Automanage/bestPractices/(?P<bestPracticeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/versions/(?P<versionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	bestPracticeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("bestPracticeName")])
	if err != nil {
		return nil, err
	}
	versionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("versionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.Get(req.Context(), bestPracticeNameParam, versionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BestPractice, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (b *BestPracticesVersionsServerTransport) dispatchNewListByTenantPager(req *http.Request) (*http.Response, error) {
	if b.srv.NewListByTenantPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByTenantPager not implemented")}
	}
	newListByTenantPager := b.newListByTenantPager.get(req)
	if newListByTenantPager == nil {
		const regexStr = `/providers/Microsoft\.Automanage/bestPractices/(?P<bestPracticeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/versions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		bestPracticeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("bestPracticeName")])
		if err != nil {
			return nil, err
		}
		resp := b.srv.NewListByTenantPager(bestPracticeNameParam, nil)
		newListByTenantPager = &resp
		b.newListByTenantPager.add(req, newListByTenantPager)
	}
	resp, err := server.PagerResponderNext(newListByTenantPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		b.newListByTenantPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByTenantPager) {
		b.newListByTenantPager.remove(req)
	}
	return resp, nil
}
