//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/automation/armautomation"
	"net/http"
	"net/url"
	"regexp"
)

// FieldsServer is a fake server for instances of the armautomation.FieldsClient type.
type FieldsServer struct {
	// NewListByTypePager is the fake for method FieldsClient.NewListByTypePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByTypePager func(resourceGroupName string, automationAccountName string, moduleName string, typeName string, options *armautomation.FieldsClientListByTypeOptions) (resp azfake.PagerResponder[armautomation.FieldsClientListByTypeResponse])
}

// NewFieldsServerTransport creates a new instance of FieldsServerTransport with the provided implementation.
// The returned FieldsServerTransport instance is connected to an instance of armautomation.FieldsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewFieldsServerTransport(srv *FieldsServer) *FieldsServerTransport {
	return &FieldsServerTransport{
		srv:                srv,
		newListByTypePager: newTracker[azfake.PagerResponder[armautomation.FieldsClientListByTypeResponse]](),
	}
}

// FieldsServerTransport connects instances of armautomation.FieldsClient to instances of FieldsServer.
// Don't use this type directly, use NewFieldsServerTransport instead.
type FieldsServerTransport struct {
	srv                *FieldsServer
	newListByTypePager *tracker[azfake.PagerResponder[armautomation.FieldsClientListByTypeResponse]]
}

// Do implements the policy.Transporter interface for FieldsServerTransport.
func (f *FieldsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "FieldsClient.NewListByTypePager":
		resp, err = f.dispatchNewListByTypePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (f *FieldsServerTransport) dispatchNewListByTypePager(req *http.Request) (*http.Response, error) {
	if f.srv.NewListByTypePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByTypePager not implemented")}
	}
	newListByTypePager := f.newListByTypePager.get(req)
	if newListByTypePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/modules/(?P<moduleName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/types/(?P<typeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/fields`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
		if err != nil {
			return nil, err
		}
		moduleNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("moduleName")])
		if err != nil {
			return nil, err
		}
		typeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("typeName")])
		if err != nil {
			return nil, err
		}
		resp := f.srv.NewListByTypePager(resourceGroupNameParam, automationAccountNameParam, moduleNameParam, typeNameParam, nil)
		newListByTypePager = &resp
		f.newListByTypePager.add(req, newListByTypePager)
	}
	resp, err := server.PagerResponderNext(newListByTypePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		f.newListByTypePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByTypePager) {
		f.newListByTypePager.remove(req)
	}
	return resp, nil
}
