//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/cdn/armcdn/v2"
	"net/http"
)

// EdgeNodesServer is a fake server for instances of the armcdn.EdgeNodesClient type.
type EdgeNodesServer struct {
	// NewListPager is the fake for method EdgeNodesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armcdn.EdgeNodesClientListOptions) (resp azfake.PagerResponder[armcdn.EdgeNodesClientListResponse])
}

// NewEdgeNodesServerTransport creates a new instance of EdgeNodesServerTransport with the provided implementation.
// The returned EdgeNodesServerTransport instance is connected to an instance of armcdn.EdgeNodesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewEdgeNodesServerTransport(srv *EdgeNodesServer) *EdgeNodesServerTransport {
	return &EdgeNodesServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armcdn.EdgeNodesClientListResponse]](),
	}
}

// EdgeNodesServerTransport connects instances of armcdn.EdgeNodesClient to instances of EdgeNodesServer.
// Don't use this type directly, use NewEdgeNodesServerTransport instead.
type EdgeNodesServerTransport struct {
	srv          *EdgeNodesServer
	newListPager *tracker[azfake.PagerResponder[armcdn.EdgeNodesClientListResponse]]
}

// Do implements the policy.Transporter interface for EdgeNodesServerTransport.
func (e *EdgeNodesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "EdgeNodesClient.NewListPager":
		resp, err = e.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (e *EdgeNodesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := e.newListPager.get(req)
	if newListPager == nil {
		resp := e.srv.NewListPager(nil)
		newListPager = &resp
		e.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armcdn.EdgeNodesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		e.newListPager.remove(req)
	}
	return resp, nil
}
