//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/dataprotection/armdataprotection/v3"
	"net/http"
	"net/url"
	"regexp"
)

// BackupVaultsServer is a fake server for instances of the armdataprotection.BackupVaultsClient type.
type BackupVaultsServer struct {
	// CheckNameAvailability is the fake for method BackupVaultsClient.CheckNameAvailability
	// HTTP status codes to indicate success: http.StatusOK
	CheckNameAvailability func(ctx context.Context, resourceGroupName string, location string, parameters armdataprotection.CheckNameAvailabilityRequest, options *armdataprotection.BackupVaultsClientCheckNameAvailabilityOptions) (resp azfake.Responder[armdataprotection.BackupVaultsClientCheckNameAvailabilityResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdate is the fake for method BackupVaultsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, vaultName string, parameters armdataprotection.BackupVaultResource, options *armdataprotection.BackupVaultsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armdataprotection.BackupVaultsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method BackupVaultsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, vaultName string, options *armdataprotection.BackupVaultsClientBeginDeleteOptions) (resp azfake.PollerResponder[armdataprotection.BackupVaultsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method BackupVaultsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, vaultName string, options *armdataprotection.BackupVaultsClientGetOptions) (resp azfake.Responder[armdataprotection.BackupVaultsClientGetResponse], errResp azfake.ErrorResponder)

	// NewGetInResourceGroupPager is the fake for method BackupVaultsClient.NewGetInResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetInResourceGroupPager func(resourceGroupName string, options *armdataprotection.BackupVaultsClientGetInResourceGroupOptions) (resp azfake.PagerResponder[armdataprotection.BackupVaultsClientGetInResourceGroupResponse])

	// NewGetInSubscriptionPager is the fake for method BackupVaultsClient.NewGetInSubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetInSubscriptionPager func(options *armdataprotection.BackupVaultsClientGetInSubscriptionOptions) (resp azfake.PagerResponder[armdataprotection.BackupVaultsClientGetInSubscriptionResponse])

	// BeginUpdate is the fake for method BackupVaultsClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, vaultName string, parameters armdataprotection.PatchResourceRequestInput, options *armdataprotection.BackupVaultsClientBeginUpdateOptions) (resp azfake.PollerResponder[armdataprotection.BackupVaultsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewBackupVaultsServerTransport creates a new instance of BackupVaultsServerTransport with the provided implementation.
// The returned BackupVaultsServerTransport instance is connected to an instance of armdataprotection.BackupVaultsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewBackupVaultsServerTransport(srv *BackupVaultsServer) *BackupVaultsServerTransport {
	return &BackupVaultsServerTransport{
		srv:                        srv,
		beginCreateOrUpdate:        newTracker[azfake.PollerResponder[armdataprotection.BackupVaultsClientCreateOrUpdateResponse]](),
		beginDelete:                newTracker[azfake.PollerResponder[armdataprotection.BackupVaultsClientDeleteResponse]](),
		newGetInResourceGroupPager: newTracker[azfake.PagerResponder[armdataprotection.BackupVaultsClientGetInResourceGroupResponse]](),
		newGetInSubscriptionPager:  newTracker[azfake.PagerResponder[armdataprotection.BackupVaultsClientGetInSubscriptionResponse]](),
		beginUpdate:                newTracker[azfake.PollerResponder[armdataprotection.BackupVaultsClientUpdateResponse]](),
	}
}

// BackupVaultsServerTransport connects instances of armdataprotection.BackupVaultsClient to instances of BackupVaultsServer.
// Don't use this type directly, use NewBackupVaultsServerTransport instead.
type BackupVaultsServerTransport struct {
	srv                        *BackupVaultsServer
	beginCreateOrUpdate        *tracker[azfake.PollerResponder[armdataprotection.BackupVaultsClientCreateOrUpdateResponse]]
	beginDelete                *tracker[azfake.PollerResponder[armdataprotection.BackupVaultsClientDeleteResponse]]
	newGetInResourceGroupPager *tracker[azfake.PagerResponder[armdataprotection.BackupVaultsClientGetInResourceGroupResponse]]
	newGetInSubscriptionPager  *tracker[azfake.PagerResponder[armdataprotection.BackupVaultsClientGetInSubscriptionResponse]]
	beginUpdate                *tracker[azfake.PollerResponder[armdataprotection.BackupVaultsClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for BackupVaultsServerTransport.
func (b *BackupVaultsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "BackupVaultsClient.CheckNameAvailability":
		resp, err = b.dispatchCheckNameAvailability(req)
	case "BackupVaultsClient.BeginCreateOrUpdate":
		resp, err = b.dispatchBeginCreateOrUpdate(req)
	case "BackupVaultsClient.BeginDelete":
		resp, err = b.dispatchBeginDelete(req)
	case "BackupVaultsClient.Get":
		resp, err = b.dispatchGet(req)
	case "BackupVaultsClient.NewGetInResourceGroupPager":
		resp, err = b.dispatchNewGetInResourceGroupPager(req)
	case "BackupVaultsClient.NewGetInSubscriptionPager":
		resp, err = b.dispatchNewGetInSubscriptionPager(req)
	case "BackupVaultsClient.BeginUpdate":
		resp, err = b.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (b *BackupVaultsServerTransport) dispatchCheckNameAvailability(req *http.Request) (*http.Response, error) {
	if b.srv.CheckNameAvailability == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckNameAvailability not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/checkNameAvailability`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdataprotection.CheckNameAvailabilityRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.CheckNameAvailability(req.Context(), resourceGroupNameParam, locationParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CheckNameAvailabilityResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (b *BackupVaultsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if b.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := b.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/backupVaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdataprotection.BackupVaultResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := b.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, vaultNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		b.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		b.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		b.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (b *BackupVaultsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if b.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := b.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/backupVaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := b.srv.BeginDelete(req.Context(), resourceGroupNameParam, vaultNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		b.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		b.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		b.beginDelete.remove(req)
	}

	return resp, nil
}

func (b *BackupVaultsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if b.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/backupVaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.Get(req.Context(), resourceGroupNameParam, vaultNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BackupVaultResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (b *BackupVaultsServerTransport) dispatchNewGetInResourceGroupPager(req *http.Request) (*http.Response, error) {
	if b.srv.NewGetInResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetInResourceGroupPager not implemented")}
	}
	newGetInResourceGroupPager := b.newGetInResourceGroupPager.get(req)
	if newGetInResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/backupVaults`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := b.srv.NewGetInResourceGroupPager(resourceGroupNameParam, nil)
		newGetInResourceGroupPager = &resp
		b.newGetInResourceGroupPager.add(req, newGetInResourceGroupPager)
		server.PagerResponderInjectNextLinks(newGetInResourceGroupPager, req, func(page *armdataprotection.BackupVaultsClientGetInResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetInResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		b.newGetInResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetInResourceGroupPager) {
		b.newGetInResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (b *BackupVaultsServerTransport) dispatchNewGetInSubscriptionPager(req *http.Request) (*http.Response, error) {
	if b.srv.NewGetInSubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetInSubscriptionPager not implemented")}
	}
	newGetInSubscriptionPager := b.newGetInSubscriptionPager.get(req)
	if newGetInSubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/backupVaults`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := b.srv.NewGetInSubscriptionPager(nil)
		newGetInSubscriptionPager = &resp
		b.newGetInSubscriptionPager.add(req, newGetInSubscriptionPager)
		server.PagerResponderInjectNextLinks(newGetInSubscriptionPager, req, func(page *armdataprotection.BackupVaultsClientGetInSubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetInSubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		b.newGetInSubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetInSubscriptionPager) {
		b.newGetInSubscriptionPager.remove(req)
	}
	return resp, nil
}

func (b *BackupVaultsServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if b.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := b.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/backupVaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdataprotection.PatchResourceRequestInput](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := b.srv.BeginUpdate(req.Context(), resourceGroupNameParam, vaultNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		b.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		b.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		b.beginUpdate.remove(req)
	}

	return resp, nil
}
